/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import javax.swing.table.TableModel;
import org.jfree.report.Band;
import org.jfree.report.Element;
import org.jfree.report.function.AbstractElementFormatFunction;
import org.jfree.report.function.ExpressionRuntime;
import org.jfree.report.function.FunctionUtilities;

public class HideElementIfDataAvailableExpression
extends AbstractElementFormatFunction {
    public Object getValue() {
        if (this.isDataAvailable()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean isDataAvailable() {
        ExpressionRuntime runtime = this.getRuntime();
        if (runtime == null) {
            return false;
        }
        TableModel data = runtime.getData();
        if (data == null) {
            return false;
        }
        return data.getRowCount() != 0;
    }

    protected void processRootBand(Band b) {
        boolean visible = !this.isDataAvailable();
        Element[] elements = FunctionUtilities.findAllElements(b, this.getElement());
        int i = 0;
        while (i < elements.length) {
            Element element = elements[i];
            element.setVisible(visible);
            ++i;
        }
    }
}

