/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.Serializable;
import org.jfree.report.Group;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.function.FunctionUtilities;

public class GroupCountFunction
extends AbstractFunction
implements Serializable {
    private String group;
    private String parentGroup;
    private int count;

    public GroupCountFunction() {
    }

    public GroupCountFunction(String name, String group) {
        this.setName(name);
        this.setGroup(group);
    }

    protected int getCount() {
        return this.count;
    }

    public String getGroup() {
        return this.group;
    }

    public String getParentGroup() {
        return this.parentGroup;
    }

    public Object getValue() {
        return new Integer(this.getCount());
    }

    public void groupStarted(ReportEvent event) {
        Group group = FunctionUtilities.getCurrentGroup(event);
        if (this.getParentGroup() != null && this.getParentGroup().equals(group.getName())) {
            this.setCount(0);
        }
        if (this.getGroup() == null) {
            this.setCount(this.getCount() + 1);
        } else if (this.getGroup().equals(group.getName())) {
            this.setCount(this.getCount() + 1);
        }
    }

    public void reportInitialized(ReportEvent event) {
        this.setCount(0);
    }

    protected void setCount(int count) {
        this.count = count;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setParentGroup(String group) {
        this.parentGroup = group;
    }
}

