/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import org.jfree.report.DataRow;
import org.jfree.report.ResourceBundleFactory;
import org.jfree.report.function.AbstractExpression;

public class ConvertToNumberExpression
extends AbstractExpression {
    private static final String DECIMALFORMAT_DEFAULT_PATTERN = "#,###.####################################################################################################################################################################################################################################################################################################################################################";
    private static final BigDecimal ZERO = new BigDecimal(0.0);
    private String field;
    private String format;
    private Locale locale;

    public String getField() {
        return this.field;
    }

    public String getFormat() {
        return this.format;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Object getValue() {
        DataRow dataRow = this.getDataRow();
        Object o = dataRow.get(this.field);
        if (o instanceof Number) {
            return o;
        }
        String formatString = this.getFormat();
        try {
            String effectiveFormatString = formatString == null || formatString.length() == 0 ? DECIMALFORMAT_DEFAULT_PATTERN : formatString;
            DecimalFormat format = new DecimalFormat(effectiveFormatString);
            if (this.locale != null) {
                format.setDecimalFormatSymbols(new DecimalFormatSymbols(this.getLocale()));
            } else {
                ResourceBundleFactory factory = this.getResourceBundleFactory();
                format.setDecimalFormatSymbols(new DecimalFormatSymbols(factory.getLocale()));
            }
            return format.parse(String.valueOf(o));
        }
        catch (ParseException parseException) {
            return ZERO;
        }
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

