/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter;

import java.awt.Component;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.ReportDefinition;
import org.jfree.report.filter.DataFilter;
import org.jfree.report.filter.DataSource;
import org.jfree.report.filter.ReportConnectable;
import org.jfree.report.util.ComponentDrawable;

public class ComponentDrawableFilter
implements DataFilter,
ReportConnectable {
    private DataSource source;
    private ReportDefinition reportDefinition;

    public Object clone() throws CloneNotSupportedException {
        ComponentDrawableFilter il = (ComponentDrawableFilter)super.clone();
        if (this.source != null) {
            il.source = (DataSource)this.source.clone();
        }
        il.reportDefinition = null;
        return il;
    }

    public DataSource getDataSource() {
        return this.source;
    }

    public Object getValue() {
        if (ComponentDrawableFilter.isHeadless()) {
            return null;
        }
        DataSource ds = this.getDataSource();
        if (ds == null) {
            return null;
        }
        Object o = ds.getValue();
        if (o == null) {
            return null;
        }
        if (!(o instanceof Component)) {
            return null;
        }
        ComponentDrawable cd = new ComponentDrawable();
        String allowOwnPeer = this.reportDefinition.getReportConfiguration().getConfigProperty("org.jfree.report.AllowOwnPeerForComponentDrawable");
        cd.setAllowOwnPeer("true".equals(allowOwnPeer));
        cd.setComponent((Component)o);
        return cd;
    }

    protected static boolean isHeadless() {
        return JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty("java.awt.headless", "false").equals("true");
    }

    public void registerReportDefinition(ReportDefinition reportDefinition) {
        if (this.reportDefinition != null) {
            throw new IllegalStateException("Already connected.");
        }
        if (reportDefinition == null) {
            throw new NullPointerException("The given report definition is null");
        }
        this.reportDefinition = reportDefinition;
    }

    public void setDataSource(DataSource ds) {
        this.source = ds;
    }

    public void unregisterReportDefinition(ReportDefinition reportDefinition) {
        if (this.reportDefinition != reportDefinition) {
            throw new IllegalStateException("This report definition is not registered.");
        }
        this.reportDefinition = null;
    }
}

