/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.elementfactory;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.report.Element;
import org.jfree.report.ElementAlignment;
import org.jfree.report.TextElement;
import org.jfree.report.elementfactory.TextElementFactory;
import org.jfree.report.filter.templates.LabelTemplate;
import org.jfree.report.style.FontDefinition;
import org.jfree.ui.FloatDimension;

public class LabelElementFactory
extends TextElementFactory {
    private String text;

    public Element createElement() {
        if (this.getText() == null) {
            throw new IllegalStateException("Content is not set.");
        }
        LabelTemplate template = new LabelTemplate();
        template.setContent(this.getText());
        TextElement element = new TextElement();
        element.setDataSource(template);
        this.applyElementName(element);
        this.applyStyle(element.getStyle());
        return element;
    }

    public static TextElement createLabelElement(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, ElementAlignment valign, FontDefinition font, String labeltext) {
        LabelElementFactory factory = new LabelElementFactory();
        factory.setAbsolutePosition(new Point2D.Double(bounds.getX(), bounds.getY()));
        factory.setMinimumSize((Dimension2D)new FloatDimension((float)bounds.getWidth(), (float)bounds.getHeight()));
        factory.setName(name);
        factory.setColor(paint);
        factory.setHorizontalAlignment(alignment);
        factory.setVerticalAlignment(valign);
        if (font != null) {
            factory.setFontName(font.getFontName());
            factory.setFontSize(new Integer(font.getFontSize()));
            factory.setBold(new Boolean(font.isBold()));
            factory.setItalic(new Boolean(font.isItalic()));
            factory.setEncoding(font.getFontEncoding(null));
            factory.setUnderline(new Boolean(font.isUnderline()));
            factory.setStrikethrough(new Boolean(font.isStrikeThrough()));
            factory.setEmbedFont(new Boolean(font.isEmbeddedFont()));
        }
        factory.setText(labeltext);
        return (TextElement)factory.createElement();
    }

    public static TextElement createLabelElement(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, FontDefinition font, String labeltext) {
        return LabelElementFactory.createLabelElement(name, bounds, paint, alignment, ElementAlignment.TOP, font, labeltext);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }
}

