/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.elementfactory;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import org.jfree.report.Element;
import org.jfree.report.ImageElement;
import org.jfree.report.elementfactory.ImageElementFactory;
import org.jfree.report.filter.templates.ImageURLFieldTemplate;
import org.jfree.ui.FloatDimension;

public class ImageURLFieldElementFactory
extends ImageElementFactory {
    private String fieldname;
    private URL baseURL;

    public Element createElement() {
        if (this.getFieldname() == null) {
            throw new IllegalStateException("Fieldname is not set.");
        }
        ImageURLFieldTemplate template = new ImageURLFieldTemplate();
        template.setField(this.getFieldname());
        template.setBaseURL(this.getBaseURL());
        ImageElement element = new ImageElement();
        this.applyElementName(element);
        this.applyStyle(element.getStyle());
        element.setDataSource(template);
        return element;
    }

    public static ImageElement createImageURLElement(String name, Rectangle2D bounds, String field) {
        return ImageURLFieldElementFactory.createImageURLElement(name, bounds, field, true);
    }

    public static ImageElement createImageURLElement(String name, Rectangle2D bounds, String field, boolean scale) {
        return ImageURLFieldElementFactory.createImageURLElement(name, bounds, field, scale, false);
    }

    public static ImageElement createImageURLElement(String name, Rectangle2D bounds, String field, boolean scale, boolean keepAspectRatio) {
        ImageURLFieldElementFactory factory = new ImageURLFieldElementFactory();
        factory.setName(name);
        factory.setAbsolutePosition(new Point2D.Double(bounds.getX(), bounds.getY()));
        factory.setMinimumSize((Dimension2D)new FloatDimension((float)bounds.getWidth(), (float)bounds.getHeight()));
        factory.setScale(new Boolean(scale));
        factory.setKeepAspectRatio(new Boolean(keepAspectRatio));
        factory.setFieldname(field);
        return (ImageElement)factory.createElement();
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public String getFieldname() {
        return this.fieldname;
    }

    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    public void setFieldname(String fieldname) {
        this.fieldname = fieldname;
    }
}

