/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.content;

import java.awt.Shape;
import org.jfree.report.content.Content;
import org.jfree.report.content.ContentType;
import org.jfree.report.util.geom.StrictBounds;

public class ShapeContent
implements Content {
    private Shape shape;
    private StrictBounds bounds;

    public ShapeContent(Shape s, StrictBounds bounds) {
        if (s == null) {
            throw new NullPointerException();
        }
        if (bounds == null) {
            throw new NullPointerException();
        }
        this.shape = s;
        this.bounds = (StrictBounds)bounds.clone();
    }

    public StrictBounds getBounds() {
        return (StrictBounds)this.bounds.clone();
    }

    public Content getContentForBounds(StrictBounds bounds) {
        StrictBounds newBounds = bounds.createIntersection(this.getBounds());
        return new ShapeContent(this.getShape(), newBounds);
    }

    public ContentType getContentType() {
        return ContentType.SHAPE;
    }

    public StrictBounds getMinimumContentSize() {
        return this.getBounds();
    }

    public Shape getShape() {
        return this.shape;
    }

    public void translate(long x, long y) {
        this.bounds.setRect(this.bounds.getX() + x, this.bounds.getY() + y, this.bounds.getWidth(), this.bounds.getHeight());
    }
}

