/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.content;

import java.awt.Dimension;
import org.jfree.report.Element;
import org.jfree.report.content.Content;
import org.jfree.report.content.ContentCreationException;
import org.jfree.report.content.ContentFactoryModule;
import org.jfree.report.content.DrawableContent;
import org.jfree.report.content.EmptyContent;
import org.jfree.report.layout.LayoutSupport;
import org.jfree.report.util.ElementLayoutInformation;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictDimension;
import org.jfree.report.util.geom.StrictGeomUtility;
import org.jfree.report.util.geom.StrictPoint;
import org.jfree.ui.Drawable;
import org.jfree.ui.ExtendedDrawable;

public class DrawableContentFactoryModule
implements ContentFactoryModule {
    public boolean canHandleContent(String contentType) {
        return contentType.startsWith("drawable/");
    }

    public Content createContentForElement(Element e, ElementLayoutInformation bounds, LayoutSupport ot) throws ContentCreationException {
        StrictDimension iBounds;
        Object value = e.getValue();
        Drawable drawable = (Drawable)value;
        if (drawable == null) {
            return EmptyContent.getDefaultEmptyContent();
        }
        StrictPoint point = bounds.getAbsolutePosition();
        StrictDimension preferredSize = bounds.getPreferredSize();
        if (preferredSize == null && drawable instanceof ExtendedDrawable) {
            ExtendedDrawable extDrawable = (ExtendedDrawable)drawable;
            Dimension extDim = extDrawable.getPreferredSize();
            StrictDimension drawableSize = StrictGeomUtility.createDimension(extDim.getWidth(), extDim.getHeight());
            iBounds = ElementLayoutInformation.unionMin(bounds.getMaximumSize(), drawableSize);
        } else {
            iBounds = ElementLayoutInformation.unionMin(bounds.getMaximumSize(), preferredSize);
        }
        if (iBounds.getWidth() == 0L && iBounds.getHeight() == 0L) {
            return EmptyContent.getDefaultEmptyContent();
        }
        StrictBounds drawableBounds = new StrictBounds(point.getX(), point.getY(), iBounds.getWidth(), iBounds.getHeight());
        return new DrawableContent(drawable, drawableBounds);
    }
}

