/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report;

import org.jfree.report.Element;
import org.jfree.report.filter.StringFilter;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.FontDefinition;

public class TextElement
extends Element {
    public static final String CONTENT_TYPE = "text/plain";
    private StringFilter stringfilter = new StringFilter();

    public TextElement() {
        this.setNullString(null);
    }

    public Object clone() throws CloneNotSupportedException {
        TextElement te = (TextElement)super.clone();
        te.stringfilter = (StringFilter)this.stringfilter.clone();
        return te;
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public FontDefinition getFont() {
        return this.getStyle().getFontDefinitionProperty();
    }

    public String getFontName() {
        return (String)this.getStyle().getStyleProperty(ElementStyleSheet.FONT);
    }

    public int getFontSize() {
        Integer i = (Integer)this.getStyle().getStyleProperty(ElementStyleSheet.FONTSIZE);
        return i;
    }

    public float getLineHeight() {
        Float i = (Float)this.getStyle().getStyleProperty(ElementStyleSheet.LINEHEIGHT);
        if (i == null) {
            return 0.0f;
        }
        return i.floatValue();
    }

    public String getNullString() {
        return this.stringfilter.getNullValue();
    }

    public String getReservedLiteral() {
        return (String)this.getStyle().getStyleProperty(ElementStyleSheet.RESERVED_LITERAL);
    }

    public final Object getValue() {
        this.stringfilter.setDataSource(this.getDataSource());
        return this.stringfilter.getValue();
    }

    public boolean isBold() {
        return this.getStyle().getBooleanStyleProperty(ElementStyleSheet.BOLD);
    }

    public boolean isItalic() {
        return this.getStyle().getBooleanStyleProperty(ElementStyleSheet.ITALIC);
    }

    public boolean isStrikethrough() {
        return this.getStyle().getBooleanStyleProperty(ElementStyleSheet.STRIKETHROUGH);
    }

    public boolean isUnderline() {
        return this.getStyle().getBooleanStyleProperty(ElementStyleSheet.UNDERLINED);
    }

    public void setBold(boolean bold) {
        this.getStyle().setBooleanStyleProperty(ElementStyleSheet.BOLD, bold);
    }

    public void setFont(FontDefinition font) {
        this.getStyle().setFontDefinitionProperty(font);
    }

    public void setFontName(String fontName) {
        this.getStyle().setStyleProperty(ElementStyleSheet.FONT, fontName);
    }

    public void setFontSize(int fontSize) {
        this.getStyle().setStyleProperty(ElementStyleSheet.FONTSIZE, new Integer(fontSize));
    }

    public void setItalic(boolean italic) {
        this.getStyle().setBooleanStyleProperty(ElementStyleSheet.ITALIC, italic);
    }

    public void setLineHeight(float lineHeight) {
        this.getStyle().setStyleProperty(ElementStyleSheet.LINEHEIGHT, new Float(lineHeight));
    }

    public void setNullString(String s) {
        String nstring = s == null ? "-" : s;
        this.stringfilter.setNullValue(nstring);
    }

    public void setReservedLiteral(String reservedLiteral) {
        this.getStyle().setStyleProperty(ElementStyleSheet.RESERVED_LITERAL, reservedLiteral);
    }

    public void setStrikethrough(boolean strikethrough) {
        this.getStyle().setBooleanStyleProperty(ElementStyleSheet.STRIKETHROUGH, strikethrough);
    }

    public void setUnderline(boolean underline) {
        this.getStyle().setBooleanStyleProperty(ElementStyleSheet.UNDERLINED, underline);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.getClass().getName());
        b.append("={ name=");
        b.append(this.getName());
        b.append(", font=");
        b.append(this.getStyle().getFontDefinitionProperty());
        b.append("}");
        return b.toString();
    }
}

