/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.jfree.report.ReportProcessingException;

public class ReportEventException
extends ReportProcessingException {
    private List childExceptions;

    public ReportEventException(String message, List childExceptions) {
        super(message);
        if (childExceptions == null) {
            throw new NullPointerException();
        }
        this.childExceptions = childExceptions;
    }

    public List getChildExceptions() {
        return this.childExceptions;
    }

    public String getMessage() {
        return String.valueOf(super.getMessage()) + ": " + this.childExceptions.size() + " exceptions occured.";
    }

    public void printStackTrace(PrintStream stream) {
        super.printStackTrace(stream);
        int i = 0;
        while (i < this.childExceptions.size()) {
            stream.print("Exception #");
            stream.println(i);
            Exception ex = (Exception)this.childExceptions.get(i);
            if (ex != null) {
                ex.printStackTrace(stream);
            } else {
                stream.println("<not defined>");
            }
            ++i;
        }
    }

    public void printStackTrace(PrintWriter writer) {
        super.printStackTrace(writer);
        int i = 0;
        while (i < this.childExceptions.size()) {
            writer.print("Exception #");
            writer.println(i);
            Exception ex = (Exception)this.childExceptions.get(i);
            if (ex != null) {
                ex.printStackTrace(writer);
            } else {
                writer.println("<not defined>");
            }
            ++i;
        }
    }
}

