/*
 * Decompiled with CFR 0.152.
 */
package QuasiBayesianInferences;

import BayesianInferences.Expectation;
import BayesianNetworks.BayesNet;
import BayesianNetworks.DiscreteFunction;
import BayesianNetworks.ProbabilityFunction;
import CredalSets.ConstantDensityBoundedSet;
import CredalSets.ConstantDensityRatioSet;
import CredalSets.EpsilonContaminatedSet;
import CredalSets.TotalVariationSet;
import QuasiBayesianInferences.QBInference;
import QuasiBayesianNetworks.QuasiBayesNet;

public class QBExpectation
extends Expectation {
    public QBExpectation(BayesNet b_n, boolean dpc) {
        super(b_n, dpc);
    }

    @Override
    protected void initialize_inference() {
        this.inference = new QBInference(this.bn, this.do_produce_clusters);
    }

    @Override
    protected void do_expectation_from_inference(DiscreteFunction df) {
        this.current_function = df;
        if (((QBInference)this.inference).is_inference_without_local_neighborhoods) {
            this.expectation_without_local_neighborhoods(df);
        } else {
            this.expectation_with_local_neighborhoods(df);
        }
    }

    private void expectation_with_local_neighborhoods(DiscreteFunction df) {
        int i;
        int jump = 1;
        ProbabilityFunction normalized_results = ((QBInference)this.inference).list_of_local_neighborhood_results;
        for (i = 1; i < normalized_results.number_variables(); ++i) {
            jump *= normalized_results.get_variable(i).number_values();
        }
        double min = df.get_value(0);
        double max = df.get_value(0);
        for (i = 0; i < df.number_values(); ++i) {
            if (min < df.get_value(i)) {
                min = df.get_value(i);
            }
            if (!(max > df.get_value(i))) continue;
            max = df.get_value(i);
        }
        for (int j = 0; j < jump; ++j) {
            double v = 0.0;
            for (i = 0; i < normalized_results.get_variable(0).number_values(); ++i) {
                v += df.get_value(i) * normalized_results.get_value(j + i * jump);
            }
            if (min > v) {
                min = v;
            }
            if (!(max < v)) continue;
            max = v;
        }
        this.results = new double[2];
        this.results[0] = min;
        this.results[1] = max;
    }

    private void expectation_without_local_neighborhoods(DiscreteFunction df) {
        QBInference qb_inference = (QBInference)this.inference;
        QuasiBayesNet qbn = (QuasiBayesNet)qb_inference.get_bayes_net();
        switch (qbn.get_global_neighborhood_type()) {
            case 0: {
                ProbabilityFunction res = qb_inference.get_result();
                this.results = new double[1];
                this.results[0] = res.expected_value(df);
                break;
            }
            case 2: {
                ProbabilityFunction cdr_res = new ProbabilityFunction(qb_inference.get_bucket_tree().get_unnormalized_result(), qbn);
                ConstantDensityRatioSet cdr = new ConstantDensityRatioSet(cdr_res, qbn.get_global_neighborhood_parameter());
                this.results = cdr.posterior_expected_values(df);
                break;
            }
            case 3: {
                ProbabilityFunction eps_res = new ProbabilityFunction(qb_inference.get_bucket_tree().get_unnormalized_result(), qbn);
                EpsilonContaminatedSet eps = new EpsilonContaminatedSet(eps_res, qbn.get_global_neighborhood_parameter());
                this.results = eps.posterior_expected_values(df);
                break;
            }
            case 4: {
                ProbabilityFunction cdb_res = new ProbabilityFunction(qb_inference.get_bucket_tree().get_unnormalized_result(), qbn);
                ConstantDensityBoundedSet cdb = new ConstantDensityBoundedSet(cdb_res, qbn.get_global_neighborhood_parameter());
                this.results = cdb.posterior_expected_values(df);
                break;
            }
            case 5: {
                ProbabilityFunction tv_res = new ProbabilityFunction(qb_inference.get_bucket_tree().get_unnormalized_result(), qbn);
                TotalVariationSet tv = new TotalVariationSet(tv_res, qbn.get_global_neighborhood_parameter());
                this.results = tv.posterior_expected_values(df);
            }
        }
    }
}

