/*
 * Decompiled with CFR 0.152.
 */
package JavaBayesInterface;

import JavaBayes.JavaBayes;
import JavaBayesInterface.ClearDialog;
import JavaBayesInterface.JavaBayesHelpMessages;
import JavaBayesInterface.OpenURLDialog;
import JavaBayesInterface.QuitDialog;
import java.awt.CheckboxMenuItem;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class JavaBayesConsoleFrame
extends Frame {
    private JavaBayes jb;
    FileDialog OpenFileDialog;
    FileDialog SaveFileDialog;
    TextArea textArea1;
    MenuBar mainMenuBar;
    Menu menu1;
    Menu menu2;
    Menu menu3;
    Menu menu4;
    Menu menu5;
    Menu menu6;
    Menu menu7;
    CheckboxMenuItem show_buckets;
    CheckboxMenuItem show_bayes_net;
    CheckboxMenuItem algorithm_variable_elimination;
    CheckboxMenuItem algorithm_bucket_tree;
    CheckboxMenuItem bif_format;
    CheckboxMenuItem bugs_format;
    CheckboxMenuItem xml_format;
    CheckboxMenuItem posterior_marginal;
    CheckboxMenuItem posterior_expectation;
    CheckboxMenuItem explanation;
    CheckboxMenuItem best_configuration;
    CheckboxMenuItem sensitivity_analysis;
    static final String applet_invalid_operation = "This operation is not allowed in an applet!";
    static final String fileLabel = "File";
    static final String optionsLabel = "Options";
    static final String saveLabel = "Save format";
    static final String bifSaveLabel = "BIF format";
    static final String xmlSaveLabel = "XML format";
    static final String bugsSaveLabel = "BUGS format";
    static final String open_dialog_title = "Open";
    static final String save_dialog_title = "Save";
    static final String open_menuitem_title = "Open...";
    static final String open_url_menuitem_title = "Open URL...";
    static final String save_menuitem_title = "Save";
    static final String save_as_menuitem_title = "Save as...";
    static final String clear_menuitem_title = "Clear";
    static final String dump_console_menuitem_title = "Dump console...";
    static final String quit_menuitem_title = "Quit";
    static final String show_bayes_net_title = "Bayesian network";
    static final String show_buckets_title = "Bucket tree";
    static final String algorithm_variable_elimination_title = "Variable elimination";
    static final String algorithm_bucket_tree_title = "Junction tree";
    static final String what_to_show_title = "What to show";
    static final String algorithm_title = "Algorithm";
    static final String inference_mode_title = "Inference mode";
    static final String posterior_marginal_title = "Posterior marginal";
    static final String posterior_expectation_title = "Posterior expectation";
    static final String explanation_title = "Estimate explanatory variables";
    static final String best_configuration_title = "Find complete explanation";
    static final String sensitivity_analysis_title = "Sensitivity analysis";
    static final String help_title = "Help";
    static final String about_title = "About";

    void BucketTree_Action() {
        this.jb.what_to_show_bucket_tree_action(this.show_buckets.getState());
    }

    void BayesianNetwork_Action() {
        this.jb.what_to_show_bayesian_network_action(this.show_bayes_net.getState());
    }

    void PosteriorExpectation_Action() {
        CheckboxMenuItem active_item = this.update_checkbox_menu(this.menu2, this.posterior_expectation, this.posterior_marginal);
        if (active_item == this.posterior_expectation) {
            this.jb.posterior_expectation_action();
        } else {
            this.jb.posterior_marginal_action();
        }
    }

    void PosteriorMarginal_Action() {
        CheckboxMenuItem active_item = this.update_checkbox_menu(this.menu2, this.posterior_marginal, this.posterior_expectation);
        if (active_item == this.posterior_expectation) {
            this.jb.posterior_expectation_action();
        } else {
            this.jb.posterior_marginal_action();
        }
    }

    void EstimateBestConfiguration_Action() {
        CheckboxMenuItem active_item = this.update_checkbox_menu(this.menu2, this.best_configuration, this.posterior_marginal);
        if (active_item == this.posterior_marginal) {
            this.jb.posterior_marginal_action();
        } else {
            this.jb.estimate_best_configuration_action();
        }
    }

    void SensitivityAnalysis_Action() {
        CheckboxMenuItem active_item = this.update_checkbox_menu(this.menu2, this.sensitivity_analysis, this.posterior_marginal);
        if (active_item == this.posterior_marginal) {
            this.jb.posterior_marginal_action();
        } else {
            this.jb.sensitivity_analysis_action();
        }
    }

    void EstimateExplanationVariables_Action() {
        CheckboxMenuItem active_item = this.update_checkbox_menu(this.menu2, this.explanation, this.posterior_marginal);
        if (active_item == this.posterior_marginal) {
            this.jb.posterior_marginal_action();
        } else {
            this.jb.estimate_explanation_variables_action();
        }
    }

    void BifFormat_Action() {
        CheckboxMenuItem active_item = this.update_checkbox_menu(this.menu5, this.bif_format, this.xml_format);
        if (active_item == this.bif_format) {
            this.jb.bif_format_action();
        } else {
            this.jb.xml_format_action();
        }
    }

    void XmlFormat_Action() {
        CheckboxMenuItem active_item = this.update_checkbox_menu(this.menu5, this.xml_format, this.bif_format);
        if (active_item == this.xml_format) {
            this.jb.xml_format_action();
        } else {
            this.jb.bif_format_action();
        }
    }

    void BugsFormat_Action() {
        CheckboxMenuItem active_item = this.update_checkbox_menu(this.menu5, this.bugs_format, this.bif_format);
        if (active_item == this.bugs_format) {
            this.jb.bugs_format_action();
        } else {
            this.jb.bif_format_action();
        }
    }

    void AlgorithmVariableElimination_Action() {
        CheckboxMenuItem active_item = this.update_checkbox_menu(this.menu7, this.algorithm_variable_elimination, this.algorithm_bucket_tree);
        if (active_item == this.algorithm_variable_elimination) {
            this.jb.set_algorithm_variable_elimination();
        } else {
            this.jb.set_algorithm_bucket_tree();
        }
    }

    void AlgorithmBucketTree_Action() {
        CheckboxMenuItem active_item = this.update_checkbox_menu(this.menu7, this.algorithm_bucket_tree, this.algorithm_variable_elimination);
        if (active_item == this.algorithm_bucket_tree) {
            this.jb.set_algorithm_bucket_tree();
        } else {
            this.jb.set_algorithm_variable_elimination();
        }
    }

    void DumpConsoleToFile_Action() {
        if (this.jb.is_applet) {
            this.textArea1.setText(applet_invalid_operation);
            return;
        }
        this.SaveFileDialog.show();
        String filename = this.SaveFileDialog.getFile();
        if (filename == null) {
            return;
        }
        filename = this.SaveFileDialog.getDirectory() + filename;
        try {
            FileOutputStream fileout = new FileOutputStream(filename);
            PrintStream out = new PrintStream(fileout);
            String t = this.textArea1.getText();
            this.textArea1.setText("");
            out.print(t);
            out.close();
            fileout.close();
        }
        catch (IOException e) {
            this.appendText("Dump aborted: " + e + "\n");
            return;
        }
        this.appendText("\tConsole dumped.\n\n");
    }

    void Clear_Action() {
        new ClearDialog((Frame)this, this.jb, "Clear the Bayesian network?", true).show();
    }

    void Save_Action() {
        if (this.jb.is_applet) {
            this.appendText(applet_invalid_operation);
            return;
        }
        if (this.jb.get_current_save_filename() == null) {
            this.SaveAs_Action();
        } else {
            this.jb.save();
            this.appendText("\tFile saved.\n\n");
        }
    }

    void SaveAs_Action() {
        if (this.jb.is_applet) {
            this.appendText(applet_invalid_operation);
            return;
        }
        this.SaveFileDialog.show();
        String filename = this.SaveFileDialog.getFile();
        if (filename == null) {
            return;
        }
        filename = this.SaveFileDialog.getDirectory() + filename;
        if (this.jb.save(filename)) {
            this.appendText("\tFile saved.\n\n");
        } else {
            this.appendText("\tFile not saved correctly.\n\n");
        }
        this.jb.set_current_save_filename(filename);
    }

    void Open_Action() {
        if (this.jb.is_applet) {
            this.textArea1.append(applet_invalid_operation);
            return;
        }
        this.OpenFileDialog.show();
        String filename = this.OpenFileDialog.getFile();
        if (filename == null) {
            return;
        }
        filename = this.OpenFileDialog.getDirectory() + filename;
        if (this.jb.open(filename)) {
            this.appendText("\tFile loaded.\n\n");
        } else {
            this.appendText("\tFile not loaded correctly.\n\n");
        }
    }

    void Open_URL_Action() {
        new OpenURLDialog((Frame)this, this.jb, "Insert URL of network", true).show();
    }

    void Quit_Action() {
        new QuitDialog((Frame)this, this.jb, "Quit JavaBayes?", false).show();
    }

    void About_Action() {
        JavaBayesHelpMessages.show(JavaBayesHelpMessages.about_message);
    }

    public JavaBayesConsoleFrame(JavaBayes java_bayes, String title) {
        this.jb = java_bayes;
        this.setTitle(title);
        this.OpenFileDialog = new FileDialog((Frame)this, open_dialog_title, 0);
        this.SaveFileDialog = new FileDialog((Frame)this, "Save", 1);
        this.textArea1 = new TextArea();
        this.add("Center", this.textArea1);
        this.mainMenuBar = new MenuBar();
        this.menu1 = new Menu(fileLabel);
        this.menu1.add(open_menuitem_title);
        this.menu1.add(open_url_menuitem_title);
        this.menu1.add("Save");
        this.menu1.add(save_as_menuitem_title);
        this.menu1.add(clear_menuitem_title);
        this.menu1.add(dump_console_menuitem_title);
        this.menu1.addSeparator();
        this.menu1.add(quit_menuitem_title);
        this.mainMenuBar.add(this.menu1);
        this.menu4 = new Menu(optionsLabel);
        this.menu6 = new Menu(what_to_show_title);
        this.show_bayes_net = new CheckboxMenuItem(show_bayes_net_title);
        this.menu6.add(this.show_bayes_net);
        this.show_buckets = new CheckboxMenuItem(show_buckets_title);
        this.menu6.add(this.show_buckets);
        this.menu4.add(this.menu6);
        this.menu7 = new Menu(algorithm_title);
        this.algorithm_variable_elimination = new CheckboxMenuItem(algorithm_variable_elimination_title);
        this.menu7.add(this.algorithm_variable_elimination);
        this.algorithm_bucket_tree = new CheckboxMenuItem(algorithm_bucket_tree_title);
        this.menu7.add(this.algorithm_bucket_tree);
        this.menu4.add(this.menu7);
        this.menu2 = new Menu(inference_mode_title);
        this.posterior_marginal = new CheckboxMenuItem(posterior_marginal_title);
        this.menu2.add(this.posterior_marginal);
        this.posterior_expectation = new CheckboxMenuItem(posterior_expectation_title);
        this.menu2.add(this.posterior_expectation);
        this.explanation = new CheckboxMenuItem(explanation_title);
        this.menu2.add(this.explanation);
        this.best_configuration = new CheckboxMenuItem(best_configuration_title);
        this.menu2.add(this.best_configuration);
        this.menu4.add(this.menu2);
        this.menu5 = new Menu(saveLabel);
        this.bif_format = new CheckboxMenuItem(bifSaveLabel);
        this.menu5.add(this.bif_format);
        this.xml_format = new CheckboxMenuItem(xmlSaveLabel);
        this.menu5.add(this.xml_format);
        this.bugs_format = new CheckboxMenuItem(bugsSaveLabel);
        this.menu5.add(this.bugs_format);
        this.menu4.add(this.menu5);
        this.mainMenuBar.add(this.menu4);
        this.menu3 = new Menu(help_title);
        this.menu3.add(about_title);
        try {
            this.mainMenuBar.setHelpMenu(this.menu3);
        }
        catch (Exception e) {
            this.mainMenuBar.add(this.menu3);
        }
        this.setMenuBar(this.mainMenuBar);
        this.posterior_marginal.setState(true);
        this.PosteriorMarginal_Action();
        this.bif_format.setState(true);
        this.BifFormat_Action();
        this.algorithm_variable_elimination.setState(true);
        this.AlgorithmVariableElimination_Action();
        Toolkit t = Toolkit.getDefaultToolkit();
        Dimension d = t.getScreenSize();
        d.width /= 2;
        d.height /= 2;
        this.resize(d);
    }

    public JavaBayesConsoleFrame(JavaBayes jb) {
        this(jb, (String)null);
    }

    @Override
    public void show() {
        this.move(50, 50);
        super.show();
    }

    @Override
    public boolean action(Event event, Object arg) {
        if (event.target instanceof MenuItem) {
            String label = ((MenuItem)event.target).getLabel();
            if (label.equals(show_buckets_title)) {
                this.BucketTree_Action();
                return true;
            }
            if (label.equals(show_bayes_net_title)) {
                this.BayesianNetwork_Action();
                return true;
            }
            if (label.equals(posterior_expectation_title)) {
                this.PosteriorExpectation_Action();
                return true;
            }
            if (label.equals(posterior_marginal_title)) {
                this.PosteriorMarginal_Action();
                return true;
            }
            if (label.equals(best_configuration_title)) {
                this.EstimateBestConfiguration_Action();
                return true;
            }
            if (label.equals(sensitivity_analysis_title)) {
                this.SensitivityAnalysis_Action();
                return true;
            }
            if (label.equals(explanation_title)) {
                this.EstimateExplanationVariables_Action();
                return true;
            }
            if (label.equals(bifSaveLabel)) {
                this.BifFormat_Action();
                return true;
            }
            if (label.equals(xmlSaveLabel)) {
                this.XmlFormat_Action();
                return true;
            }
            if (label.equals(bugsSaveLabel)) {
                this.BugsFormat_Action();
                return true;
            }
            if (label.equals(algorithm_variable_elimination_title)) {
                this.AlgorithmVariableElimination_Action();
                return true;
            }
            if (label.equals(algorithm_bucket_tree_title)) {
                this.AlgorithmBucketTree_Action();
                return true;
            }
            if (label.equals(clear_menuitem_title)) {
                this.Clear_Action();
                return true;
            }
            if (label.equals(dump_console_menuitem_title)) {
                this.DumpConsoleToFile_Action();
            } else {
                if (label.equals("Save")) {
                    this.Save_Action();
                    return true;
                }
                if (label.equals(save_as_menuitem_title)) {
                    this.SaveAs_Action();
                    return true;
                }
                if (label.equals(open_menuitem_title)) {
                    this.Open_Action();
                    return true;
                }
            }
            if (label.equals(open_url_menuitem_title)) {
                this.Open_URL_Action();
                return true;
            }
            if (label.equals(quit_menuitem_title)) {
                this.Quit_Action();
                return true;
            }
            if (label.equals(about_title)) {
                this.About_Action();
                return true;
            }
        }
        return super.action(event, arg);
    }

    @Override
    public boolean handleEvent(Event evt) {
        if (evt.id == 201 && this.jb != null) {
            new QuitDialog((Frame)this, this.jb, "Quit JavaBayes?", false).show();
        }
        return super.handleEvent(evt);
    }

    public void appendText(String text) {
        this.textArea1.appendText(text);
    }

    private CheckboxMenuItem update_checkbox_menu(Menu m, CheckboxMenuItem cur, CheckboxMenuItem def) {
        boolean s = cur.getState();
        if (!s) {
            def.setState(true);
            return def;
        }
        for (int i = 0; i < m.countItems(); ++i) {
            ((CheckboxMenuItem)m.getItem(i)).setState(false);
        }
        cur.setState(true);
        return cur;
    }
}

