/*
 * Decompiled with CFR 0.152.
 */
package JavaBayesInterface;

import InferenceGraphs.InferenceGraph;
import InferenceGraphs.InferenceGraphNode;
import JavaBayesInterface.EditFunctionDialog;
import JavaBayesInterface.EditFunctionPanel;
import JavaBayesInterface.EditorFrame;
import JavaBayesInterface.FunctionTablePanel;
import java.awt.BorderLayout;
import java.awt.Label;
import java.util.Enumeration;
import java.util.Vector;

class EditProbability
extends EditFunctionPanel {
    EditFunctionDialog parent_dialog;
    InferenceGraph ig;
    InferenceGraphNode node;
    String[] all_variable_names;
    String[][] all_variable_values;
    double[] probability_values;
    FunctionTablePanel probability_table;

    public EditProbability(EditFunctionDialog parent_dialog, InferenceGraph i_g, InferenceGraphNode i_g_n) {
        this.parent_dialog = parent_dialog;
        this.ig = i_g;
        this.node = i_g_n;
        double[] original_probability_values = this.node.get_function_values();
        this.probability_values = new double[original_probability_values.length];
        for (int i = 0; i < this.probability_values.length; ++i) {
            this.probability_values[i] = original_probability_values[i];
        }
        this.all_variable_names = this.node.get_all_names();
        this.all_variable_values = this.node.get_all_values();
        Label probability_name = this.create_probability_name();
        this.probability_table = new FunctionTablePanel(this.all_variable_names, this.all_variable_values, this.probability_values);
        this.setLayout(new BorderLayout());
        this.add("North", probability_name);
        this.add("Center", this.probability_table);
    }

    private Label create_probability_name() {
        StringBuffer name = new StringBuffer("p(");
        name.append(this.node.get_name());
        if (this.node.hasParent()) {
            name.append(" |");
            Vector parents = this.node.get_parents();
            Enumeration e = parents.elements();
            while (e.hasMoreElements()) {
                name.append(" " + ((InferenceGraphNode)e.nextElement()).get_name() + ",");
            }
            name.setCharAt(name.length() - 1, ')');
        } else {
            name.append(")");
        }
        return new Label(name.toString(), 1);
    }

    @Override
    void accept() {
        double EPSILON = 1.0E-6;
        this.probability_values = this.probability_table.get_table();
        int number_values = this.node.get_number_values();
        int number_conditioning_values = this.probability_values.length / number_values;
        double[] verification_counters = new double[number_conditioning_values];
        for (int i = 0; i < this.probability_values.length; ++i) {
            int n = i % number_conditioning_values;
            verification_counters[n] = verification_counters[n] + this.probability_values[i];
        }
        for (int j = 0; j < verification_counters.length; ++j) {
            if (!(Math.abs(verification_counters[j] - 1.0) >= EPSILON) || !(this.parent_dialog.parent instanceof EditorFrame)) continue;
            EditorFrame ef = (EditorFrame)this.parent_dialog.parent;
            ef.jb.appendText("Some of the probability values you have edited add up to " + verification_counters[j] + ". Please check it.\n\n");
        }
        this.node.set_function_values(this.probability_values);
    }

    @Override
    void dismiss() {
    }
}

