/*
 * Decompiled with CFR 0.152.
 */
package CredalSets;

import BayesianNetworks.DiscreteFunction;
import BayesianNetworks.ProbabilityFunction;
import BayesianNetworks.ProbabilityVariable;
import CredalSets.Bracketing;
import CredalSets.FinitelyGeneratedSet;
import CredalSets.GeneralizedChoquetIntegral;
import CredalSets.MappingDouble;
import CredalSets.QBProbabilityFunction;

public abstract class TwoMonotoneCapacity
extends FinitelyGeneratedSet
implements MappingDouble {
    private DiscreteFunction temporary_discrete_function;
    private static final int LOWER_EXPECTATION_BRACKET = 0;
    private static final int UPPER_EXPECTATION_BRACKET = 1;
    private static final double ACCURACY = 1.0E-7;

    public TwoMonotoneCapacity(ProbabilityFunction pf) {
        super((DiscreteFunction)pf, pf.get_values());
    }

    public abstract double get_lower_probability_from_base(double var1);

    public abstract double get_upper_probability_from_base(double var1);

    public abstract double get_atom_probability(int var1);

    public ProbabilityFunction posterior_marginal() {
        double[] lower_values = new double[this.values.length];
        double[] upper_values = new double[this.values.length];
        DiscreteFunction df = new DiscreteFunction(1, this.values.length);
        if (this.variables[0] instanceof ProbabilityVariable && ((ProbabilityVariable)this.variables[0]).is_observed()) {
            for (int i = 0; i < this.values.length; ++i) {
                lower_values[i] = this.values[i];
                upper_values[i] = this.values[i];
            }
        } else {
            int i;
            double total = 0.0;
            for (i = 0; i < this.values.length; ++i) {
                total += this.values[i];
            }
            for (i = 0; i < this.values.length; ++i) {
                lower_values[i] = this.get_lower_probability_from_base(this.values[i]) / (this.get_lower_probability_from_base(this.values[i]) + this.get_upper_probability_from_base(total - this.values[i]));
            }
            for (i = 0; i < this.values.length; ++i) {
                upper_values[i] = this.get_upper_probability_from_base(this.values[i]) / (this.get_upper_probability_from_base(this.values[i]) + this.get_lower_probability_from_base(total - this.values[i]));
            }
        }
        return new QBProbabilityFunction(this, (double[])null, lower_values, upper_values);
    }

    public double[] expected_values(DiscreteFunction df) {
        double[] results = new double[2];
        if (this.variables[0] instanceof ProbabilityVariable && ((ProbabilityVariable)this.variables[0]).is_observed()) {
            results[0] = df.get_value(((ProbabilityVariable)this.variables[0]).get_observed_index());
            results[1] = results[0];
            return results;
        }
        GeneralizedChoquetIntegral gci = new GeneralizedChoquetIntegral(this, df);
        return gci.results;
    }

    public double[] posterior_expected_values(DiscreteFunction df) {
        Bracketing bracket = new Bracketing();
        double[] results = new double[2];
        if (this.variables[0] instanceof ProbabilityVariable && ((ProbabilityVariable)this.variables[0]).is_observed()) {
            results[0] = df.get_value(((ProbabilityVariable)this.variables[0]).get_observed_index());
            results[1] = results[0];
            return results;
        }
        double max_df_value = df.get_value(0);
        double min_df_value = df.get_value(0);
        for (int i = 1; i < df.number_values(); ++i) {
            if (max_df_value < df.get_value(i)) {
                max_df_value = df.get_value(i);
            }
            if (!(min_df_value > df.get_value(i))) continue;
            min_df_value = df.get_value(i);
        }
        this.temporary_discrete_function = df;
        double lower_expectation = bracket.perform(this, 0, min_df_value, max_df_value, 1.0E-7);
        double upper_expectation = bracket.perform(this, 1, min_df_value, max_df_value, 1.0E-7);
        results[0] = lower_expectation;
        results[1] = upper_expectation;
        return results;
    }

    @Override
    public double map(int map_type, double map_input) {
        DiscreteFunction tdf = this.temporary_discrete_function;
        double[] new_values = new double[tdf.number_values()];
        for (int i = 0; i < new_values.length; ++i) {
            new_values[i] = tdf.get_value(i) - map_input;
        }
        DiscreteFunction mtdf = new DiscreteFunction(tdf.get_variables(), new_values);
        GeneralizedChoquetIntegral gci = new GeneralizedChoquetIntegral(this, mtdf);
        if (map_type == 0) {
            return gci.results[0];
        }
        return gci.results[1];
    }
}

