/*
 * Decompiled with CFR 0.152.
 */
package CredalSets;

import BayesianNetworks.ProbabilityFunction;
import CredalSets.TwoMonotoneCapacity;

public class ConstantDensityBoundedSet
extends TwoMonotoneCapacity {
    private double k;

    public ConstantDensityBoundedSet(ProbabilityFunction pf, double kk) {
        super(pf);
        this.k = kk;
        if (this.k <= 0.0) {
            this.k = 1.0;
        } else if (this.k < 1.0) {
            this.k = 1.0 / this.k;
        }
    }

    @Override
    public double get_lower_probability_from_base(double p) {
        return Math.max(p / this.k, 1.0 - this.k * (1.0 - p));
    }

    @Override
    public double get_upper_probability_from_base(double p) {
        return Math.min(this.k * p, 1.0 - (1.0 - p) / this.k);
    }

    @Override
    public double get_atom_probability(int index) {
        return this.values[index];
    }
}

