/*
 * Decompiled with CFR 0.152.
 */
package BayesianNetworks;

import BayesianNetworks.BayesNet;
import BayesianNetworks.DiscreteFunction;
import BayesianNetworks.DiscreteVariable;
import BayesianNetworks.ProbabilityVariable;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public class ProbabilityFunction
extends DiscreteFunction {
    protected Vector properties;
    protected BayesNet bn;

    public ProbabilityFunction() {
    }

    public ProbabilityFunction(BayesNet b_n, int n_vb, int n_vl, Vector prop) {
        super(n_vb, n_vl);
        this.properties = prop;
        this.bn = b_n;
    }

    public ProbabilityFunction(BayesNet b_n, DiscreteVariable[] pvs, double[] v, Vector prop) {
        super(pvs, v);
        this.properties = prop;
        this.bn = b_n;
    }

    public ProbabilityFunction(DiscreteFunction df, double[] new_values) {
        super(df.variables, new_values);
        if (df instanceof ProbabilityFunction) {
            this.bn = ((ProbabilityFunction)df).bn;
            this.properties = ((ProbabilityFunction)df).properties;
        }
    }

    public ProbabilityFunction(DiscreteFunction df, BayesNet b_n) {
        super(df.variables, df.values);
        this.bn = b_n;
        if (df instanceof ProbabilityFunction) {
            this.properties = ((ProbabilityFunction)df).properties;
        }
    }

    void process_properties() {
    }

    public void set_value(String[][] variable_value_pairs, double val) {
        int[] value_indexes = new int[this.bn.probability_variables.length];
        for (int i = 0; i < variable_value_pairs.length; ++i) {
            int index = this.bn.index_of_variable(variable_value_pairs[i][0]);
            ProbabilityVariable pv = this.bn.probability_variables[index];
            value_indexes[index] = pv.index_of_value(variable_value_pairs[i][1]);
        }
        int pos = this.get_position_from_indexes(this.bn.probability_variables, value_indexes);
        this.values[pos] = val;
    }

    public double evaluate(String[][] variable_value_pairs) {
        int[] value_indexes = new int[this.bn.probability_variables.length];
        for (int i = 0; i < variable_value_pairs.length; ++i) {
            int index = this.bn.index_of_variable(variable_value_pairs[i][0]);
            ProbabilityVariable pv = this.bn.probability_variables[index];
            value_indexes[index] = pv.index_of_value(variable_value_pairs[i][1]);
        }
        return this.evaluate(value_indexes);
    }

    public double evaluate(int[] value_indexes) {
        return super.evaluate(this.bn.probability_variables, value_indexes);
    }

    public int get_position_from_indexes(int[] variable_indexes) {
        return super.get_position_from_indexes(this.bn.probability_variables, variable_indexes);
    }

    public double expected_value(DiscreteFunction df) {
        double ev = 0.0;
        for (int i = 0; i < df.values.length; ++i) {
            ev += this.values[i] * df.values[i];
        }
        return ev;
    }

    public double posterior_expected_value(DiscreteFunction df) {
        double ev = 0.0;
        double p = 0.0;
        for (int i = 0; i < df.values.length; ++i) {
            p += this.values[i];
            ev += this.values[i] * df.values[i];
        }
        return ev / p;
    }

    public double variance(DiscreteFunction df) {
        double ev = 0.0;
        double evv = 0.0;
        for (int i = 0; i < df.values.length; ++i) {
            double aux = this.values[i] * df.values[i];
            ev += aux;
            evv = df.values[i] * aux;
        }
        return evv - ev * ev;
    }

    public void save_xml_0_3(PrintStream out) {
        int size_of_first = 0;
        int size_of_others = 1;
        out.println("<DEFINITION>");
        if (this.variables != null) {
            int j;
            out.println("\t<FOR>" + this.variables[0].name + "</FOR>");
            for (j = 1; j < this.variables.length; ++j) {
                out.println("\t<GIVEN>" + this.variables[j].name + "</GIVEN>");
            }
            out.print("\t<TABLE>");
            if (this.variables.length > 1) {
                size_of_first = this.variables[0].number_values();
                for (j = 1; j < this.variables.length; ++j) {
                    size_of_others *= this.variables[j].number_values();
                }
                for (int i = 0; i < size_of_others; ++i) {
                    for (j = 0; j < size_of_first; ++j) {
                        out.print(this.values[j * size_of_others + i] + " ");
                    }
                }
            } else {
                for (j = 0; j < this.values.length; ++j) {
                    out.print(this.values[j] + " ");
                }
            }
            out.println("</TABLE>");
        }
        if (this.properties != null && this.properties.size() > 0) {
            Enumeration e = this.properties.elements();
            while (e.hasMoreElements()) {
                String property = (String)e.nextElement();
                out.println("\t<PROPERTY>" + property + "</PROPERTY>");
            }
        }
        out.println("</DEFINITION>\n");
    }

    public void save_xml(PrintStream out) {
        out.println("<PROBABILITY>");
        if (this.variables != null) {
            int j;
            out.println("\t<FOR>" + this.variables[0].name + "</FOR>");
            for (j = 1; j < this.variables.length; ++j) {
                out.println("\t<GIVEN>" + this.variables[j].name + "</GIVEN>");
            }
            out.print("\t<TABLE>");
            for (j = 0; j < this.values.length; ++j) {
                out.print(this.values[j] + " ");
            }
            out.println("</TABLE>");
        }
        if (this.properties != null && this.properties.size() > 0) {
            Enumeration e = this.properties.elements();
            while (e.hasMoreElements()) {
                String property = (String)e.nextElement();
                out.println("\t<PROPERTY>" + property + "</PROPERTY>");
            }
        }
        out.println("</PROBABILITY>\n");
    }

    @Override
    public void print(PrintStream out) {
        if (this.variables != null) {
            int j;
            out.print("probability ( ");
            for (j = 0; j < this.variables.length; ++j) {
                out.print(" \"" + this.variables[j].name + "\" ");
            }
            out.print(") {");
            out.println(" //" + this.variables.length + " variable(s) and " + this.values.length + " values");
            out.println("\ttable ");
            if (this.variables.length == 1) {
                for (j = 0; j < this.values.length; ++j) {
                    out.print("\t\t" + this.values[j]);
                    if (j == this.values.length - 1) {
                        out.print("; ");
                    }
                    out.print("\t// p(" + this.variables[0].values[j] + " | evidence )");
                    if (j == this.values.length - 1) continue;
                    out.println();
                }
            } else {
                out.print("\t\t");
                for (j = 0; j < this.values.length; ++j) {
                    out.print(" " + this.values[j]);
                }
            }
            out.print(";");
        }
        out.println();
        if (this.properties != null && this.properties.size() > 0) {
            Enumeration e = this.properties.elements();
            while (e.hasMoreElements()) {
                String property = (String)e.nextElement();
                out.println("\tproperty \"" + property + "\" ;");
            }
        }
        out.println("}");
    }

    public Vector get_properties() {
        return this.properties;
    }

    public void set_properties(Vector prop) {
        this.properties = prop;
    }

    public Enumeration get_enumerated_properties() {
        return this.properties.elements();
    }

    public void add_property(String prop) {
        if (this.properties == null) {
            this.properties = new Vector();
        }
        this.properties.addElement(prop);
    }

    public void remove_property(String prop) {
        if (this.properties == null) {
            return;
        }
        this.properties.removeElement(prop);
    }

    public void remove_property(int i) {
        if (this.properties == null) {
            return;
        }
        this.properties.removeElementAt(i);
    }
}

