/*
 * Decompiled with CFR 0.152.
 */
package BayesianNetworks;

import BayesianNetworks.DiscreteFunction;
import BayesianNetworks.ProbabilityVariable;
import java.io.PrintStream;

public class DiscreteVariable {
    protected String name;
    protected int index;
    protected String[] values;

    public DiscreteVariable() {
        this.name = null;
        this.index = -1;
        this.values = null;
    }

    public DiscreteVariable(String n_vb) {
        this.name = n_vb;
        this.index = -1;
        this.values = null;
    }

    public DiscreteVariable(String vb, int vi, String[] vl) {
        this.name = vb;
        this.index = vi;
        this.values = vl;
    }

    public DiscreteVariable(DiscreteVariable dv) {
        this.name = dv.name;
        this.index = dv.index;
        this.values = dv.values;
    }

    public int index_of_value(String value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.values[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    public DiscreteFunction get_numeric_values() {
        DiscreteVariable[] dvs = new ProbabilityVariable[]{this};
        double[] numeric_values = new double[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            try {
                Double daux = Double.valueOf(this.values[i]);
                numeric_values[i] = daux;
                continue;
            }
            catch (NumberFormatException e) {
                numeric_values[i] = i;
            }
        }
        return new DiscreteFunction(dvs, numeric_values);
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream out) {
        if (this == null) {
            return;
        }
        out.print("variable ");
        if (this.name != null) {
            out.print(" \"" + this.name + "\" ");
        }
        out.print("{");
        if (this.values != null) {
            out.println("//" + this.values.length + " values");
            out.print("\ttype discrete[" + this.values.length + "] { ");
            for (int i = 0; i < this.values.length; ++i) {
                out.print(" \"" + this.values[i] + "\" ");
            }
            out.println("};");
        }
        out.println("}");
    }

    public String get_name() {
        return this.name;
    }

    public void set_name(String n) {
        this.name = n;
    }

    public int get_index() {
        return this.index;
    }

    public int number_values() {
        return this.values.length;
    }

    public String[] get_values() {
        return this.values;
    }

    public void set_values(String[] vals) {
        this.values = vals;
    }

    public String get_value(int i) {
        return this.values[i];
    }
}

