/*
 * Decompiled with CFR 0.152.
 */
package BayesianNetworks;

import BayesianNetworks.DiscreteVariable;
import java.io.PrintStream;

public class DiscreteFunction {
    protected DiscreteVariable[] variables;
    protected double[] values;

    public DiscreteFunction() {
    }

    public DiscreteFunction(int n_vb, int n_vl) {
        this.variables = new DiscreteVariable[n_vb];
        this.values = new double[n_vl];
    }

    public DiscreteFunction(DiscreteVariable[] pvs, double[] v) {
        this.variables = pvs;
        this.values = v;
    }

    public boolean memberOf(int index) {
        for (int i = 0; i < this.variables.length; ++i) {
            if (index != this.variables[i].index) continue;
            return true;
        }
        return false;
    }

    boolean same_variables(DiscreteFunction df) {
        if (this.variables.length != df.variables.length) {
            return false;
        }
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variables[i] == df.variables[i]) continue;
            return false;
        }
        return true;
    }

    public double evaluate(DiscreteVariable[] pvs, int[] value_indexes) {
        int position = this.get_position_from_indexes(pvs, value_indexes);
        return this.values[position];
    }

    public int get_position_from_indexes(DiscreteVariable[] pvs, int[] variable_indexes) {
        int pos = 0;
        int jump = 1;
        for (int i = this.variables.length - 1; i >= 0; --i) {
            int k = this.variables[i].index;
            pos += variable_indexes[k] * jump;
            jump *= pvs[k].values.length;
        }
        return pos;
    }

    public DiscreteFunction sum_out(DiscreteVariable[] dvs, boolean[] markers) {
        int i;
        int[] indexes = new int[dvs.length];
        int[] value_lengths = new int[dvs.length];
        for (i = 0; i < dvs.length; ++i) {
            indexes[i] = 0;
            value_lengths[i] = dvs[i].number_values();
        }
        int number_of_variables_to_sum_out = 0;
        int number_of_variables_to_stay = 0;
        int number_of_values_new_df = 1;
        int number_of_values_to_sum_out = 1;
        for (i = 0; i < this.variables.length; ++i) {
            if (markers[this.variables[i].get_index()]) {
                ++number_of_variables_to_sum_out;
                number_of_values_to_sum_out *= this.variables[i].number_values();
                continue;
            }
            ++number_of_variables_to_stay;
            number_of_values_new_df *= this.variables[i].number_values();
        }
        if (number_of_variables_to_stay == 0) {
            return null;
        }
        if (number_of_variables_to_sum_out == 0) {
            return new DiscreteFunction(this.variables, this.values);
        }
        int[] index_for_variables_to_sum_out = new int[number_of_variables_to_sum_out];
        DiscreteFunction new_df = new DiscreteFunction(number_of_variables_to_stay, number_of_values_new_df);
        int j = 0;
        int k = 0;
        for (i = 0; i < this.variables.length; ++i) {
            if (markers[this.variables[i].get_index()]) {
                index_for_variables_to_sum_out[k] = this.variables[i].get_index();
                ++k;
                continue;
            }
            new_df.set_variable(j, this.variables[i]);
            ++j;
        }
        int last_new_df = new_df.number_variables() - 1;
        int last_index_for_variables_to_sum_out = index_for_variables_to_sum_out.length - 1;
        for (i = 0; i < new_df.number_values(); ++i) {
            int current;
            double v = 0.0;
            for (j = 0; j < index_for_variables_to_sum_out.length; ++j) {
                indexes[index_for_variables_to_sum_out[j]] = 0;
            }
            for (j = 0; j < number_of_values_to_sum_out; ++j) {
                v += this.evaluate(dvs, indexes);
                int n = index_for_variables_to_sum_out[last_index_for_variables_to_sum_out];
                indexes[n] = indexes[n] + 1;
                for (k = last_index_for_variables_to_sum_out; k > 0 && indexes[current = index_for_variables_to_sum_out[k]] >= value_lengths[current]; --k) {
                    indexes[current] = 0;
                    int n2 = index_for_variables_to_sum_out[k - 1];
                    indexes[n2] = indexes[n2] + 1;
                }
            }
            new_df.set_value(i, v);
            int n = new_df.get_index(last_new_df);
            indexes[n] = indexes[n] + 1;
            for (j = last_new_df; j > 0 && indexes[current = new_df.get_index(j)] >= value_lengths[current]; --j) {
                indexes[current] = 0;
                int n3 = new_df.get_index(j - 1);
                indexes[n3] = indexes[n3] + 1;
            }
        }
        return new_df;
    }

    public DiscreteFunction multiply(DiscreteVariable[] dvs, DiscreteFunction mult) {
        int k;
        int j;
        int i;
        boolean[] variable_markers = new boolean[dvs.length];
        int[] indexes = new int[dvs.length];
        int[] value_lengths = new int[dvs.length];
        for (i = 0; i < dvs.length; ++i) {
            indexes[i] = 0;
            value_lengths[i] = dvs[i].number_values();
            variable_markers[i] = false;
        }
        int n = 0;
        for (j = 0; j < this.number_variables(); ++j) {
            k = this.get_index(j);
            if (variable_markers[k]) continue;
            variable_markers[k] = true;
            ++n;
        }
        for (j = 0; j < mult.number_variables(); ++j) {
            k = mult.get_index(j);
            if (variable_markers[k]) continue;
            variable_markers[k] = true;
            ++n;
        }
        int[] joined_indexes = new int[n];
        j = 0;
        int v = 1;
        for (i = 0; i < variable_markers.length; ++i) {
            if (!variable_markers[i]) continue;
            joined_indexes[j] = i;
            ++j;
            v *= dvs[i].number_values();
        }
        DiscreteFunction new_df = new DiscreteFunction(n, v);
        for (i = 0; i < n; ++i) {
            new_df.set_variable(i, dvs[joined_indexes[i]]);
        }
        int last_new_df = new_df.number_variables() - 1;
        for (i = 0; i < new_df.number_values(); ++i) {
            int current;
            double t = this.evaluate(dvs, indexes) * mult.evaluate(dvs, indexes);
            new_df.set_value(i, t);
            int n2 = new_df.get_index(last_new_df);
            indexes[n2] = indexes[n2] + 1;
            for (j = last_new_df; j > 0 && indexes[current = new_df.get_index(j)] >= value_lengths[current]; --j) {
                indexes[current] = 0;
                int n3 = new_df.get_index(j - 1);
                indexes[n3] = indexes[n3] + 1;
            }
        }
        return new_df;
    }

    public void normalize() {
        int i;
        double total = 0.0;
        for (i = 0; i < this.values.length; ++i) {
            total += this.values[i];
        }
        if (total > 0.0) {
            for (i = 0; i < this.values.length; ++i) {
                this.values[i] = this.values[i] / total;
            }
        }
    }

    public void normalize_first() {
        int i;
        int jump = 1;
        for (i = 1; i < this.variables.length; ++i) {
            jump *= this.variables[i].values.length;
        }
        for (i = 0; i < jump; ++i) {
            int j;
            double n = 0.0;
            for (j = 0; j < this.variables[0].values.length; ++j) {
                n += this.values[i + j * jump];
            }
            if (!(n > 0.0)) continue;
            for (j = 0; j < this.variables[0].values.length; ++j) {
                this.values[i + j * jump] = this.values[i + j * jump] / n;
            }
        }
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream out) {
        if (this.variables != null) {
            int j;
            out.print("discrete function ( ");
            for (j = 0; j < this.variables.length; ++j) {
                out.print(" \"" + this.variables[j].name + "\" ");
            }
            out.print(") {");
            out.println(" //" + this.variables.length + " variable(s) and " + this.values.length + " values");
            out.print("\ttable ");
            for (j = 0; j < this.values.length; ++j) {
                out.print(this.values[j] + " ");
            }
            out.print(";");
        }
        out.println();
        out.println("}");
    }

    public int number_variables() {
        return this.variables.length;
    }

    public int number_values() {
        return this.values.length;
    }

    public DiscreteVariable[] get_variables() {
        return this.variables;
    }

    public DiscreteVariable get_variable(int index) {
        return this.variables[index];
    }

    public int[] get_indexes() {
        int[] ind = new int[this.variables.length];
        for (int i = 0; i < ind.length; ++i) {
            ind[i] = this.variables[i].index;
        }
        return ind;
    }

    public int get_index(int ind) {
        return this.variables[ind].index;
    }

    public double[] get_values() {
        return this.values;
    }

    public double get_value(int index) {
        return this.values[index];
    }

    public void set_value(int index, double v) {
        this.values[index] = v;
    }

    public void set_values(double[] vs) {
        this.values = vs;
    }

    public void set_variable(int index, DiscreteVariable dv) {
        this.variables[index] = dv;
    }
}

