/*
 * Decompiled with CFR 0.152.
 */
package BayesianNetworks;

import BayesianNetworks.BayesNet;
import BayesianNetworks.DiscreteVariable;
import BayesianNetworks.ProbabilityFunction;
import BayesianNetworks.ProbabilityVariable;
import InterchangeFormat.IFBayesNet;
import InterchangeFormat.IFProbabilityEntry;
import InterchangeFormat.IFProbabilityFunction;
import InterchangeFormat.IFProbabilityVariable;
import InterchangeFormat.InterchangeFormat;
import java.util.Enumeration;
import java.util.Vector;

public class ConvertInterchangeFormat {
    InterchangeFormat ifo;

    public ConvertInterchangeFormat(InterchangeFormat inter_format) {
        this.ifo = inter_format;
    }

    public String get_name() {
        IFBayesNet ifbn = this.ifo.get_ifbn();
        if (ifbn == null) {
            return null;
        }
        return ifbn.get_name();
    }

    public Vector get_properties() {
        IFBayesNet ifbn = this.ifo.get_ifbn();
        if (ifbn == null) {
            return null;
        }
        return ifbn.get_properties();
    }

    public ProbabilityVariable[] get_probability_variables(BayesNet bn) {
        IFBayesNet ifbn = this.ifo.get_ifbn();
        if (ifbn == null) {
            return null;
        }
        Vector pvs = ifbn.get_pvs();
        ProbabilityVariable[] probability_variables = new ProbabilityVariable[pvs.size()];
        Enumeration e = pvs.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            IFProbabilityVariable ipv = (IFProbabilityVariable)e.nextElement();
            probability_variables[i] = new ProbabilityVariable(bn, ipv.get_name(), i, ipv.get_values(), ipv.get_properties());
            ++i;
        }
        return probability_variables;
    }

    public ProbabilityFunction[] get_probability_functions(BayesNet bn) {
        IFBayesNet ifbn = this.ifo.get_ifbn();
        if (ifbn == null) {
            return null;
        }
        Vector upfs = ifbn.get_upfs();
        ProbabilityFunction[] probability_functions = new ProbabilityFunction[upfs.size()];
        Enumeration e = upfs.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            IFProbabilityFunction upf = (IFProbabilityFunction)e.nextElement();
            probability_functions[i] = this.get_probability_function(bn, upf);
            ++i;
        }
        return probability_functions;
    }

    protected ProbabilityFunction get_probability_function(BayesNet bn, IFProbabilityFunction upf) {
        int i;
        DiscreteVariable[] variables = this.create_variables(bn, upf);
        int jump = 1;
        for (i = 1; i < variables.length; ++i) {
            ProbabilityVariable pv = variables[i];
            jump *= pv.values.length;
        }
        int number_of_values = jump * variables[0].values.length;
        double[] values = new double[number_of_values];
        for (i = 0; i < values.length; ++i) {
            values[i] = -1.0;
        }
        this.process_tables(upf, values);
        this.process_defaults(upf, values, jump);
        this.process_entries(bn, upf, (ProbabilityVariable[])variables, values, jump);
        this.finish_values(values);
        return new ProbabilityFunction(bn, variables, values, upf.get_properties());
    }

    protected ProbabilityVariable[] create_variables(BayesNet bn, IFProbabilityFunction upf) {
        String[] ss_variables = upf.get_variables();
        ProbabilityVariable[] variables = new ProbabilityVariable[ss_variables.length];
        for (int i = 0; i < ss_variables.length; ++i) {
            int index = bn.index_of_variable(ss_variables[i]);
            if (index == -1) continue;
            variables[i] = bn.probability_variables[index];
        }
        return variables;
    }

    protected void process_tables(IFProbabilityFunction upf, double[] values) {
        Vector ttables = upf.get_tables();
        if (ttables.size() > 0) {
            double[] ttable = (double[])ttables.firstElement();
            this.copy_table_to_values(ttable, values);
        }
    }

    protected void copy_table_to_values(double[] table, double[] values) {
        for (int i = 0; i < table.length && i < values.length; ++i) {
            values[i] = table[i];
        }
    }

    void process_defaults(IFProbabilityFunction upf, double[] values, int jump) {
        Vector ddefaultss = upf.get_defaults();
        if (ddefaultss.size() > 0) {
            double[] ddefaults = (double[])ddefaultss.firstElement();
            for (int i = 0; i < values.length; ++i) {
                for (int j = 0; j < jump; ++j) {
                    int k = i * jump + j;
                    if (values[k] != -1.0) continue;
                    values[k] = ddefaults[i];
                }
            }
        }
    }

    void process_entries(BayesNet bn, IFProbabilityFunction upf, ProbabilityVariable[] variables, double[] values, int jump) {
        Vector eentries = upf.get_entries();
        if (eentries != null && eentries.size() > 0) {
            Enumeration e = eentries.elements();
            while (e.hasMoreElements()) {
                int k;
                ProbabilityVariable pv;
                int i;
                IFProbabilityEntry entry = (IFProbabilityEntry)e.nextElement();
                String[] eentry_values = entry.get_values();
                double[] eentry_entries = entry.get_entries();
                int[] entry_value_indexes = new int[eentry_values.length];
                for (i = 0; i < entry_value_indexes.length; ++i) {
                    pv = variables[i + 1];
                    entry_value_indexes[i] = pv.index_of_value(eentry_values[i]);
                }
                int pos = 0;
                int step = 1;
                for (k = entry_value_indexes.length; k > 0; --k) {
                    pos += entry_value_indexes[k - 1] * step;
                    step *= variables[k].values.length;
                }
                pv = variables[0];
                for (i = 0; i < pv.values.length; ++i) {
                    k = i * jump + pos;
                    values[k] = eentry_entries[i];
                }
            }
        }
    }

    void finish_values(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != -1.0) continue;
            values[i] = 0.0;
        }
    }
}

