/*
 * Decompiled with CFR 0.152.
 */
package BayesianInferences;

import BayesianInferences.BucketTree;
import BayesianInferences.Ordering;
import BayesianNetworks.BayesNet;
import BayesianNetworks.ProbabilityFunction;
import BayesianNetworks.ProbabilityVariable;
import java.io.PrintStream;

public class Explanation {
    BayesNet bn;
    BucketTree bucket_tree;
    ProbabilityFunction[] results;

    public Explanation(BayesNet b_n) {
        this.bn = b_n;
    }

    public void explanation() {
        this.explanation(1);
    }

    public void full_explanation() {
        this.explanation(2);
    }

    public void explanation(int explanation_status) {
        this.bucket_tree = new BucketTree(new Ordering(this.bn, null, explanation_status, 2));
        this.do_inference_from_bucket_tree();
    }

    public void explanation(String[] order) {
        this.explanation(order, 1);
    }

    public void full_explanation(String[] order) {
        this.explanation(order, 2);
    }

    public void explanation(String[] order, int explanation_status) {
        this.bucket_tree = new BucketTree(new Ordering(this.bn, order, explanation_status));
        this.do_inference_from_bucket_tree();
    }

    void do_inference_from_bucket_tree() {
        this.results = new ProbabilityFunction[1];
        this.bucket_tree.reduce();
        this.results[0] = this.bucket_tree.get_normalized_result();
    }

    public void print() {
        this.print(System.out, true);
    }

    public void print(PrintStream out) {
        this.print(out, true);
    }

    public void print(boolean should_print_bucket_tree) {
        this.print(System.out, should_print_bucket_tree);
    }

    public void print(PrintStream out, boolean should_print_bucket_tree) {
        if (this.results == null) {
            this.explanation();
        }
        out.println("Explanation:");
        if (should_print_bucket_tree) {
            this.bucket_tree.print(out);
        }
        if (this.bucket_tree.backward_pointers == null) {
            out.println("No explanatory variable; posterior distribution:");
            for (int i = 0; i < this.results.length; ++i) {
                this.results[i].print(out);
            }
        } else {
            int[] bp = this.bucket_tree.backward_pointers;
            for (int i = 0; i < bp.length; ++i) {
                if (bp[i] == -1) continue;
                ProbabilityVariable pv = this.bn.get_probability_variable(i);
                out.println("Variable " + pv.get_name() + ": " + pv.get_value(bp[i]));
            }
        }
    }

    public ProbabilityFunction[] get_results() {
        return this.results;
    }
}

