/*
 * Decompiled with CFR 0.152.
 */
package BayesianInferences;

import BayesianInferences.Bucket;
import BayesianInferences.Ordering;
import BayesianNetworks.BayesNet;
import BayesianNetworks.DiscreteFunction;
import BayesianNetworks.DiscreteVariable;
import BayesianNetworks.ProbabilityFunction;
import BayesianNetworks.ProbabilityVariable;
import java.io.PrintStream;
import java.util.Enumeration;

public class BucketTree {
    Bucket[] bucket_tree;
    BayesNet bn;
    int[] backward_pointers;
    DiscreteFunction unnormalized_result;
    Ordering ordering;
    int explanation_status;
    boolean do_produce_clusters;
    private int active_bucket;
    static final int MAX_OUT = 2;
    static final int SUM_OUT = 1;

    public BucketTree(Ordering ord) {
        this(ord, false);
    }

    public BucketTree(Ordering ord, boolean dpc) {
        this.do_produce_clusters = dpc;
        this.ordering = ord;
        this.bn = ord.bn;
        this.explanation_status = ord.explanation_status;
        String[] order = ord.order;
        this.active_bucket = 0;
        int i = this.bn.index_of_variable(order[order.length - 1]);
        ProbabilityVariable pv = this.bn.get_probability_variable(i);
        if (pv.is_observed()) {
            ProbabilityFunction pf = this.transform_to_probability_function(this.bn, pv);
            this.bucket_tree = new Bucket[1];
            this.bucket_tree[0] = new Bucket(this, pv, this.do_produce_clusters);
            this.insert(pf);
        } else {
            this.bucket_tree = new Bucket[order.length];
            for (i = 0; i < order.length; ++i) {
                int j = this.bn.index_of_variable(order[i]);
                this.bucket_tree[i] = new Bucket(this, this.bn.get_probability_variable(j), this.do_produce_clusters);
            }
            int[] markers = new int[this.bn.number_variables()];
            for (i = 0; i < order.length; ++i) {
                markers[this.bn.index_of_variable((String)order[i])] = 1;
            }
            for (i = 0; i < this.bn.number_probability_functions(); ++i) {
                ProbabilityFunction pf;
                if (markers[this.bn.get_probability_function(i).get_index(0)] != 1 || (pf = this.check_evidence(this.bn.get_probability_function(i))) == null) continue;
                DiscreteVariable aux_pv = this.bn.get_probability_function(i).get_variable(0);
                this.insert(pf, !pf.memberOf(aux_pv.get_index()));
            }
            DiscreteFunction ut = this.bn.get_utility_function();
            if (ut != null) {
                this.insert(ut);
            }
        }
    }

    private ProbabilityFunction transform_to_probability_function(BayesNet bn, ProbabilityVariable pv) {
        ProbabilityFunction pf = new ProbabilityFunction(bn, 1, pv.number_values(), null);
        pf.set_variable(0, pv);
        int index_of_value = pv.get_observed_index();
        pf.set_value(index_of_value, 1.0);
        return pf;
    }

    private ProbabilityFunction check_evidence(ProbabilityFunction pf) {
        int i;
        boolean[] markers = new boolean[this.bn.number_variables()];
        int n = this.build_evidence_markers(pf, markers);
        if (n == 0) {
            return null;
        }
        if (n == pf.number_variables()) {
            return pf;
        }
        int[] joined_indexes = new int[n];
        int j = 0;
        int v = 1;
        for (i = 0; i < pf.number_variables(); ++i) {
            int aux_i = pf.get_variable(i).get_index();
            if (!markers[aux_i]) continue;
            joined_indexes[j] = aux_i;
            ++j;
            v *= this.bn.get_probability_variable(aux_i).number_values();
        }
        ProbabilityFunction new_pf = new ProbabilityFunction(this.bn, n, v, null);
        for (i = 0; i < n; ++i) {
            new_pf.set_variable(i, this.bn.get_probability_variable(joined_indexes[i]));
        }
        this.check_evidence_loop(new_pf, pf);
        return new_pf;
    }

    private int build_evidence_markers(ProbabilityFunction pf, boolean[] markers) {
        int i;
        for (i = 0; i < markers.length; ++i) {
            markers[i] = false;
        }
        for (i = 0; i < pf.number_variables(); ++i) {
            markers[pf.get_index((int)i)] = true;
        }
        for (i = 0; i < this.bn.number_variables(); ++i) {
            if (!this.bn.get_probability_variable(i).is_observed()) continue;
            markers[i] = false;
        }
        int n = 0;
        for (i = 0; i < markers.length; ++i) {
            if (!markers[i]) continue;
            ++n;
        }
        return n;
    }

    private void check_evidence_loop(ProbabilityFunction new_pf, ProbabilityFunction pf) {
        int i;
        int[] indexes = new int[this.bn.number_variables()];
        int[] value_lengths = new int[this.bn.number_variables()];
        for (i = 0; i < this.bn.number_variables(); ++i) {
            indexes[i] = 0;
            value_lengths[i] = this.bn.get_probability_variable(i).number_values();
        }
        for (i = 0; i < this.bn.number_variables(); ++i) {
            if (!this.bn.get_probability_variable(i).is_observed()) continue;
            indexes[i] = this.bn.get_probability_variable(i).get_observed_index();
        }
        int last = new_pf.number_variables() - 1;
        for (i = 0; i < new_pf.number_values(); ++i) {
            int current;
            int p = new_pf.get_position_from_indexes(indexes);
            new_pf.set_value(p, pf.evaluate(indexes));
            int n = new_pf.get_index(last);
            indexes[n] = indexes[n] + 1;
            for (int j = last; j > 0 && indexes[current = new_pf.get_index(j)] >= value_lengths[current]; --j) {
                indexes[current] = 0;
                int n2 = new_pf.get_index(j - 1);
                indexes[n2] = indexes[n2] + 1;
            }
        }
    }

    public void reduce() {
        int i;
        for (i = 0; i < this.bucket_tree.length - 1; ++i) {
            this.active_bucket = i;
            this.bucket_tree[i].reduce();
            this.insert(this.bucket_tree[i]);
        }
        this.unnormalized_result = this.bucket_tree[i].combine();
        this.bucket_tree[i].bucket_status = 2;
        this.backward_pointers = this.backward_maximization();
    }

    public boolean distribute() {
        int last;
        boolean[] mark_non_conditioning = new boolean[this.bn.number_variables()];
        if (this.unnormalized_result == null) {
            this.reduce();
        }
        if ((last = this.bucket_tree.length - 1) < 1) {
            return true;
        }
        if (!this.do_produce_clusters) {
            return false;
        }
        if (this.backward_pointers != null) {
            return false;
        }
        for (int i = last - 1; i >= 0 && this.bucket_tree[i].cluster != null; --i) {
            int j;
            for (j = 0; j < mark_non_conditioning.length; ++j) {
                mark_non_conditioning[j] = true;
            }
            for (j = 1; j < this.bucket_tree[i].cluster.number_variables(); ++j) {
                mark_non_conditioning[this.bucket_tree[i].cluster.get_variables()[j].get_index()] = false;
            }
            this.bucket_tree[i].separator = this.bucket_tree[i].child.cluster.sum_out(this.bn.get_probability_variables(), mark_non_conditioning);
            if (this.bucket_tree[i].separator != null) {
                this.bucket_tree[i].cluster.normalize_first();
                this.bucket_tree[i].cluster = this.bucket_tree[i].cluster.multiply(this.bn.get_probability_variables(), this.bucket_tree[i].separator);
            }
            this.bucket_tree[i].bucket_status = 2;
        }
        return true;
    }

    private int[] backward_maximization() {
        int i;
        int bi = this.bucket_tree.length - 1;
        Bucket b = this.bucket_tree[bi];
        if (b.backward_pointers == null) {
            return null;
        }
        int[] backward_markers = new int[this.bn.number_variables()];
        for (i = 0; i < backward_markers.length; ++i) {
            backward_markers[i] = -1;
        }
        backward_markers[b.variable.get_index()] = (int)(b.backward_pointers.get_value(0) + 0.5);
        for (i = bi - 1; i >= 0 && this.bucket_tree[i].is_explanation(); --i) {
            DiscreteFunction back_df = this.bucket_tree[i].backward_pointers;
            if (back_df == null) continue;
            if (back_df.number_values() == 1) {
                backward_markers[this.bucket_tree[i].variable.get_index()] = (int)(back_df.get_value(0) + 0.5);
                continue;
            }
            int j = back_df.get_position_from_indexes(this.bn.get_probability_variables(), backward_markers);
            backward_markers[this.bucket_tree[i].variable.get_index()] = (int)(back_df.get_value(j) + 0.5);
        }
        return backward_markers;
    }

    private void insert(Bucket buck) {
        if (buck.separator == null) {
            return;
        }
        for (int i = this.active_bucket; i < this.bucket_tree.length; ++i) {
            int index = this.bucket_tree[i].variable.get_index();
            if (!buck.separator.memberOf(index)) continue;
            this.bucket_tree[i].discrete_functions.addElement(buck.separator);
            Enumeration e = buck.non_conditioning_variables.elements();
            while (e.hasMoreElements()) {
                this.bucket_tree[i].non_conditioning_variables.addElement(e.nextElement());
            }
            this.bucket_tree[i].non_conditioning_variables.removeElement(buck.variable);
            buck.child = this.bucket_tree[i];
            this.bucket_tree[i].parents.addElement(buck);
            return;
        }
    }

    private void insert(DiscreteFunction df) {
        this.insert(df, false);
    }

    private void insert(DiscreteFunction df, boolean was_first_variable_cancelled_by_evidence) {
        for (int i = this.active_bucket; i < this.bucket_tree.length; ++i) {
            int index = this.bucket_tree[i].variable.get_index();
            if (!df.memberOf(index)) continue;
            this.bucket_tree[i].discrete_functions.addElement(df);
            if (df instanceof ProbabilityFunction && !was_first_variable_cancelled_by_evidence) {
                this.bucket_tree[i].non_conditioning_variables.addElement(df.get_variable(0));
            }
            return;
        }
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream out) {
        out.println("BucketTree:\n\tActive Bucket is " + this.active_bucket + ".");
        for (int i = 0; i < this.bucket_tree.length; ++i) {
            this.bucket_tree[i].print(out);
        }
        out.println("Bucket result: ");
        this.unnormalized_result.print(out);
    }

    public ProbabilityFunction get_normalized_result() {
        ProbabilityFunction aux_pf = new ProbabilityFunction(this.unnormalized_result, this.bn);
        aux_pf.normalize();
        return aux_pf;
    }

    public DiscreteFunction get_unnormalized_result() {
        return this.unnormalized_result;
    }
}

