/*
 * Decompiled with CFR 0.152.
 */
package jnumeric;

import jnumeric.Add;
import jnumeric.ArgMax;
import jnumeric.ArgMin;
import jnumeric.BinaryFunction;
import jnumeric.BitwiseAnd;
import jnumeric.BitwiseOr;
import jnumeric.BitwiseXor;
import jnumeric.Divide;
import jnumeric.Equal;
import jnumeric.Greater;
import jnumeric.GreaterEqual;
import jnumeric.KeywordFunction;
import jnumeric.Less;
import jnumeric.LessEqual;
import jnumeric.LogicalAnd;
import jnumeric.LogicalOr;
import jnumeric.LogicalXor;
import jnumeric.Maximum;
import jnumeric.Minimum;
import jnumeric.Multiply;
import jnumeric.NotEqual;
import jnumeric.Power;
import jnumeric.PyMultiarray;
import jnumeric.Remainder;
import jnumeric.Subtract;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyString;

public class BinaryUfunc
extends KeywordFunction {
    private static final long serialVersionUID = 2592949830660376736L;
    public static final BinaryFunction add = new Add();
    public static final BinaryFunction subtract = new Subtract();
    public static final BinaryFunction multiply = new Multiply();
    public static final BinaryFunction divide = new Divide();
    public static final BinaryFunction remainder = new Remainder();
    public static final BinaryFunction power = new Power();
    public static final BinaryFunction maximum = new Maximum();
    public static final BinaryFunction minimum = new Minimum();
    public static final BinaryFunction equal = new Equal();
    public static final BinaryFunction notEqual = new NotEqual();
    public static final BinaryFunction less = new Less();
    public static final BinaryFunction lessEqual = new LessEqual();
    public static final BinaryFunction greater = new Greater();
    public static final BinaryFunction greaterEqual = new GreaterEqual();
    public static final BinaryFunction logicalAnd = new LogicalAnd();
    public static final BinaryFunction logicalOr = new LogicalOr();
    public static final BinaryFunction logicalXor = new LogicalXor();
    public static final BinaryFunction bitwiseAnd = new BitwiseAnd();
    public static final BinaryFunction bitwiseOr = new BitwiseOr();
    public static final BinaryFunction bitwiseXor = new BitwiseXor();
    public static final BinaryFunction argMax = new ArgMax();
    public static final BinaryFunction argMin = new ArgMin();
    BinaryFunction function;

    String docString() {
        return "This object has the following methods:\n   reduce(a [,axis])\n      Works just like reduce(ufunc, a, [ufunc's identity element]) except\n      you get to choose the axis to perform the reduction along. Note that\n      if the length of a long axis is 0, then the appropriate identity element\n      for the ufunc will be returned.\n   accumulate(a [,axis])\n      This is the same as reduce, except that all the intermediate results are\n      kept along the way.\n   outer(a, b)\n      This will take the outer product of a and b. The new results shape will\n      be the same as a.shape+b.shape (where plus means concatenate, not add!)\n   reduceat(a, indices [,axis])\n      This is a weird function, and most people should just ignore it. It will\n      reduce a to each of the given indices so that as new size along the given\n      axis will be the same as the length of indices.\n      If axis is not supplied it defaults to zero.";
    }

    public BinaryUfunc(BinaryFunction function) {
        this.function = function;
        this.argNames = new String[]{"a", "b", "result"};
        this.defaultArgs = new PyObject[]{null, null, Py.None};
    }

    @Override
    public PyObject __findattr_ex__(String name) {
        if (name == "__doc__") {
            return new PyString(this.function.docString() + this.docString());
        }
        return super.__findattr_ex__(name);
    }

    public PyObject outer(PyObject poa, PyObject pob) {
        int i;
        PyMultiarray a = PyMultiarray.asarray(poa);
        PyMultiarray b = PyMultiarray.asarray(pob);
        char type = PyMultiarray.commonType(a._typecode, b._typecode);
        PyMultiarray af = PyMultiarray.reshape(PyMultiarray.ascontiguous(a, type), new int[]{-1});
        PyMultiarray bf = PyMultiarray.reshape(PyMultiarray.ascontiguous(b, type), new int[]{-1});
        PyMultiarray result = PyMultiarray.zeros(new int[]{af.dimensions[0] * bf.dimensions[0]}, type);
        for (int i2 = 0; i2 < af.dimensions[0]; ++i2) {
            PyMultiarray temp = (PyMultiarray)this.function.call(bf, af.get(i2));
            System.arraycopy(temp.data, 0, result.data, i2 * bf.dimensions[0], bf.dimensions[0]);
        }
        int[] newDimensions = new int[a.dimensions.length + b.dimensions.length];
        for (i = 0; i < a.dimensions.length; ++i) {
            newDimensions[i] = a.dimensions[i];
        }
        for (i = 0; i < b.dimensions.length; ++i) {
            newDimensions[a.dimensions.length + i] = b.dimensions[i];
        }
        return PyMultiarray.reshape(result, newDimensions);
    }

    public PyObject reduceat(PyObject po, int[] indices, int axis) {
        PyMultiarray a = PyMultiarray.ascontiguous(po);
        int n = axis = axis < 0 ? axis + a.dimensions.length : axis;
        if (axis < 0 || axis >= a.dimensions.length) {
            throw Py.ValueError("axis out of legal range");
        }
        int[] eIndices = new int[indices.length + 1];
        eIndices[indices.length] = a.dimensions[axis];
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] < 0 || indices[i] >= a.dimensions[axis]) {
                throw Py.IndexError("invalid index to reduceat");
            }
            eIndices[i] = indices[i];
        }
        int[] shape = (int[])a.dimensions.clone();
        shape[axis] = indices.length;
        PyMultiarray result = PyMultiarray.zeros(shape, a._typecode);
        a = PyMultiarray.rotateAxes(a, -axis);
        PyMultiarray r = PyMultiarray.rotateAxes(result, -axis);
        for (int i = 0; i < indices.length; ++i) {
            r.set(i, this.reduce(a.getslice(eIndices[i], eIndices[i + 1], 1)));
        }
        return result;
    }

    public PyObject reduceat(PyObject po, int[] indices) {
        return this.reduceat(po, indices, 0);
    }

    public PyObject reduce(PyObject po, int axis) {
        PyMultiarray a = PyMultiarray.asarray(po);
        if (axis < 0) {
            axis += a.dimensions.length;
        }
        if (axis < 0 || axis >= a.dimensions.length) {
            throw Py.ValueError("axis out of legal range");
        }
        a = PyMultiarray.rotateAxes(PyMultiarray.asarray(po), -axis);
        if (a.dimensions[0] == 0) {
            return PyMultiarray.asarray(this.function.identity(), a._typecode);
        }
        int[] shape = new int[a.dimensions.length - 1];
        for (int i = 0; i < a.dimensions.length - 1; ++i) {
            shape[i] = a.dimensions[i + 1];
        }
        PyMultiarray b = PyMultiarray.zeros(shape, a._typecode);
        a = PyMultiarray.reshape(a, new int[]{a.dimensions[0], -1});
        b = PyMultiarray.reshape(b, new int[]{1, -1});
        int s0 = a.strides[0];
        int d0 = a.dimensions[0];
        int s1 = a.strides[a.dimensions.length - 1];
        int d1 = a.dimensions[a.dimensions.length - 1];
        for (int i = 0; i < d1; ++i) {
            this.function.accumulate(a.data, a.start + i * s1, d0, s0, b.data, i * s1, 1, 0, a._typecode);
        }
        b = PyMultiarray.rotateAxes(PyMultiarray.reshape(b, shape), axis);
        return PyMultiarray.returnValue(b);
    }

    public PyObject reduce(PyObject po) {
        return this.reduce(po, 0);
    }

    public PyObject accumulate(PyObject po, int axis) {
        PyMultiarray a = PyMultiarray.asarray(po);
        if (axis < 0) {
            axis += a.dimensions.length;
        }
        if (axis < 0 || axis >= a.dimensions.length) {
            throw Py.ValueError("axis out of legal range");
        }
        a = PyMultiarray.rotateAxes(PyMultiarray.asarray(po), -axis);
        if (a.dimensions[0] == 0) {
            return PyMultiarray.asarray(this.function.identity(), a._typecode);
        }
        int[] shape = (int[])a.dimensions.clone();
        PyMultiarray b = PyMultiarray.zeros(shape, a._typecode);
        a = PyMultiarray.reshape(a, new int[]{a.dimensions[0], -1});
        b = PyMultiarray.reshape(b, new int[]{1, -1});
        int s0 = a.strides[0];
        int d0 = a.dimensions[0];
        int s1 = a.strides[a.dimensions.length - 1];
        int d1 = a.dimensions[a.dimensions.length - 1];
        for (int i = 0; i < d1; ++i) {
            this.function.accumulate(a.data, a.start + i * s1, d0, s0, b.data, i * s1, d0, s0, a._typecode);
        }
        b = PyMultiarray.rotateAxes(PyMultiarray.reshape(b, shape), axis);
        return PyMultiarray.returnValue(b);
    }

    public PyObject accumulate(PyObject po) {
        return this.accumulate(po, 0);
    }

    @Override
    public PyObject _call(PyObject[] args) {
        if (args[2] == Py.None) {
            return this.function.call(PyMultiarray.asarray(args[0]), PyMultiarray.asarray(args[1]));
        }
        if (!(args[2] instanceof PyMultiarray)) {
            throw Py.ValueError("result must be an array");
        }
        PyMultiarray a = PyMultiarray.asarray(args[0]);
        PyMultiarray b = PyMultiarray.asarray(args[1]);
        PyMultiarray result = (PyMultiarray)args[2];
        return this.function.call(a, b, result);
    }
}

