/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.topics;

import cc.mallet.topics.WordEmbeddings;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import java.util.Random;

public class WordEmbeddingRunnable
implements Runnable {
    public WordEmbeddings model;
    public InstanceList instances;
    public int numSamples;
    public boolean shouldRun = true;
    double residual = 0.0;
    int numUpdates = 0;
    int numThreads;
    int threadID;
    int iteration = 0;
    int stride;
    int docID;
    public Random random;
    int numColumns;
    int orderingStrategy = 0;
    public long wordsSoFar = 0L;
    private int minDocumentLength;

    public WordEmbeddingRunnable(WordEmbeddings model, InstanceList instances, int numSamples, int numThreads, int threadID) {
        this.model = model;
        this.stride = model.stride;
        this.instances = instances;
        this.numSamples = numSamples;
        this.numThreads = numThreads;
        this.threadID = threadID;
        this.random = new Random();
        this.numColumns = model.numColumns;
        this.minDocumentLength = model.getMinDocumentLength();
    }

    public void setRandomSeed(int seed) {
        this.random = new Random(seed);
    }

    public void setOrdering(int strategy) {
        this.orderingStrategy = strategy;
    }

    public double getMeanError() {
        if (this.numUpdates == 0) {
            return this.docID;
        }
        double result = this.residual / (double)this.numUpdates;
        this.residual = 0.0;
        this.numUpdates = 0;
        return result;
    }

    @Override
    public void run() {
        int i;
        long previousWordsSoFar = 0L;
        long wordsConsidered = 0L;
        long wordsSampled = 0L;
        int numDocuments = this.instances.size();
        double learningRate = 0.025;
        double gradientSum = 0.0;
        double[] gradient = new double[this.numColumns];
        int minDoc = this.threadID * (numDocuments / this.numThreads);
        int maxDoc = (this.threadID + 1) * (numDocuments / this.numThreads);
        int numDocs = maxDoc - minDoc;
        int[] agenda = new int[numDocs];
        if (this.orderingStrategy == 1) {
            for (i = 0; i < numDocs; ++i) {
                agenda[i] = i;
            }
            for (i = 0; i < numDocs; ++i) {
                int swapIndex = i + this.random.nextInt(numDocs - i);
                int temp = agenda[swapIndex];
                agenda[swapIndex] = agenda[i];
                agenda[i] = temp;
            }
        } else if (this.orderingStrategy == 2) {
            for (i = 0; i < numDocs; ++i) {
                agenda[i] = minDoc + this.random.nextInt(numDocs);
            }
        } else {
            for (i = 0; i < numDocs; ++i) {
                agenda[i] = minDoc + i;
            }
        }
        this.docID = 0;
        int maxDocID = (this.threadID + 1) * (numDocuments / this.numThreads);
        if (maxDocID > numDocuments) {
            maxDocID = numDocuments;
        }
        double cacheScale = (double)this.model.sigmoidCacheSize / (this.model.maxExpValue - this.model.minExpValue);
        int[] tokenBuffer = new int[100000];
        while (this.shouldRun) {
            int inputType;
            int inputPosition;
            Instance instance = (Instance)this.instances.get(agenda[this.docID]);
            ++this.docID;
            if (this.docID == numDocs) {
                this.docID = 0;
                ++this.iteration;
                if (this.iteration >= this.model.numIterations) {
                    this.shouldRun = false;
                    return;
                }
            }
            if (this.wordsSoFar - previousWordsSoFar > 10000L) {
                learningRate = Math.max(2.5E-6, 0.025 * (1.0 - (double)this.numThreads * (double)this.wordsSoFar / (double)(this.model.numIterations * this.model.totalWords)));
                previousWordsSoFar = this.wordsSoFar;
            }
            double[] weights = this.model.weights;
            double[] negativeWeights = this.model.negativeWeights;
            FeatureSequence tokens = (FeatureSequence)instance.getData();
            int originalLength = tokens.getLength();
            int length = 0;
            for (inputPosition = 0; inputPosition < originalLength; ++inputPosition) {
                inputType = tokens.getIndexAtPosition(inputPosition);
                ++this.wordsSoFar;
                if (!(this.random.nextDouble() < this.model.retentionProbability[inputType])) continue;
                tokenBuffer[length] = inputType;
                ++length;
                ++wordsSampled;
            }
            assert (this.minDocumentLength > 0);
            if (length < this.minDocumentLength) continue;
            for (inputPosition = 0; inputPosition < length; ++inputPosition) {
                ++wordsConsidered;
                inputType = tokenBuffer[inputPosition];
                int inputTypeOffset = inputType * this.stride;
                int subWindow = this.random.nextInt(this.model.windowSize) + 1;
                int start = Math.max(0, inputPosition - subWindow);
                int end = Math.min(length - 1, inputPosition + subWindow);
                for (int outputPosition = start; outputPosition <= end; ++outputPosition) {
                    int col;
                    if (inputPosition == outputPosition) continue;
                    int outputType = tokenBuffer[outputPosition];
                    int outputTypeOffset = outputType * this.stride;
                    double innerProduct = 0.0;
                    for (col = 0; col < this.numColumns; ++col) {
                        innerProduct += negativeWeights[inputTypeOffset + col] * weights[outputTypeOffset + col];
                    }
                    double weightedResidual = innerProduct < this.model.minExpValue ? learningRate : (innerProduct > this.model.maxExpValue ? 0.0 : learningRate * (1.0 - this.model.sigmoidCache[(int)Math.floor((innerProduct - this.model.minExpValue) * cacheScale)]));
                    for (col = 0; col < this.numColumns; ++col) {
                        gradient[col] = weightedResidual * negativeWeights[inputTypeOffset + col];
                        int n = inputTypeOffset + col;
                        negativeWeights[n] = negativeWeights[n] + weightedResidual * weights[outputTypeOffset + col];
                    }
                    double meanNegativePrediction = 0.0;
                    for (int sample = 0; sample < this.numSamples; ++sample) {
                        int col2;
                        int sampledType = this.model.samplingTable[this.random.nextInt(this.model.samplingTableSize)];
                        if (sampledType == inputType) continue;
                        int sampledTypeOffset = sampledType * this.stride;
                        innerProduct = 0.0;
                        for (col2 = 0; col2 < this.numColumns; ++col2) {
                            innerProduct += negativeWeights[sampledTypeOffset + col2] * weights[outputTypeOffset + col2];
                        }
                        weightedResidual = innerProduct < this.model.minExpValue ? 0.0 : (innerProduct > this.model.maxExpValue ? -learningRate : learningRate * -this.model.sigmoidCache[(int)Math.floor((innerProduct - this.model.minExpValue) * cacheScale)]);
                        for (col2 = 0; col2 < this.numColumns; ++col2) {
                            int n = col2;
                            gradient[n] = gradient[n] + weightedResidual * negativeWeights[sampledTypeOffset + col2];
                            int n2 = sampledTypeOffset + col2;
                            negativeWeights[n2] = negativeWeights[n2] + weightedResidual * weights[outputTypeOffset + col2];
                        }
                    }
                    ++this.numUpdates;
                    for (int col3 = 0; col3 < this.numColumns; ++col3) {
                        int n = outputTypeOffset + col3;
                        weights[n] = weights[n] + gradient[col3];
                    }
                }
            }
        }
    }
}

