/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.topics;

import cc.mallet.classify.MaxEnt;
import cc.mallet.optimize.LimitedMemoryBFGS;
import cc.mallet.optimize.OptimizationException;
import cc.mallet.pipe.Noop;
import cc.mallet.pipe.Pipe;
import cc.mallet.topics.DMRInferencer;
import cc.mallet.topics.DMROptimizable;
import cc.mallet.topics.DMRRunnable;
import cc.mallet.topics.ParallelTopicModel;
import cc.mallet.topics.TopicAssignment;
import cc.mallet.topics.WorkerRunnable;
import cc.mallet.types.Alphabet;
import cc.mallet.types.Dirichlet;
import cc.mallet.types.FeatureCounter;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelSequence;
import cc.mallet.types.MatrixOps;
import cc.mallet.util.CommandOption;
import cc.mallet.util.Randoms;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DMRTopicModel
extends ParallelTopicModel {
    static CommandOption.String inputFile = new CommandOption.String(DMRTopicModel.class, "input", "FILENAME", true, null, "Filename for DMR topic model. Each instance should have features in its Target field.", null);
    static CommandOption.String outputModelFilename = new CommandOption.String(DMRTopicModel.class, "output-model", "FILENAME", true, null, "The filename in which to write the binary topic model at the end of the iterations.  By default this is null, indicating that no file will be written.", null);
    static CommandOption.String outputParametersFilename = new CommandOption.String(DMRTopicModel.class, "output-params", "FILENAME", true, "parameters.tsv", "The filename in which to write the DMR parameters.", null);
    static CommandOption.String inputModelFilename = new CommandOption.String(DMRTopicModel.class, "input-model", "FILENAME", true, null, "The filename from which to read the binary topic model to which the --input will be appended, allowing incremental training.  By default this is null, indicating that no file will be read.", null);
    static CommandOption.String inferencerFilename = new CommandOption.String(DMRTopicModel.class, "inferencer-filename", "FILENAME", true, null, "A topic inferencer applies a previously trained topic model to new documents.  By default this is null, indicating that no file will be written.", null);
    static CommandOption.String evaluatorFilename = new CommandOption.String(DMRTopicModel.class, "evaluator-filename", "FILENAME", true, null, "A held-out likelihood evaluator for new documents.  By default this is null, indicating that no file will be written.", null);
    static CommandOption.String stateFile = new CommandOption.String(DMRTopicModel.class, "output-state", "FILENAME", true, null, "The filename in which to write the Gibbs sampling state after at the end of the iterations.  By default this is null, indicating that no file will be written.", null);
    static CommandOption.String topicKeysFile = new CommandOption.String(DMRTopicModel.class, "output-topic-keys", "FILENAME", true, null, "The filename in which to write the top words for each topic and any Dirichlet parameters.  By default this is null, indicating that no file will be written.", null);
    static CommandOption.String docTopicsFile = new CommandOption.String(DMRTopicModel.class, "output-doc-topics", "FILENAME", true, null, "The filename in which to write the topic proportions per document, at the end of the iterations.  By default this is null, indicating that no file will be written.", null);
    static CommandOption.Double docTopicsThreshold = new CommandOption.Double(DMRTopicModel.class, "doc-topics-threshold", "DECIMAL", true, 0.0, "When writing topic proportions per document with --output-doc-topics, do not print topics with proportions less than this threshold value.", null);
    static CommandOption.Integer docTopicsMax = new CommandOption.Integer(DMRTopicModel.class, "doc-topics-max", "INTEGER", true, -1, "When writing topic proportions per document with --output-doc-topics, do not print more than INTEGER number of topics.  A negative value indicates that all topics should be printed.", null);
    static CommandOption.Integer outputStateIntervalOption = new CommandOption.Integer(DMRTopicModel.class, "output-state-interval", "INTEGER", true, 0, "The number of iterations between writing the sampling state to a text file.  You must also set the --output-state to use this option, whose argument will be the prefix of the filenames.", null);
    static CommandOption.Integer outputParametersIntervalOption = new CommandOption.Integer(DMRTopicModel.class, "output-params-interval", "INTEGER", true, 0, "The number of iterations between writing the DMR parameters to a text file.  You must also set the --output-params to use this option, whose argument will be the prefix of the filenames.", null);
    static CommandOption.Integer numTopicsOption = new CommandOption.Integer(DMRTopicModel.class, "num-topics", "INTEGER", true, 10, "The number of topics to fit.", null);
    static CommandOption.Integer numThreadsOption = new CommandOption.Integer(DMRTopicModel.class, "num-threads", "INTEGER", true, 1, "The number of threads to run in parallel.", null);
    static CommandOption.Integer numIterationsOption = new CommandOption.Integer(DMRTopicModel.class, "num-iterations", "INTEGER", true, 1000, "The number of iterations of Gibbs sampling.", null);
    static CommandOption.Integer randomSeedOption = new CommandOption.Integer(DMRTopicModel.class, "random-seed", "INTEGER", true, 0, "The random seed for the Gibbs sampler.  Default is 0, which will use the clock.", null);
    static CommandOption.Integer topWordsOption = new CommandOption.Integer(DMRTopicModel.class, "num-top-words", "INTEGER", true, 20, "The number of most probable words to print for each topic after model estimation.", null);
    static CommandOption.Integer showTopicsIntervalOption = new CommandOption.Integer(DMRTopicModel.class, "show-topics-interval", "INTEGER", true, 50, "The number of iterations between printing a brief summary of the topics so far.", null);
    static CommandOption.Integer optimizeIntervalOption = new CommandOption.Integer(DMRTopicModel.class, "optimize-interval", "INTEGER", true, 20, "The number of iterations between reestimating DMR parameters.", null);
    static CommandOption.Integer optimizeBurnInOption = new CommandOption.Integer(DMRTopicModel.class, "optimize-burn-in", "INTEGER", true, 20, "The number of iterations to run before first estimating DMR parameters.", null);
    static CommandOption.Double alphaOption = new CommandOption.Double(DMRTopicModel.class, "alpha", "DECIMAL", true, 50.0, "Alpha parameter: initial smoothing over topic distribution.", null);
    static CommandOption.Double betaOption = new CommandOption.Double(DMRTopicModel.class, "beta", "DECIMAL", true, 0.01, "Beta parameter: smoothing over unigram distribution.", null);
    MaxEnt dmrParameters = null;
    int numFeatures;
    int defaultFeatureIndex;
    Pipe parameterPipe = null;
    double[][] alphaCache;
    double[] alphaSumCache;
    double initialAlpha = 0.1;
    public String parametersFilename = "dmr_parameters.txt";
    public int saveParametersInterval = 0;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;
    private static final int NULL_INTEGER = -1;

    public DMRTopicModel(int numberOfTopics) {
        super(numberOfTopics);
    }

    @Override
    public void addInstances(InstanceList training) {
        int doc;
        this.alphabet = training.getDataAlphabet();
        this.numTypes = this.alphabet.size();
        this.betaSum = this.beta * (double)this.numTypes;
        Randoms random = null;
        random = this.randomSeed == -1 ? new Randoms() : new Randoms(this.randomSeed);
        this.alphaCache = new double[training.size()][this.numTopics];
        this.alphaSumCache = new double[training.size()];
        int index = 0;
        for (Instance instance : training) {
            FeatureSequence tokens = (FeatureSequence)instance.getData();
            LabelSequence topicSequence = new LabelSequence(this.topicAlphabet, new int[tokens.size()]);
            int[] topics = topicSequence.getFeatures();
            for (int position = 0; position < topics.length; ++position) {
                int topic;
                topics[position] = topic = random.nextInt(this.numTopics);
            }
            TopicAssignment t = new TopicAssignment(instance, topicSequence);
            this.data.add(t);
            Arrays.fill(this.alphaCache[index], this.initialAlpha);
            this.alphaSumCache[index] = (double)this.numTopics * this.initialAlpha;
            ++index;
        }
        this.alphaCache = new double[this.data.size()][this.numTopics];
        this.alphaSumCache = new double[this.data.size()];
        this.buildInitialTypeTopicCounts();
        this.parameterPipe = new Noop();
        Alphabet featureAlphabet = training.getTargetAlphabet();
        this.numFeatures = featureAlphabet.size() + 1;
        this.parameterPipe.setDataAlphabet(featureAlphabet);
        this.parameterPipe.setTargetAlphabet(this.topicAlphabet);
        this.dmrParameters = new MaxEnt(this.parameterPipe, new double[this.numFeatures * this.numTopics]);
        this.defaultFeatureIndex = this.dmrParameters.getDefaultFeatureIndex();
        double logInitialAlpha = Math.log(this.initialAlpha);
        for (int topic = 0; topic < this.numTopics; ++topic) {
            this.dmrParameters.setParameter(topic, this.defaultFeatureIndex, logInitialAlpha);
        }
        for (doc = 0; doc < this.data.size(); ++doc) {
            this.cacheAlphas(((TopicAssignment)this.data.get((int)doc)).instance, doc);
        }
        this.totalTokens = 0;
        for (doc = 0; doc < this.data.size(); ++doc) {
            FeatureSequence fs = (FeatureSequence)((TopicAssignment)this.data.get((int)doc)).instance.getData();
            this.totalTokens += fs.getLength();
        }
    }

    @Override
    public void estimate() throws IOException {
        long startTime = System.currentTimeMillis();
        WorkerRunnable[] runnables = new DMRRunnable[this.numThreads];
        int docsPerThread = this.data.size() / this.numThreads;
        int offset = 0;
        if (this.numThreads > 1) {
            for (int thread = 0; thread < this.numThreads; ++thread) {
                int[] runnableTotals = new int[this.numTopics];
                System.arraycopy(this.tokensPerTopic, 0, runnableTotals, 0, this.numTopics);
                int[][] runnableCounts = new int[this.numTypes][];
                for (int type = 0; type < this.numTypes; ++type) {
                    int[] counts = new int[this.typeTopicCounts[type].length];
                    System.arraycopy(this.typeTopicCounts[type], 0, counts, 0, counts.length);
                    runnableCounts[type] = counts;
                }
                if (thread == this.numThreads - 1) {
                    docsPerThread = this.data.size() - offset;
                }
                Randoms random = null;
                random = this.randomSeed == -1 ? new Randoms() : new Randoms(this.randomSeed);
                runnables[thread] = new DMRRunnable(this.numTopics, this, this.beta, random, this.data, runnableCounts, runnableTotals, offset, docsPerThread);
                offset += docsPerThread;
            }
        } else {
            Randoms random = null;
            random = this.randomSeed == -1 ? new Randoms() : new Randoms(this.randomSeed);
            runnables[0] = new DMRRunnable(this.numTopics, this, this.beta, random, this.data, this.typeTopicCounts, this.tokensPerTopic, offset, docsPerThread);
            runnables[0].makeOnlyThread();
        }
        ExecutorService executor = Executors.newFixedThreadPool(this.numThreads);
        for (int iteration = 1; iteration <= this.numIterations; ++iteration) {
            long iterationStart = System.currentTimeMillis();
            if (this.showTopicsInterval != 0 && iteration != 0 && iteration % this.showTopicsInterval == 0) {
                double[] parameters = this.dmrParameters.getParameters();
                for (int topic = 0; topic < this.numTopics; ++topic) {
                    this.alpha[topic] = Math.exp(parameters[topic * this.numFeatures + this.defaultFeatureIndex]);
                }
                logger.info("\n" + this.displayTopWords(this.wordsPerTopic, false));
            }
            if (this.saveStateInterval != 0 && iteration % this.saveStateInterval == 0) {
                this.printState(new File(this.stateFilename + '.' + iteration));
            }
            if (this.saveModelInterval != 0 && iteration % this.saveModelInterval == 0) {
                this.write(new File(this.modelFilename + '.' + iteration));
            }
            if (this.saveParametersInterval != 0 && iteration % this.saveParametersInterval == 0) {
                this.writeParameters(new File(this.parametersFilename + '.' + iteration));
            }
            if (this.numThreads > 1) {
                int thread;
                for (int thread2 = 0; thread2 < this.numThreads; ++thread2) {
                    logger.fine("submitting thread " + thread2);
                    executor.submit(runnables[thread2]);
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException thread2) {
                    // empty catch block
                }
                boolean finished = false;
                while (!finished) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException topic) {
                        // empty catch block
                    }
                    finished = true;
                    for (thread = 0; thread < this.numThreads; ++thread) {
                        finished = finished && ((DMRRunnable)runnables[thread]).isFinished;
                    }
                }
                this.sumTypeTopicCounts(runnables);
                for (thread = 0; thread < this.numThreads; ++thread) {
                    int[] runnableTotals = runnables[thread].getTokensPerTopic();
                    System.arraycopy(this.tokensPerTopic, 0, runnableTotals, 0, this.numTopics);
                    int[][] runnableCounts = runnables[thread].getTypeTopicCounts();
                    block12: for (int type = 0; type < this.numTypes; ++type) {
                        int[] targetCounts = runnableCounts[type];
                        int[] sourceCounts = this.typeTopicCounts[type];
                        for (int index = 0; index < sourceCounts.length; ++index) {
                            if (sourceCounts[index] != 0) {
                                targetCounts[index] = sourceCounts[index];
                                continue;
                            }
                            if (targetCounts[index] == 0) continue block12;
                            targetCounts[index] = 0;
                        }
                    }
                }
            } else {
                runnables[0].run();
            }
            long elapsedMillis = System.currentTimeMillis() - iterationStart;
            if (elapsedMillis < 1000L) {
                logger.fine(elapsedMillis + "ms ");
            } else {
                logger.fine(elapsedMillis / 1000L + "s ");
            }
            if (iteration > this.burninPeriod && this.optimizeInterval != 0 && iteration % this.optimizeInterval == 0) {
                this.learnParameters();
                logger.fine("[O " + (System.currentTimeMillis() - iterationStart) + "] ");
            }
            if (iteration % 10 != 0) continue;
            if (this.printLogLikelihood) {
                logger.info("<" + iteration + "> LL/token: " + this.formatter.format(this.modelLogLikelihood() / (double)this.totalTokens));
                continue;
            }
            logger.info("<" + iteration + ">");
        }
        executor.shutdownNow();
        long seconds = Math.round((double)(System.currentTimeMillis() - startTime) / 1000.0);
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        long days = hours / 24L;
        hours %= 24L;
        StringBuilder timeReport = new StringBuilder();
        timeReport.append("\nTotal time: ");
        if (days != 0L) {
            timeReport.append(days);
            timeReport.append(" days ");
        }
        if (hours != 0L) {
            timeReport.append(hours);
            timeReport.append(" hours ");
        }
        if (minutes != 0L) {
            timeReport.append(minutes);
            timeReport.append(" minutes ");
        }
        timeReport.append(seconds);
        timeReport.append(" seconds");
        logger.info(timeReport.toString());
    }

    public void cacheAlphas(Instance instance, int docIndex) {
        FeatureVector features = (FeatureVector)instance.getTarget();
        double[] parameters = this.dmrParameters.getParameters();
        this.alphaSumCache[docIndex] = 0.0;
        for (int topic = 0; topic < this.numTopics; ++topic) {
            this.alphaCache[docIndex][topic] = parameters[topic * this.numFeatures + this.defaultFeatureIndex] + MatrixOps.rowDotProduct(parameters, this.numFeatures, topic, features, this.defaultFeatureIndex, null);
            this.alphaCache[docIndex][topic] = Math.exp(this.alphaCache[docIndex][topic]);
            int n = docIndex;
            this.alphaSumCache[n] = this.alphaSumCache[n] + this.alphaCache[docIndex][topic];
        }
    }

    public void learnParameters() {
        if (this.parameterPipe == null) {
            this.parameterPipe = new Noop();
            this.parameterPipe.setDataAlphabet(((TopicAssignment)this.data.get((int)0)).instance.getTargetAlphabet());
            this.parameterPipe.setTargetAlphabet(this.topicAlphabet);
        }
        InstanceList parameterInstances = new InstanceList(this.parameterPipe);
        if (this.dmrParameters == null) {
            this.dmrParameters = new MaxEnt(this.parameterPipe, new double[this.numFeatures * this.numTopics]);
        }
        for (int doc = 0; doc < this.data.size(); ++doc) {
            if (((TopicAssignment)this.data.get((int)doc)).instance.getTarget() == null) continue;
            FeatureCounter counter = new FeatureCounter(this.topicAlphabet);
            for (int topic : ((TopicAssignment)this.data.get((int)doc)).topicSequence.getFeatures()) {
                counter.increment(topic);
            }
            parameterInstances.add(new Instance(((TopicAssignment)this.data.get((int)doc)).instance.getTarget(), counter.toFeatureVector(), null, null));
        }
        DMROptimizable optimizable = new DMROptimizable(parameterInstances, this.dmrParameters);
        optimizable.setRegularGaussianPriorVariance(0.5);
        optimizable.setInterceptGaussianPriorVariance(100.0);
        LimitedMemoryBFGS optimizer = new LimitedMemoryBFGS(optimizable);
        try {
            optimizer.optimize();
        }
        catch (OptimizationException optimizationException) {
            // empty catch block
        }
        try {
            optimizer.optimize();
        }
        catch (OptimizationException optimizationException) {
            // empty catch block
        }
        this.dmrParameters = optimizable.getClassifier();
        for (int doc = 0; doc < this.data.size(); ++doc) {
            this.cacheAlphas(((TopicAssignment)this.data.get((int)doc)).instance, doc);
        }
    }

    @Override
    public void printTopWords(PrintStream out, int numWords, boolean usingNewLines) {
        super.printTopWords(out, numWords, usingNewLines);
    }

    public void writeParameters(File parameterFile) throws IOException {
        if (this.dmrParameters != null) {
            PrintStream out = new PrintStream(parameterFile);
            this.dmrParameters.print(out);
            out.close();
        }
    }

    @Override
    public double modelLogLikelihood() {
        double logLikelihood = 0.0;
        int[] topicCounts = new int[this.numTopics];
        for (int doc = 0; doc < this.data.size(); ++doc) {
            LabelSequence topicSequence = ((TopicAssignment)this.data.get((int)doc)).topicSequence;
            FeatureVector features = (FeatureVector)((TopicAssignment)this.data.get((int)doc)).instance.getTarget();
            double[] parameters = this.dmrParameters.getParameters();
            int[] docTopics = topicSequence.getFeatures();
            for (int token = 0; token < docTopics.length; ++token) {
                int n = docTopics[token];
                topicCounts[n] = topicCounts[n] + 1;
            }
            for (int topic = 0; topic < this.numTopics; ++topic) {
                if (topicCounts[topic] <= 0) continue;
                logLikelihood += Dirichlet.logGammaStirling(this.alphaCache[doc][topic] + (double)topicCounts[topic]) - Dirichlet.logGammaStirling(this.alphaCache[doc][topic]);
            }
            logLikelihood -= Dirichlet.logGammaStirling(this.alphaSumCache[doc] + (double)docTopics.length) + Dirichlet.logGammaStirling(this.alphaSumCache[doc]);
            Arrays.fill(topicCounts, 0);
        }
        int nonZeroTypeTopics = 0;
        for (int type = 0; type < this.numTypes; ++type) {
            topicCounts = this.typeTopicCounts[type];
            for (int index = 0; index < topicCounts.length && topicCounts[index] > 0; ++index) {
                int topic = topicCounts[index] & this.topicMask;
                int count = topicCounts[index] >> this.topicBits;
                ++nonZeroTypeTopics;
                if (Double.isNaN(logLikelihood += Dirichlet.logGammaStirling(this.beta + (double)count))) {
                    logger.warning("NaN in log likelihood calculation");
                    return 0.0;
                }
                if (!Double.isInfinite(logLikelihood)) continue;
                logger.warning("infinite log likelihood");
                return 0.0;
            }
        }
        for (int topic = 0; topic < this.numTopics; ++topic) {
            if (Double.isNaN(logLikelihood -= Dirichlet.logGammaStirling(this.beta * (double)this.numTypes + (double)this.tokensPerTopic[topic]))) {
                logger.info("NaN after topic " + topic + " " + this.tokensPerTopic[topic]);
                return 0.0;
            }
            if (!Double.isInfinite(logLikelihood)) continue;
            logger.info("Infinite value after topic " + topic + " " + this.tokensPerTopic[topic]);
            return 0.0;
        }
        logLikelihood += Dirichlet.logGammaStirling(this.beta * (double)this.numTypes) * (double)this.numTopics;
        if (Double.isNaN(logLikelihood -= Dirichlet.logGammaStirling(this.beta) * (double)nonZeroTypeTopics)) {
            logger.info("at the end");
        } else if (Double.isInfinite(logLikelihood)) {
            logger.info("Infinite value beta " + this.beta + " * " + this.numTypes);
            return 0.0;
        }
        return logLikelihood;
    }

    @Override
    public DMRInferencer getInferencer() {
        return new DMRInferencer(this.typeTopicCounts, this.tokensPerTopic, this.dmrParameters, this.alphabet, this.beta, this.betaSum);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.dmrParameters);
        out.writeObject(this.data);
        out.writeObject(this.alphabet);
        out.writeObject(this.topicAlphabet);
        out.writeInt(this.numTopics);
        out.writeInt(this.topicMask);
        out.writeInt(this.topicBits);
        out.writeInt(this.numTypes);
        out.writeObject(this.alpha);
        out.writeDouble(this.alphaSum);
        out.writeDouble(this.beta);
        out.writeDouble(this.betaSum);
        out.writeObject(this.typeTopicCounts);
        out.writeObject(this.tokensPerTopic);
        out.writeObject(this.docLengthCounts);
        out.writeObject(this.topicDocCounts);
        out.writeInt(this.numIterations);
        out.writeInt(this.burninPeriod);
        out.writeInt(this.saveSampleInterval);
        out.writeInt(this.optimizeInterval);
        out.writeInt(this.showTopicsInterval);
        out.writeInt(this.wordsPerTopic);
        out.writeInt(this.saveStateInterval);
        out.writeObject(this.stateFilename);
        out.writeInt(this.saveModelInterval);
        out.writeObject(this.modelFilename);
        out.writeInt(this.randomSeed);
        out.writeObject(this.formatter);
        out.writeBoolean(this.printLogLikelihood);
        out.writeInt(this.numThreads);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.dmrParameters = (MaxEnt)in.readObject();
        this.numFeatures = this.dmrParameters.getAlphabet().size();
        this.defaultFeatureIndex = this.dmrParameters.getDefaultFeatureIndex();
        this.data = (ArrayList)in.readObject();
        this.alphabet = (Alphabet)in.readObject();
        this.topicAlphabet = (LabelAlphabet)in.readObject();
        this.numTopics = in.readInt();
        this.topicMask = in.readInt();
        this.topicBits = in.readInt();
        this.numTypes = in.readInt();
        this.alpha = (double[])in.readObject();
        this.alphaSum = in.readDouble();
        this.beta = in.readDouble();
        this.betaSum = in.readDouble();
        this.typeTopicCounts = (int[][])in.readObject();
        this.tokensPerTopic = (int[])in.readObject();
        this.docLengthCounts = (int[])in.readObject();
        this.topicDocCounts = (int[][])in.readObject();
        this.numIterations = in.readInt();
        this.burninPeriod = in.readInt();
        this.saveSampleInterval = in.readInt();
        this.optimizeInterval = in.readInt();
        this.showTopicsInterval = in.readInt();
        this.wordsPerTopic = in.readInt();
        this.saveStateInterval = in.readInt();
        this.stateFilename = (String)in.readObject();
        this.saveModelInterval = in.readInt();
        this.modelFilename = (String)in.readObject();
        this.randomSeed = in.readInt();
        this.formatter = (NumberFormat)in.readObject();
        this.printLogLikelihood = in.readBoolean();
        this.numThreads = in.readInt();
    }

    @Override
    public void write(File serializedModelFile) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(serializedModelFile));
            oos.writeObject(this);
            oos.close();
        }
        catch (IOException e) {
            System.err.println("Problem serializing DMRTopicModel to file " + serializedModelFile + ": " + e);
        }
    }

    public static DMRTopicModel read(File f) throws Exception {
        DMRTopicModel topicModel = null;
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
        topicModel = (DMRTopicModel)ois.readObject();
        ois.close();
        return topicModel;
    }

    public static void main(String[] args) throws IOException {
        CommandOption.setSummary(DMRTopicModel.class, "A tool for estimating, saving and printing diagnostics for topic models with arbitrary document features.");
        CommandOption.process(DMRTopicModel.class, args);
        if (!inputFile.wasInvoked()) {
            System.err.println("You must specify a data set with the --input option.");
            System.exit(1);
        }
        DMRTopicModel topicModel = null;
        if (DMRTopicModel.inputModelFilename.value != null) {
            try {
                topicModel = DMRTopicModel.read(new File(DMRTopicModel.inputModelFilename.value));
            }
            catch (Exception e) {
                System.err.println("Unable to restore saved topic model " + DMRTopicModel.inputModelFilename.value + ": " + e);
                System.exit(1);
            }
        } else {
            Object data;
            InstanceList training = InstanceList.load(new File(DMRTopicModel.inputFile.value));
            System.out.println("Data loaded.");
            if (training.size() > 0 && training.get(0) != null && !((data = ((Instance)training.get(0)).getData()) instanceof FeatureSequence)) {
                System.err.println("Topic modeling currently only supports feature sequences: use --keep-sequence option when importing data.");
                System.exit(1);
            }
            topicModel = new DMRTopicModel(DMRTopicModel.numTopicsOption.value);
            if (DMRTopicModel.randomSeedOption.value != 0) {
                topicModel.setRandomSeed(DMRTopicModel.randomSeedOption.value);
            }
            topicModel.addInstances(training);
        }
        topicModel.setNumThreads(DMRTopicModel.numThreadsOption.value);
        topicModel.setTopicDisplay(DMRTopicModel.showTopicsIntervalOption.value, DMRTopicModel.topWordsOption.value);
        topicModel.setNumIterations(DMRTopicModel.numIterationsOption.value);
        topicModel.setOptimizeInterval(DMRTopicModel.optimizeIntervalOption.value);
        topicModel.setBurninPeriod(DMRTopicModel.optimizeBurnInOption.value);
        if (DMRTopicModel.outputStateIntervalOption.value != 0) {
            topicModel.setSaveState(DMRTopicModel.outputStateIntervalOption.value, DMRTopicModel.stateFile.value);
        }
        topicModel.parametersFilename = DMRTopicModel.outputParametersFilename.value;
        topicModel.saveParametersInterval = DMRTopicModel.outputParametersIntervalOption.value;
        topicModel.estimate();
        topicModel.writeParameters(new File(DMRTopicModel.outputParametersFilename.value));
        if (DMRTopicModel.topicKeysFile.value != null) {
            topicModel.printTopWords(new File(DMRTopicModel.topicKeysFile.value), DMRTopicModel.topWordsOption.value, false);
        }
        if (DMRTopicModel.stateFile.value != null) {
            topicModel.printState(new File(DMRTopicModel.stateFile.value));
        }
        if (DMRTopicModel.docTopicsFile.value != null) {
            PrintWriter out = new PrintWriter(new FileWriter(new File(DMRTopicModel.docTopicsFile.value)));
            topicModel.printDocumentTopics(out, DMRTopicModel.docTopicsThreshold.value, DMRTopicModel.docTopicsMax.value);
            out.close();
        }
        if (DMRTopicModel.inferencerFilename.value != null) {
            DMRInferencer inferencer = topicModel.getInferencer();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(DMRTopicModel.inferencerFilename.value));
                oos.writeObject(topicModel.getInferencer());
                oos.close();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        if (DMRTopicModel.outputModelFilename.value != null) {
            assert (topicModel != null);
            topicModel.write(new File(DMRTopicModel.outputModelFilename.value));
        }
    }
}

