/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.SimpleTokenizer;
import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureCounter;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.Instance;
import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.cursors.IntCursor;

public class FeatureDocFreqPipe
extends Pipe {
    FeatureCounter counter;
    int numInstances;
    static final long serialVersionUID = 1L;

    public FeatureDocFreqPipe() {
        super(new Alphabet(), null);
        this.counter = new FeatureCounter(this.getDataAlphabet());
        this.numInstances = 0;
    }

    public FeatureDocFreqPipe(Alphabet dataAlphabet, Alphabet targetAlphabet) {
        super(dataAlphabet, targetAlphabet);
        this.counter = new FeatureCounter(dataAlphabet);
        this.numInstances = 0;
    }

    @Override
    public Instance pipe(Instance instance) {
        IntIntHashMap localCounter = new IntIntHashMap();
        if (instance.getData() instanceof FeatureSequence) {
            FeatureSequence features = (FeatureSequence)instance.getData();
            for (int position = 0; position < features.size(); ++position) {
                localCounter.putOrAdd(features.getIndexAtPosition(position), 1, 1);
            }
        } else {
            throw new IllegalArgumentException("Looking for a FeatureSequence, found a " + instance.getData().getClass());
        }
        for (IntCursor feature : localCounter.keys()) {
            this.counter.increment(feature);
        }
        ++this.numInstances;
        return instance;
    }

    public void addPrunedWordsToStoplist(SimpleTokenizer tokenizer, double docFrequencyCutoff) {
        Alphabet currentAlphabet = this.getDataAlphabet();
        for (int feature = 0; feature < currentAlphabet.size(); ++feature) {
            if (!((double)this.counter.get(feature) / (double)this.numInstances > docFrequencyCutoff)) continue;
            tokenizer.stop((String)currentAlphabet.lookupObject(feature));
        }
    }
}

