/*
 * Decompiled with CFR 0.152.
 */
package cambria.jgat;

import cambria.jgat.FitnessLandscape;
import cambria.jgat.Optimized;
import cambria.misc.MyMath;

public class GA
implements Runnable {
    private int chromosomeLength;
    private int maxChromosomeState;
    private int populationSize;
    private int eliteSize = 10;
    private Optimized[] optimized;
    private int generation = 0;
    private int maxGeneration;
    private int crossoverPosition;
    private int bestIndividual;
    private FitnessLandscape[] fitnessLandscape;
    private Thread thread;
    private double mutationRate = 0.001;
    private double crossoverRate = 0.7;
    private boolean getOptimized;
    private double bestFitness;
    private double[] pastBestFitness;
    private int windowForMA = 10;
    private int swapSize;

    public GA(Optimized[] optimized, FitnessLandscape[] fitnessLandscape, int eliteSize) {
        this(optimized, fitnessLandscape);
        this.eliteSize = eliteSize;
        this.swapSize = this.populationSize - eliteSize;
        if (MyMath.mode(this.swapSize, 2) != 0) {
            throw new IllegalArgumentException("Swap size must be a multiple of 2");
        }
    }

    public GA(Optimized[] optimized, FitnessLandscape[] fitnessLandscape) {
        this.optimized = optimized;
        this.populationSize = optimized.length;
        if (MyMath.mode(this.populationSize, 2) != 0) {
            throw new IllegalArgumentException("Population size must be a multiple of 2");
        }
        this.chromosomeLength = optimized[0].getChromosomeLength();
        this.maxChromosomeState = optimized[0].getMaxChromosomeState();
        this.fitnessLandscape = fitnessLandscape;
        for (int i = 0; i < this.populationSize; ++i) {
            fitnessLandscape[i].updateFitness();
            double fitness = fitnessLandscape[i].getFitness();
            optimized[i].setFitness(fitness);
        }
        this.pastBestFitness = new double[this.windowForMA];
    }

    public void setCrossoverRate(double crossoverRate) {
        this.crossoverRate = crossoverRate;
    }

    public void setMutationRate(double mutationRate) {
        this.mutationRate = mutationRate;
    }

    public double getMaxFitness() {
        double maximum = this.optimized[0].getFitness();
        for (int i = 1; i < this.populationSize; ++i) {
            maximum = Math.max(maximum, this.optimized[i].getFitness());
        }
        return maximum;
    }

    public double getTotalFitness() {
        double sum = 0.0;
        for (int i = 0; i < this.populationSize; ++i) {
            sum += this.optimized[i].getFitness();
        }
        return sum;
    }

    private double getBestFitness() {
        return this.bestFitness;
    }

    private void updateBestFitness() {
        double best = this.optimized[0].getFitness();
        for (int i = 1; i < this.populationSize; ++i) {
            if (!(best < this.optimized[i].getFitness())) continue;
            best = this.optimized[i].getFitness();
        }
        this.bestFitness = best;
    }

    private void updatePastBestFitness() {
        for (int i = 0; i < this.windowForMA - 1; ++i) {
            this.pastBestFitness[i] = this.pastBestFitness[i + 1];
        }
        this.pastBestFitness[this.windowForMA - 1] = this.getBestFitness();
    }

    private double getBestFitnessMA() {
        double sum = 0.0;
        for (int i = 0; i < this.windowForMA; ++i) {
            sum += this.pastBestFitness[i];
        }
        return sum / (double)this.windowForMA;
    }

    private synchronized int getGeneration() {
        return this.generation;
    }

    @Override
    public void run() {
        this.thread = Thread.currentThread();
        this.thread.setPriority(1);
        do {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.step();
        } while (Thread.currentThread() == this.thread || this.getGeneration() == this.maxGeneration);
    }

    public void report(StringBuffer buff) {
        this.updateBestFitness();
        this.updatePastBestFitness();
        System.out.print(this.generation + ".");
        System.out.print(" bestFitness=" + Double.toString(this.getBestFitness()));
        System.out.println(" MA= " + Double.toString(this.getBestFitnessMA()));
        buff.append(" " + this.generation + " " + Double.toString(this.getBestFitness()) + " " + Double.toString(this.getTotalFitness()) + System.getProperty("line.separator"));
    }

    public synchronized void step() {
        int i;
        this.setSelectionProb();
        int[][] tempChromosome = new int[this.swapSize][this.chromosomeLength];
        int[][] tempChromosome2 = new int[2][this.chromosomeLength];
        for (i = 0; i < this.swapSize / 2; ++i) {
            int j;
            int father = this.selectParent();
            int mother = this.selectParent();
            tempChromosome2[0] = this.optimized[father].getChromosome();
            tempChromosome2[1] = this.optimized[mother].getChromosome();
            if (Math.random() < this.crossoverRate) {
                int position = MyMath.irand(this.chromosomeLength - 1) + 1;
                tempChromosome[i * 2] = this.getCrossovered1(tempChromosome2, position);
                tempChromosome[i * 2 + 1] = this.getCrossovered2(tempChromosome2, position);
                continue;
            }
            for (j = 0; j < this.chromosomeLength; ++j) {
                tempChromosome[i * 2][j] = tempChromosome2[0][j];
            }
            for (j = 0; j < this.chromosomeLength; ++j) {
                tempChromosome[i * 2 + 1][j] = tempChromosome2[1][j];
            }
        }
        for (i = 0; i < this.swapSize; ++i) {
            this.optimized[i].copyChromosome(tempChromosome[i]);
            this.optimized[i].mutation(this.mutationRate);
        }
        for (i = 0; i < this.populationSize; ++i) {
            this.fitnessLandscape[i].setOptimized(false);
            this.fitnessLandscape[i].updateFitness();
            double fitness = this.fitnessLandscape[i].getFitness();
            this.optimized[i].setFitness(fitness);
        }
        this.separateElites();
        this.getOptimized = this.isThereOptimized();
        ++this.generation;
    }

    private boolean isThereOptimized() {
        for (int i = 0; i < this.populationSize; ++i) {
            if (!this.fitnessLandscape[i].isOptimized()) continue;
            System.out.println("A chromosome is optimized at " + i);
            return true;
        }
        return false;
    }

    public void updatePhenotype() {
        for (int i = 0; i < this.populationSize; ++i) {
            this.fitnessLandscape[i].setOptimized(false);
            this.fitnessLandscape[i].updateFitness();
        }
    }

    public boolean isThereOptimzedOne() {
        boolean getOptimized = false;
        for (int i = 0; i < this.populationSize; ++i) {
            if (!this.fitnessLandscape[i].isOptimized()) continue;
            getOptimized = true;
            System.out.println("A chromosome is optimized.");
        }
        return getOptimized;
    }

    private void separateElites() {
        int[][] tempChromosome = new int[this.populationSize][this.chromosomeLength];
        double[] tempFitness = new double[this.populationSize];
        for (int i = 0; i < this.populationSize; ++i) {
            for (int j = 0; j < this.chromosomeLength; ++j) {
                tempChromosome[i][j] = this.optimized[i].getChromosome()[j];
            }
            tempFitness[i] = this.optimized[i].getFitness();
        }
        int j = 0;
        int k = 0;
        for (int i = 0; i < this.populationSize; ++i) {
            if (this.isElite(i)) {
                this.optimized[this.populationSize - ++j].copyChromosome(tempChromosome[i]);
                continue;
            }
            this.optimized[k].copyChromosome(tempChromosome[i]);
            ++k;
        }
        if (j + k != this.populationSize) {
            throw new RuntimeException("Contradictory found.");
        }
    }

    private boolean isElite(int index) {
        int rank = 1;
        double fitness = this.optimized[index].getFitness();
        for (int currentIndex = 0; currentIndex < this.populationSize; ++currentIndex) {
            if (!(fitness < this.optimized[currentIndex].getFitness())) continue;
            ++rank;
        }
        return rank <= this.eliteSize;
    }

    private int[] getCrossovered1(int[][] chromosomePair, int position) {
        int i;
        if (position > this.chromosomeLength) {
            throw new IllegalArgumentException();
        }
        int[] dum = new int[this.chromosomeLength];
        for (i = 0; i < position; ++i) {
            dum[i] = chromosomePair[0][i];
        }
        for (i = position; i < this.chromosomeLength; ++i) {
            dum[i] = chromosomePair[1][i];
        }
        return dum;
    }

    private int[] getCrossovered2(int[][] chromosomePair, int position) {
        int i;
        if (position > this.chromosomeLength) {
            throw new IllegalArgumentException();
        }
        int[] dum = new int[this.chromosomeLength];
        for (i = 0; i < position; ++i) {
            dum[i] = chromosomePair[1][i];
        }
        for (i = position; i < this.chromosomeLength; ++i) {
            dum[i] = chromosomePair[0][i];
        }
        return dum;
    }

    private void setSelectionProb() {
        double totalFitness = this.getTotalFitness();
        for (int i = 0; i < this.populationSize; ++i) {
            double prob = this.fitnessLandscape[i].getFitness() / totalFitness;
            this.optimized[i].setSelectionProbability(prob);
        }
    }

    private int selectParent() {
        double sum = 0.0;
        double ran = Math.random();
        for (int i = 0; i < this.populationSize; ++i) {
            if (!(ran < (sum += this.optimized[i].getSelectionProbability()))) continue;
            return i;
        }
        throw new RuntimeException();
    }

    private void showSchema() {
        int i;
        int[] chromosome = this.optimized[0].getChromosome();
        boolean[] isVariable = new boolean[this.chromosomeLength];
        for (i = 1; i < this.populationSize; ++i) {
            for (int j = 0; j < this.chromosomeLength; ++j) {
                if (chromosome[j] == this.optimized[i].getChromosome()[j]) continue;
                isVariable[j] = true;
            }
        }
        System.out.print(" Schema ");
        for (i = 0; i < this.chromosomeLength; ++i) {
            if (isVariable[i]) {
                System.out.print(" **");
                continue;
            }
            if (chromosome[i] < 10) {
                System.out.print("  " + chromosome[i]);
                continue;
            }
            System.out.print(" " + chromosome[i]);
        }
        System.out.println(" is found.");
    }

    public boolean isOptimized() {
        return this.getOptimized;
    }

    public void setOptimized(boolean getOptimized) {
        this.getOptimized = getOptimized;
    }

    public static int getBestFitNumber(Optimized[] optimized, int populationSize) {
        int bestIndividual = 0;
        double bestFitness = optimized[0].getFitness();
        for (int i = 1; i < populationSize; ++i) {
            if (!(bestFitness < optimized[i].getFitness())) continue;
            bestFitness = optimized[i].getFitness();
            bestIndividual = i;
        }
        return bestIndividual;
    }
}

