/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.Block16;
import cambria.BlockOfCells;
import cambria.CARule;
import cambria.Demon;
import cambria.InteractingEnergy;
import cambria.Partition;
import cambria.PartitionIF;
import cambria.PartitionRule;
import cambria.PartitionRuleIO;
import cambria.PartitionRuleString;
import cambria.RuleSwitcher;
import cambria.StochasticRuleUnit;
import cambria.misc.MyMath;
import cambria.misc.MyString;
import java.awt.Button;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.util.Random;

public class CanonicalRule
extends CARule
implements PartitionIF,
InteractingEnergy,
RuleSwitcher {
    private int statePerCell;
    private static final int coreMaxNeighbor = 4;
    private static final int extendedMaxNeighbor = 16;
    private int maxRuleEntry;
    private int maxPartition = 16;
    private int maxRuleSelection;
    private int currentSelection = 0;
    private int[][] ruleArray;
    private boolean initialized = false;
    private Demon demon;
    private Panel demonPanel;
    private Button closeButton;
    private Random rand = new Random(System.currentTimeMillis());
    private static final int startIndex = 2;
    private static final int unitE = 1;

    private int getLocalIntEnergy(Block16 partition) {
        int energySum = 0;
        if (partition.getHomeState() != 0) {
            energySum -= 1 * (partition.getNorthState() - partition.getEastState() + partition.getSouthState() - partition.getWestState() - partition.getWnState() - partition.getNeState() - partition.getEsState() - partition.getSwState());
        }
        if (partition.getEastState() != 0) {
            energySum -= 1 * (partition.getNeState() - partition.getEeState() + partition.getEsState() - partition.getNorthState() - partition.getNeeState() - partition.getEesState() - partition.getSouthState());
        }
        if (partition.getEsState() != 0) {
            energySum -= 1 * (-partition.getEesState() + partition.getEssState() - partition.getSouthState() - partition.getHomeState() - partition.getEeState() - partition.getEessState() - partition.getSsState());
        }
        if (partition.getSouthState() != 0) {
            energySum -= 1 * (partition.getSsState() - partition.getSwState() - partition.getWestState() - partition.getEastState() - partition.getEssState() - partition.getSswState());
        }
        return energySum;
    }

    @Override
    public void setDemon(Demon demon) {
        demon.setColdestBeta(2.0);
        this.demon = demon;
    }

    @Override
    public int getMaxSelection() {
        return this.maxRuleSelection;
    }

    @Override
    public void initializeRuleArray(int statePerCell, int maxRuleSelection) {
        this.statePerCell = statePerCell;
        this.maxRuleSelection = maxRuleSelection;
        this.maxRuleEntry = MyMath.ipow(statePerCell, 4);
        this.ruleArray = new int[this.maxRuleEntry][maxRuleSelection];
        this.initialized = true;
    }

    @Override
    public void setRule(String RuleString, String filename) {
        String[] RuleStringComp;
        if (!this.initialized) {
            throw new RuntimeException("RuleArray not initialized.");
        }
        if (RuleString == null) {
            if (filename == null) {
                throw new IllegalArgumentException("null arguments");
            }
            PartitionRuleIO partitionRuleIO = new PartitionRuleIO(filename);
            RuleString = partitionRuleIO.buff.toString();
        }
        if (this.maxRuleSelection != (RuleStringComp = PartitionRuleString.getRuleStringComp(RuleString)).length) {
            throw new RuntimeException("Invlid RuleString");
        }
        for (int i = 0; i < this.maxRuleSelection; ++i) {
            this.setRule(RuleStringComp[i], i);
        }
    }

    private void setRule(String RuleString, int selectionNumber) {
        if (PartitionRuleString.isStochastic(RuleString)) {
            throw new RuntimeException("Stochastic rule is found.");
        }
        this.statePerCell = Integer.parseInt(MyString.lindex(RuleString, 0));
        if (this.statePerCell != this.statePerCell) {
            throw new RuntimeException("Invalid statePerCell");
        }
        int maxNeighbor = Integer.parseInt(MyString.lindex(RuleString, 1));
        if (4 != maxNeighbor) {
            throw new RuntimeException("Invalid coreMaxNeighbor of RuleString");
        }
        String RuleContent = MyString.stripHeader(RuleString, 2);
        StochasticRuleUnit[] stochasticRuleArray = PartitionRuleString.createRuleArray(this.statePerCell, 4, RuleContent);
        for (int i = 0; i < this.ruleArray.length; ++i) {
            this.ruleArray[i][selectionNumber] = stochasticRuleArray[i].output;
        }
    }

    @Override
    public BlockOfCells outputBlock(BlockOfCells boc) {
        Block16 partitionIn = (Block16)boc;
        int x = partitionIn.getXAxis();
        int y = partitionIn.getYAxis();
        Partition corePartitionIn = new Partition(4);
        corePartitionIn.setHomeState(partitionIn.getHomeState());
        corePartitionIn.setEastState(partitionIn.getEastState());
        corePartitionIn.setEsState(partitionIn.getEsState());
        corePartitionIn.setSouthState(partitionIn.getSouthState());
        int ruleEntry = this.getRuleEntry(corePartitionIn);
        this.currentSelection = MyMath.mode(this.currentSelection + 1, this.maxRuleSelection);
        Partition corePartitionOut = this.getPartition(ruleEntry, this.currentSelection);
        Block16 partitionTemp = new Block16(partitionIn);
        partitionTemp.setHomeState(corePartitionOut.getHomeState());
        partitionTemp.setEastState(corePartitionOut.getEastState());
        partitionTemp.setEsState(corePartitionOut.getEsState());
        partitionTemp.setSouthState(corePartitionOut.getSouthState());
        int energyIncrease = this.getLocalIntEnergy(partitionTemp) - this.getLocalIntEnergy(partitionIn);
        int demonEnergy = this.demon.getEnergy(x, y);
        if (energyIncrease > demonEnergy) {
            return partitionIn;
        }
        this.demon.setEnergy(x, y, demonEnergy - energyIncrease);
        return partitionTemp;
    }

    private int getRuleEntry(Partition partition) {
        int sum = 0;
        sum += MyMath.ipow(this.statePerCell, 3) * partition.getHomeState();
        sum += MyMath.ipow(this.statePerCell, 2) * partition.getEastState();
        sum += MyMath.ipow(this.statePerCell, 1) * partition.getSouthState();
        return sum += MyMath.ipow(this.statePerCell, 0) * partition.getEsState();
    }

    @Override
    public void updateDemon() {
        if (this.demon.isFixedDemon()) {
            this.demon.setAveEnergy();
        }
    }

    private Partition getPartition(int ruleEntry, int currentSelection) {
        int out = this.ruleArray[ruleEntry][currentSelection];
        return PartitionRule.int2Partition(out, this.statePerCell, 4);
    }

    @Override
    public void edit() {
        if (this.demonPanel == null) {
            if (this.demon == null) {
                throw new IllegalArgumentException("This size of neighbor is not vaild.");
            }
            this.demon.addPanel(this);
            this.demonPanel = new Panel();
            this.closeButton = new Button("close");
            this.closeButton.addActionListener(this);
            this.demonPanel.add(this.closeButton);
            this.add("South", this.demonPanel);
            this.pack();
        }
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        if (obj != this.closeButton) {
            throw new RuntimeException("Action not defined for" + obj.toString());
        }
        this.setVisible(false);
    }

    @Override
    public String getDefaultThread() {
        return "MCSThread";
    }

    @Override
    public int getStatePerCell() {
        return this.statePerCell;
    }

    @Override
    public int getMaxNeighbor() {
        return 4;
    }

    public int getExtendedMaxNeighbor() {
        return 16;
    }

    public int getMaxRuleEntry() {
        return this.maxRuleEntry;
    }
}

