/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.CAConfig;
import cambria.CAPanel;

public class CARunner
implements Runnable {
    private Thread thread;
    private CAPanel cap;
    private CAConfig caConfig;
    private int deltaTime = 25;

    public CARunner(int deltaTime, CAPanel cap) {
        this.deltaTime = deltaTime;
        this.cap = cap;
        this.caConfig = cap.getCAConfig();
    }

    public CAPanel getCAPanel() {
        return this.cap;
    }

    public void setDeltaTime(int deltaTime) {
        this.deltaTime = deltaTime;
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
        }
        this.thread.start();
    }

    public void stop() {
        this.thread = null;
    }

    public boolean isAlive() {
        return this.thread != null;
    }

    @Override
    public void run() {
        this.thread = Thread.currentThread();
        this.thread.setPriority(1);
        do {
            try {
                Thread.sleep(this.deltaTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.caConfig.step();
            this.cap.repaint();
        } while (Thread.currentThread() == this.thread);
        this.stop();
    }
}

