/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.CAConfig;
import cambria.CARule;
import java.util.Date;

public class CABenchmark {
    static final float ppc_g4_400_os8 = 19.8f;
    static final float ppc_g4_400_osx = 23.0f;
    static final float ppc_g3_500 = 17.3f;
    static final float pent_3_866 = 9.5f;
    static final float pent_3_866_new = 8.9f;
    static final float pent_4_1700_new = 6.4f;
    static final float pent_3_866_linux = 78.0f;

    public static void printElaspedTime(CAConfig caConfig, int timeSpan) {
        int i;
        CARule rule = caConfig.getCARule();
        System.out.println("This is a cellular automata benchmark test.");
        System.out.println("rule used: " + rule.toString());
        System.out.println("x_max : " + caConfig.getXMax());
        System.out.println("y_max : " + caConfig.getYMax());
        System.out.println("interation : " + timeSpan);
        System.out.println("Wait a while please.");
        for (i = 0; i < timeSpan; ++i) {
            caConfig.step();
        }
        Date date1 = new Date();
        for (i = 0; i < timeSpan; ++i) {
            caConfig.step();
        }
        Date date2 = new Date();
        long numeric = date2.getTime() - date1.getTime();
        System.out.println("The standard machine PowerPC G4 400 MHz, Mac OS 8.6, MRJ2.2: 19.8sec");
        System.out.println("PowerPC G4 400 MHz, Mac OSX, Java 1.2: 23.0sec");
        System.out.println("PowerPC G3 500 MHz, MacOSX Java 1.2: 17.3sec");
        System.out.println("Pentium III 866 MHz, Windows2000 Server, Java 1.1.8: 9.5sec");
        System.out.println("Pentium III 866 MHz, Windows2000 Server, jview: 8.9sec");
        System.out.println("Pentium III 866 MHz, RedHat Linux 7.3, Java 1.2: 78.0sec");
        System.out.println("Pentium IV 1700 MHz, Windows2000, jview: 6.4sec");
        System.out.println("This machine: " + (double)numeric / 1000.0 + "sec");
        System.out.println("   Performance compared to the standard machine: " + (double)19.8f / ((double)numeric / 1000.0));
    }
}

