/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.misc.MyFileReader;
import cambria.misc.MyString;

public class BestSelectedTrans {
    private int[][] ruleArray;
    private String dataFilename;
    private String directory;
    private double[][] transProb = new double[32][32];
    private int maxRule;
    private int firstNumber;
    private int lastNumber;
    private static final int numberOfDigits = 3;
    private static final int maxRuleEntry = 32;
    private static final int top = 2;
    private int[] topTrans = new int[2];
    private double[] topValue = new double[2];

    public static void main(String[] arg) {
        try {
            System.out.println("stemName is " + arg[0]);
            System.out.println("first number is " + arg[1]);
            System.out.println("last number is " + arg[2]);
            System.out.println("data directory is " + arg[3]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Usage: >java BestSelectedTrans <stemName> <firstNumber> <lastNumber> <dataDirectoty>");
            System.exit(-1);
        }
        BestSelectedTrans bestSelectedTrans = new BestSelectedTrans(arg[0], arg[1], arg[2], arg[3]);
    }

    public BestSelectedTrans(String stemName, String FirstNumber, String LastNumber, String directory) {
        this.firstNumber = MyString.convertIntParameter(FirstNumber);
        this.lastNumber = MyString.convertIntParameter(LastNumber);
        this.maxRule = this.lastNumber - this.firstNumber + 1;
        this.ruleArray = new int[32][this.maxRule];
        this.directory = directory;
        this.dataFilename = directory != null ? directory + System.getProperty("file.separator") + stemName : stemName;
        this.readRules();
        for (int i = 0; i < 32; ++i) {
            this.getTop(i);
            System.out.print(" entry " + i + "  ");
            for (int j = 0; j < 2; ++j) {
                System.out.print(this.topTrans[j] + ":" + this.topValue[j] + "    ");
            }
            System.out.println("");
        }
    }

    public void readRules() {
        for (int i = 0; i < this.maxRule; ++i) {
            String fileName = this.dataFilename + MyString.getDigits(i + this.firstNumber, 3) + ".par";
            System.out.println(fileName);
            String fileContents = MyFileReader.file2string(fileName);
            for (int j = 0; j < 32; ++j) {
                String str = MyString.stripBack(MyString.lindex(fileContents, j + 2), ':');
                this.ruleArray[j][i] = MyString.convertIntParameter(str);
            }
        }
    }

    public void getTop(int entry) {
        int i;
        double[] prob = new double[32];
        int[] rank = new int[32];
        for (i = 0; i < 32; ++i) {
            prob[i] = this.getProb(entry, i);
        }
        for (i = 0; i < 32; ++i) {
            rank[i] = this.getRank(prob, i);
        }
        for (i = 0; i < 2; ++i) {
            this.topTrans[i] = this.searchIndex(rank, i);
            this.topValue[i] = prob[this.topTrans[i]];
        }
    }

    private int searchIndex(int[] array, int target) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        throw new RuntimeException("Target value not found. Bug: Haven't thought about the same rank. Change th sample and retry. ");
    }

    private int getRank(double[] value, int index) {
        int rank = 0;
        double a = value[index];
        for (int i = 0; i < value.length; ++i) {
            if (!(a < value[i])) continue;
            ++rank;
        }
        return rank;
    }

    private double getProb(int input, int output) {
        int sum = 0;
        for (int i = 0; i < this.maxRule; ++i) {
            if (this.ruleArray[input][i] != output) continue;
            ++sum;
        }
        return (double)sum / (double)this.maxRule;
    }
}

