/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Dimension;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visad.CellImpl;
import visad.ControlEvent;
import visad.ControlListener;
import visad.Data;
import visad.DataReference;
import visad.Display;
import visad.PlotText;
import visad.Real;
import visad.RealType;
import visad.RemoteCellImpl;
import visad.RemoteDataReference;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.ValueControl;
import visad.VisADException;
import visad.collab.CollabUtil;
import visad.util.Util;

public class VisADSlider
extends JPanel
implements ChangeListener,
ControlListener,
ScalarMapListener {
    private static final int D_TICKS = 1000;
    private static final int SLIDER_WIDTH = 150;
    private static final int LABEL_WIDTH = 200;
    private JSlider slider;
    private JLabel label;
    private ScalarMap map;
    private ValueControl control;
    private DataReference sRef;
    private RealType realType;
    private String sName;
    private double sMinimum;
    private double sMaximum;
    private double sCurrent;
    private int sTicks;
    private boolean autoScale;
    private boolean integralValues;
    private boolean dynamicLabelWidth;

    public VisADSlider(String n, int lo, int hi, int st, double scale, DataReference ref, RealType rt) throws VisADException, RemoteException {
        this(ref, null, (float)((double)lo * scale), (float)((double)hi * scale), (float)((double)st * scale), hi - lo, ref == null || ref.getData() instanceof Real ? null : rt, n, false, false);
    }

    public VisADSlider(String n, int lo, int hi, int st, double scale, DataReference ref, RealType rt, boolean dynamicLabelWidth) throws VisADException, RemoteException {
        this(ref, null, (float)((double)lo * scale), (float)((double)hi * scale), (float)((double)st * scale), hi - lo, ref == null || ref.getData() instanceof Real ? null : rt, n, false, dynamicLabelWidth);
    }

    public VisADSlider(ScalarMap smap) throws VisADException, RemoteException {
        this(null, smap, Float.NaN, Float.NaN, Float.NaN, 1000, null, null, false, false);
    }

    public VisADSlider(ScalarMap smap, boolean integralTicks) throws VisADException, RemoteException {
        this(null, smap, Float.NaN, Float.NaN, Float.NaN, 1000, null, null, integralTicks, false);
    }

    public VisADSlider(ScalarMap smap, boolean integralTicks, boolean dynamicLabelWidth) throws VisADException, RemoteException {
        this(null, smap, Float.NaN, Float.NaN, Float.NaN, 1000, null, null, integralTicks, dynamicLabelWidth);
    }

    public VisADSlider(ScalarMap smap, float min, float max) throws VisADException, RemoteException {
        this(null, smap, min, max, Float.NaN, 1000, null, null, false, false);
    }

    public VisADSlider(DataReference ref, float min, float max, float start, RealType rt, String n) throws VisADException, RemoteException {
        this(ref, null, min, max, start, 1000, rt, n, false, false);
    }

    public VisADSlider(DataReference ref, float min, float max) throws VisADException, RemoteException {
        this(ref, null, min, max, Float.NaN, 1000, null, null, false, false);
    }

    private VisADSlider(DataReference ref, ScalarMap smap, float min, float max, float start, int sliderTicks, RealType rt, String n, boolean integralValues, boolean dynamicLabelWidth) throws VisADException, RemoteException {
        this.integralValues = integralValues;
        this.dynamicLabelWidth = dynamicLabelWidth;
        this.setAlignmentX(0.0f);
        this.setLayout(new BoxLayout(this, 0));
        this.sTicks = sliderTicks;
        this.slider = new JSlider(0, this.sTicks, this.sTicks / 2);
        Dimension d = this.slider.getMinimumSize();
        this.slider.setMinimumSize(new Dimension(150, d.height));
        d = this.slider.getPreferredSize();
        this.slider.setPreferredSize(new Dimension(150, d.height));
        d = this.slider.getMaximumSize();
        this.slider.setMaximumSize(new Dimension(150, d.height));
        this.autoScale = false;
        if (ref == null) {
            if (smap == null) {
                throw new VisADException("VisADSlider: must specify either a DataReference or a ScalarMap!");
            }
            if (smap.getDisplayScalar() != Display.SelectValue) {
                throw new VisADException("VisADSlider: ScalarMap must be to Display.SelectValue!");
            }
            if (!(smap.getScalar() instanceof RealType)) {
                throw new VisADException("VisADSlider: ScalarMap must be from a RealType!");
            }
            this.map = smap;
            this.control = (ValueControl)((Object)smap.getControl());
            if (this.control == null) {
                throw new VisADException("VisADSlider: ScalarMap must be addMap'ed to a Display");
            }
            this.sRef = null;
            this.sName = smap.getScalarName();
            start = (float)this.control.getValue();
            if (min == min && max == max && start == start) {
                int tmp;
                this.sMinimum = min;
                this.sMaximum = max;
                if (integralValues && (tmp = (int)(this.sMaximum - this.sMinimum)) != this.sTicks) {
                    this.sTicks = tmp;
                    this.slider.setMaximum(this.sTicks);
                }
                this.sCurrent = start;
                this.initLabel();
                smap.setRange(min, max);
                if (start < min || start > max) {
                    start = (min + max) / 2.0f;
                    this.control.setValue(start);
                }
            } else {
                this.autoScale = true;
                this.initLabel();
            }
            this.control.addControlListener(this);
            smap.addScalarMapListener(this);
        } else {
            this.map = null;
            this.control = null;
            if (ref == null) {
                throw new VisADException("VisADSlider: DataReference cannot be null!");
            }
            this.sRef = ref;
            Data data = ref.getData();
            if (data == null) {
                if (rt == null) {
                    throw new VisADException("VisADSlider: RealType cannot be null!");
                }
                if (n == null) {
                    throw new VisADException("VisADSlider: name cannot be null!");
                }
                this.realType = rt;
                if (min != min || max != max || start != start) {
                    throw new VisADException("VisADSlider: min, max, and start cannot be NaN!");
                }
                this.sMinimum = min;
                this.sMaximum = max;
                this.sCurrent = start < min || start > max ? (double)((min + max) / 2.0f) : (double)start;
                this.sRef.setData(new Real(this.realType, this.sCurrent));
            } else {
                if (!(data instanceof Real)) {
                    throw new VisADException("VisADSlider: DataReference must point to a Real!");
                }
                Real real = (Real)data;
                this.realType = (RealType)real.getType();
                this.sCurrent = (float)real.getValue();
                if (min != min || max != max) {
                    throw new VisADException("VisADSlider: minimum and maximum cannot be NaN!");
                }
                this.sMinimum = min;
                this.sMaximum = max;
                if (this.sCurrent < (double)min || this.sCurrent > (double)max) {
                    this.sCurrent = (min + max) / 2.0f;
                }
            }
            this.sName = n != null ? n : this.realType.getName();
            this.initLabel();
            CellImpl cell = new CellImpl(){

                @Override
                public void doAction() throws VisADException, RemoteException {
                    if (VisADSlider.this.sRef != null) {
                        try {
                            double val = ((Real)VisADSlider.this.sRef.getData()).getValue();
                            if (!Util.isApproximatelyEqual(VisADSlider.this.sCurrent, val)) {
                                VisADSlider.this.updateSlider(val);
                            }
                        }
                        catch (RemoteException re) {
                            if (CollabUtil.isDisconnectException(re)) {
                                VisADSlider.this.sRef = null;
                            }
                            throw re;
                        }
                    }
                }
            };
            if (ref instanceof RemoteDataReference) {
                RemoteCellImpl remoteCell = new RemoteCellImpl(cell);
                remoteCell.addReference(ref);
            } else {
                cell.addReference(ref);
            }
        }
        this.add(this.slider);
        this.add(this.label);
        this.slider.addChangeListener(this);
        this.updateSlider(start);
    }

    private void initLabel() {
        String str = this.sName + " = " + PlotText.shortString(this.sCurrent);
        if (this.dynamicLabelWidth) {
            this.label = new JLabel(str);
        } else {
            this.label = new JLabel(str + "         ");
            Dimension d = this.label.getMinimumSize();
            this.label.setMinimumSize(new Dimension(200, d.height));
            d = this.label.getPreferredSize();
            this.label.setPreferredSize(new Dimension(200, d.height));
            d = this.label.getMaximumSize();
            this.label.setMaximumSize(new Dimension(200, d.height));
        }
        this.label.setAlignmentX(0.5f);
    }

    public void hardcodeSizePercent(int percent) {
        Dimension d = this.getPreferredSize();
        int newWidth = d.width + d.width * (percent - 100) / 100;
        this.setPreferredSize(new Dimension(newWidth, d.height));
    }

    @Override
    public synchronized void stateChanged(ChangeEvent e) {
        block8: {
            try {
                double val = this.slider.getValue();
                double cur = (this.sMaximum - this.sMinimum) * (val / (double)this.sTicks) + this.sMinimum;
                if (this.integralValues) {
                    cur = Math.floor(cur + 0.5);
                }
                if (Util.isApproximatelyEqual(this.sCurrent, cur)) break block8;
                if (this.control != null) {
                    this.control.setValue(cur);
                    break block8;
                }
                if (this.sRef == null) break block8;
                try {
                    this.sRef.setData(new Real(this.realType, cur));
                }
                catch (RemoteException re) {
                    if (CollabUtil.isDisconnectException(re)) {
                        this.sRef = null;
                    }
                    throw re;
                }
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
        }
    }

    @Override
    public void mapChanged(ScalarMapEvent e) {
        int tmp;
        if (!this.autoScale) {
            return;
        }
        double[] range = this.map.getRange();
        this.sMinimum = (float)range[0];
        this.sMaximum = (float)range[1];
        if (this.integralValues && (tmp = (int)(this.sMaximum - this.sMinimum)) != this.sTicks) {
            this.sTicks = tmp;
            this.slider.setMaximum(this.sTicks);
        }
        this.sCurrent = (float)this.control.getValue();
        if (this.sCurrent < this.sMinimum || this.sCurrent > this.sMaximum) {
            this.sCurrent = (this.sMinimum + this.sMaximum) / 2.0;
        }
        this.updateSlider(this.sCurrent);
    }

    @Override
    public void controlChanged(ScalarMapControlEvent evt) {
        int id = evt.getId();
        if (id == 4 || id == 5) {
            this.control = null;
        }
        if (id == 5 || id == 3) {
            this.control = (ValueControl)((Object)evt.getScalarMap().getControl());
        }
    }

    @Override
    public void controlChanged(ControlEvent e) throws VisADException, RemoteException {
        double cur = this.control.getValue();
        if (!Util.isApproximatelyEqual(this.sCurrent, cur)) {
            this.updateSlider(this.control.getValue());
        }
    }

    private synchronized void updateSlider(double value) {
        if (this.integralValues) {
            value = Math.floor(value + 0.5);
        }
        int ival = (int)((double)this.sTicks * ((value - this.sMinimum) / (this.sMaximum - this.sMinimum)));
        if (Math.abs(this.slider.getValue() - ival) > 1) {
            this.slider.removeChangeListener(this);
            this.slider.setValue(ival);
            this.slider.addChangeListener(this);
        }
        this.sCurrent = value;
        this.label.setText(this.sName + " = " + PlotText.shortString(this.sCurrent));
        this.invalidate();
    }
}

