/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.awt.event.KeyEvent;
import java.rmi.RemoteException;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.KeyboardBehavior;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.VisADException;
import visad.java2d.DisplayRendererJ2D;

public class KeyboardBehaviorJ2D
implements KeyboardBehavior {
    private ProjectionControl proj;
    private DisplayRenderer displayRenderer;
    private MouseBehavior mouseBehavior;
    private double rotateAmount = 5.0;
    private double scaleAmount = 0.05;
    private double transAmount = 0.1;
    public static final int ROTATE_Z_POS = 7;
    public static final int ROTATE_Z_NEG = 8;
    private final int MAX_FUNCTIONS = 9;
    private int[] functionKeys = new int[9];
    private int[] functionMods = new int[9];

    public KeyboardBehaviorJ2D(DisplayRendererJ2D r) {
        this.displayRenderer = r;
        this.proj = this.displayRenderer.getDisplay().getProjectionControl();
        this.mouseBehavior = this.displayRenderer.getMouseBehavior();
        this.mapKeyToFunction(0, 38, 0);
        this.mapKeyToFunction(1, 40, 0);
        this.mapKeyToFunction(2, 37, 0);
        this.mapKeyToFunction(3, 39, 0);
        this.mapKeyToFunction(4, 38, 1);
        this.mapKeyToFunction(5, 40, 1);
        this.mapKeyToFunction(6, 82, 2);
        this.mapKeyToFunction(7, 37, 1);
        this.mapKeyToFunction(8, 39, 1);
    }

    @Override
    public void mapKeyToFunction(int function, int keycode, int modifiers) {
        if (function < 0 || function >= 9) {
            return;
        }
        this.functionKeys[function] = keycode;
        this.functionMods[function] = modifiers;
    }

    @Override
    public void processKeyEvent(KeyEvent event) {
        int id = event.getID();
        if (id == 401) {
            int modifiers = event.getModifiers();
            int keyCode = event.getKeyCode();
            for (int i = 0; i < 9; ++i) {
                if (this.functionKeys[i] != keyCode || modifiers != this.functionMods[i]) continue;
                this.execFunction(i);
                break;
            }
        }
        int d_id = -1;
        if (id == 401) {
            d_id = 16;
        } else if (id == 402) {
            d_id = 17;
        }
        if (d_id != -1) {
            try {
                DisplayImpl display = this.displayRenderer.getDisplay();
                DisplayEvent e = new DisplayEvent((Display)display, d_id, event);
                display.notifyListeners(e);
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void execFunction(int function) {
        double transx = 0.0;
        double transy = 0.0;
        double scale = 1.0;
        double anglez = 0.0;
        double[] t1 = null;
        double[] tstart = this.proj.getMatrix();
        switch (function) {
            case 0: {
                t1 = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, transx, transy -= this.transAmount, 0.0);
                break;
            }
            case 1: {
                t1 = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, transx, transy += this.transAmount, 0.0);
                break;
            }
            case 2: {
                t1 = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, transx -= this.transAmount, transy, 0.0);
                break;
            }
            case 3: {
                t1 = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, transx += this.transAmount, transy, 0.0);
                break;
            }
            case 6: {
                tstart = this.proj.getSavedProjectionMatrix();
                t1 = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 4: {
                t1 = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, scale += this.scaleAmount, 0.0, 0.0, 0.0);
                break;
            }
            case 5: {
                t1 = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, scale -= this.scaleAmount, 0.0, 0.0, 0.0);
                break;
            }
            case 8: {
                t1 = this.mouseBehavior.make_matrix(0.0, 0.0, anglez -= this.rotateAmount, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 7: {
                t1 = this.mouseBehavior.make_matrix(0.0, 0.0, anglez += this.rotateAmount, 1.0, 0.0, 0.0, 0.0);
                break;
            }
        }
        if (t1 != null) {
            t1 = this.mouseBehavior.multiply_matrix(t1, tstart);
            try {
                this.proj.setMatrix(t1);
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

