/*
 * Decompiled with CFR 0.152.
 */
package visad.data.in;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import visad.data.in.ValueUnpacker;

public final class ScaleUnpacker
extends ValueUnpacker {
    private final float floatScale;
    private final double doubleScale;
    private static final WeakHashMap map = new WeakHashMap();

    private ScaleUnpacker(double scale) {
        this.floatScale = (float)scale;
        this.doubleScale = scale;
    }

    public static synchronized ScaleUnpacker scaleUnpacker(double scale) {
        ScaleUnpacker unpacker = new ScaleUnpacker(scale);
        WeakReference ref = (WeakReference)map.get(unpacker);
        if (ref == null) {
            map.put(unpacker, new WeakReference<ScaleUnpacker>(unpacker));
        } else {
            ScaleUnpacker oldUnpacker = (ScaleUnpacker)ref.get();
            if (oldUnpacker == null) {
                map.put(unpacker, new WeakReference<ScaleUnpacker>(unpacker));
            } else {
                unpacker = oldUnpacker;
            }
        }
        return unpacker;
    }

    @Override
    public double getIncrement() {
        return Math.abs(this.doubleScale);
    }

    @Override
    public float process(float value) {
        return this.floatScale * value;
    }

    @Override
    public double process(double value) {
        return this.doubleScale * value;
    }

    @Override
    public float[] process(float[] values) {
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] * this.floatScale;
        }
        return values;
    }

    @Override
    public double[] process(double[] values) {
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] * this.doubleScale;
        }
        return values;
    }

    public boolean equals(Object obj) {
        ScaleUnpacker that;
        boolean equals = !this.getClass().isInstance(obj) ? false : this == (that = (ScaleUnpacker)obj) || this.doubleScale == that.doubleScale;
        return equals;
    }

    public int hashCode() {
        return new Double(this.doubleScale).hashCode();
    }
}

