/*
 * Decompiled with CFR 0.152.
 */
package visad.browser;

import java.awt.Checkbox;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import visad.browser.Convert;
import visad.browser.Widget;
import visad.browser.WidgetEvent;

public class GMCWidget
extends Widget
implements ActionListener,
ItemListener {
    Checkbox scale;
    Checkbox point;
    Checkbox texture;
    TextField lineWidth;
    TextField pointSize;
    boolean gmcScaleEnable;
    boolean gmcPointMode;
    boolean gmcTextureEnable;
    float gmcLineWidth;
    float gmcPointSize;
    int gmcTransparencyMode;
    int gmcProjectionPolicy;
    int gmcPolygonMode;
    boolean gmcMissingTransparent;
    int gmcCurvedSize;

    public GMCWidget() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        this.scale = new Checkbox("Enable scale", this.gmcScaleEnable);
        this.point = new Checkbox("Point mode", this.gmcPointMode);
        this.texture = new Checkbox("Texture mapping", this.gmcTextureEnable);
        this.lineWidth = new TextField(Convert.shortString(this.gmcLineWidth));
        this.pointSize = new TextField(Convert.shortString(this.gmcPointSize));
        this.scale.addItemListener(this);
        this.point.addItemListener(this);
        this.texture.addItemListener(this);
        this.lineWidth.addActionListener(this);
        this.pointSize.addActionListener(this);
        this.addComponent(this.scale, gridbag, 0, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.point, gridbag, 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.texture, gridbag, 2, 0, 2, 1, 0.0, 0.0);
        this.addComponent(new Label("Line width:"), gridbag, 0, 1, 1, 1, 0.0, 0.0);
        this.addComponent(this.lineWidth, gridbag, 1, 1, 1, 1, 1.0, 0.0);
        this.addComponent(new Label("Point size:"), gridbag, 2, 1, 1, 1, 0.0, 0.0);
        this.addComponent(this.pointSize, gridbag, 3, 1, 1, 1, 1.0, 0.0);
    }

    public float getLineWidth() {
        return this.gmcLineWidth;
    }

    public void setLineWidth(float lw) {
        this.gmcLineWidth = lw;
        this.lineWidth.setText(Convert.shortString(lw));
    }

    public float getPointSize() {
        return this.gmcPointSize;
    }

    public void setPointSize(float ps) {
        this.gmcPointSize = ps;
        this.pointSize.setText(Convert.shortString(ps));
    }

    public boolean getPointMode() {
        return this.gmcPointMode;
    }

    public void setPointMode(boolean pm) {
        this.gmcPointMode = pm;
        this.point.setState(pm);
    }

    public boolean getTextureEnable() {
        return this.gmcTextureEnable;
    }

    public void setTextureEnable(boolean tm) {
        this.gmcTextureEnable = tm;
        this.texture.setState(tm);
    }

    public boolean getScaleEnable() {
        return this.gmcScaleEnable;
    }

    public void setScaleEnable(boolean se) {
        this.gmcScaleEnable = se;
        this.scale.setState(se);
    }

    public int getTransparencyMode() {
        return this.gmcTransparencyMode;
    }

    public void setTransparencyMode(int tm) {
        this.gmcTransparencyMode = tm;
    }

    public int getProjectionPolicy() {
        return this.gmcProjectionPolicy;
    }

    public void setProjectionPolicy(int pp) {
        this.gmcProjectionPolicy = pp;
    }

    public int getPolygonMode() {
        return this.gmcPolygonMode;
    }

    public void setPolygonMode(int pm) {
        this.gmcPolygonMode = pm;
    }

    public boolean getMissingTransparent() {
        return this.gmcMissingTransparent;
    }

    public void setMissingTransparent(boolean mt) {
        this.gmcMissingTransparent = mt;
    }

    public int getCurvedSize() {
        return this.gmcCurvedSize;
    }

    public void setCurvedSize(int cs) {
        this.gmcCurvedSize = cs;
    }

    @Override
    public String getSaveString() {
        return "" + this.gmcLineWidth + " " + this.gmcPointSize + " " + this.gmcPointMode + " " + this.gmcTextureEnable + " " + this.gmcScaleEnable + " " + this.gmcTransparencyMode + " " + this.gmcProjectionPolicy + " " + this.gmcPolygonMode + " " + this.gmcMissingTransparent + " " + this.gmcCurvedSize;
    }

    @Override
    public void setSaveString(String save) {
        if (save == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(save);
        int numTokens = st.countTokens();
        if (numTokens < 10) {
            System.out.println("Invalid save string");
            return;
        }
        float lw = Convert.getFloat(st.nextToken());
        float ps = Convert.getFloat(st.nextToken());
        boolean pm = Convert.getBoolean(st.nextToken());
        boolean te = Convert.getBoolean(st.nextToken());
        boolean se = Convert.getBoolean(st.nextToken());
        int tm = Convert.getInt(st.nextToken());
        int pp = Convert.getInt(st.nextToken());
        int pm2 = Convert.getInt(st.nextToken());
        boolean mt = Convert.getBoolean(st.nextToken());
        int cs = Convert.getInt(st.nextToken());
        this.setLineWidth(lw);
        this.setPointSize(ps);
        this.setPointMode(pm);
        this.setTextureEnable(te);
        this.setScaleEnable(se);
        this.setTransparencyMode(tm);
        this.setProjectionPolicy(pp);
        this.setPolygonMode(pm2);
        this.setMissingTransparent(mt);
        this.setCurvedSize(cs);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        Object source = e.getSource();
        if (source == this.lineWidth) {
            float lw = Float.NaN;
            try {
                lw = Float.valueOf(this.lineWidth.getText()).floatValue();
            }
            catch (NumberFormatException exc) {
                this.lineWidth.setText(Convert.shortString(this.gmcLineWidth));
            }
            if (lw == lw) {
                this.setLineWidth(lw);
                this.scale.requestFocus();
                this.notifyListeners(new WidgetEvent(this));
            }
        } else if (source == this.pointSize) {
            float ps = Float.NaN;
            try {
                ps = Float.valueOf(this.pointSize.getText()).floatValue();
            }
            catch (NumberFormatException exc) {
                this.pointSize.setText(Convert.shortString(this.gmcPointSize));
            }
            if (ps == ps) {
                this.setPointSize(ps);
                this.scale.requestFocus();
                this.notifyListeners(new WidgetEvent(this));
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean on;
        ItemSelectable source = e.getItemSelectable();
        boolean bl = on = e.getStateChange() == 1;
        if (source == this.scale) {
            this.setScaleEnable(on);
        } else if (source == this.point) {
            this.setPointMode(on);
        } else if (source == this.texture) {
            this.setTextureEnable(on);
        }
        this.notifyListeners(new WidgetEvent(this));
    }

    public static void main(String[] args) {
        new GMCWidget().testWidget();
    }
}

