/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.Data;
import visad.DataDisplayLink;
import visad.MathType;
import visad.RealType;
import visad.ScalarType;
import visad.ShadowType;
import visad.Text;
import visad.TypeException;
import visad.UnimplementedException;
import visad.VisADException;

public class TextType
extends ScalarType {
    public static final TextType Generic = new TextType("GENERIC_TEXT", true);

    public TextType(String name) throws VisADException {
        super(name);
    }

    TextType(String name, boolean b) {
        super(name, b);
    }

    @Override
    public boolean equals(Object type) {
        if (!(type instanceof TextType)) {
            return false;
        }
        return this.getName().equals(((TextType)type).getName());
    }

    @Override
    public boolean equalsExceptName(MathType type) {
        return type instanceof TextType;
    }

    @Override
    public boolean equalsExceptNameButUnits(MathType type) throws VisADException {
        throw new UnimplementedException("TextType: equalsExceptNameButUnits");
    }

    @Override
    public MathType cloneDerivative(RealType d_partial) throws VisADException {
        throw new UnimplementedException("TexType: cloneDerivative");
    }

    @Override
    public MathType binary(MathType type, int op, Vector names) throws VisADException {
        if (type == null) {
            throw new TypeException("TextType.binary: type may not be null");
        }
        if (type instanceof TextType) {
            return this;
        }
        throw new TypeException("TextType.binary: types don't match");
    }

    @Override
    public MathType unary(int op, Vector names) throws VisADException {
        throw new UnimplementedException("TextType: unary");
    }

    public static synchronized TextType getTextType(String name) {
        TextType result = TextType.getTextTypeByName(name);
        if (result == null) {
            try {
                result = new TextType(name);
            }
            catch (VisADException e) {
                result = null;
            }
        }
        return result;
    }

    public static synchronized TextType getTextTypeByName(String name) {
        ScalarType text = ScalarType.getScalarTypeByName(name);
        if (!(text instanceof TextType)) {
            return null;
        }
        return (TextType)text;
    }

    @Override
    public String prettyString(int indent) {
        return this.getName() + "(Text)";
    }

    @Override
    public Data missingData() throws VisADException {
        return new Text(this);
    }

    @Override
    public ShadowType buildShadowType(DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return link.getRenderer().makeShadowTextType(this, link, parent);
    }
}

