/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import visad.BadMappingException;
import visad.ContourControl;
import visad.Control;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayInterruptException;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.Field;
import visad.FlatField;
import visad.Function;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.PlotText;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.SetException;
import visad.ShadowFunctionType;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowScalarType;
import visad.ShadowSetType;
import visad.ShadowTextType;
import visad.ShadowTupleType;
import visad.ShadowType;
import visad.TextControl;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADPointArray;
import visad.VisADQuadArray;
import visad.VisADTriangleStripArray;
import visad.util.Trace;

public abstract class ShadowFunctionOrSetType
extends ShadowType {
    ShadowRealTupleType Domain;
    ShadowType Range;
    ShadowRealType[] RangeComponents;
    ShadowRealType[] DomainComponents;
    ShadowRealType[] DomainReferenceComponents;
    boolean Flat;
    int[] inherited_values;

    public ShadowFunctionOrSetType(MathType t, DataDisplayLink link, ShadowType parent, ShadowRealTupleType domain, ShadowType range) throws VisADException, RemoteException {
        super(t, link, parent);
        this.Domain = domain;
        this.Range = range;
        if (this instanceof ShadowFunctionType) {
            this.Flat = this.Range instanceof ShadowRealType || this.Range instanceof ShadowTextType || this.Range instanceof ShadowTupleType && ((ShadowTupleType)this.Range).isFlat();
            this.MultipleSpatialDisplayScalar = this.Domain.getMultipleSpatialDisplayScalar() || this.Range.getMultipleSpatialDisplayScalar();
            this.MultipleDisplayScalar = this.Domain.getMultipleDisplayScalar() || this.Range.getMultipleDisplayScalar();
            this.MappedDisplayScalar = this.Domain.getMappedDisplayScalar() || this.Range.getMappedDisplayScalar();
            this.RangeComponents = this.getComponents(this.Range, true);
        } else if (this instanceof ShadowSetType) {
            this.Flat = true;
            this.MultipleDisplayScalar = this.Domain.getMultipleDisplayScalar();
            this.MappedDisplayScalar = this.Domain.getMappedDisplayScalar();
            this.RangeComponents = null;
        } else {
            throw new DisplayException("ShadowFunctionOrSetType: must be ShadowFunctionType or ShadowSetType");
        }
        this.DomainComponents = this.getComponents(this.Domain, false);
        this.DomainReferenceComponents = this.getComponents(this.Domain.getReference(), false);
    }

    public boolean getFlat() {
        return this.Flat;
    }

    public ShadowRealType[] getRangeComponents() {
        return this.RangeComponents;
    }

    public ShadowRealType[] getDomainComponents() {
        return this.DomainComponents;
    }

    public ShadowRealType[] getDomainReferenceComponents() {
        return this.DomainReferenceComponents;
    }

    int[] getRangeDisplayIndices() throws VisADException {
        if (!(this instanceof ShadowFunctionType)) {
            throw new DisplayException("ShadowFunctionOrSetType.getRangeDisplayIndices: must be ShadowFunctionType");
        }
        int n = this.RangeComponents.length;
        int[] indices = new int[n];
        for (int i = 0; i < n; ++i) {
            indices[i] = this.RangeComponents[i].getIndex();
        }
        return indices;
    }

    public int[] getInheritedValues() {
        return this.inherited_values;
    }

    @Override
    public int checkIndices(int[] indices, int[] display_indices, int[] value_indices, boolean[] isTransform, int levelOfDifficulty) throws VisADException, RemoteException {
        int[] local_indices = this.Domain.sumIndices(indices);
        int[] local_display_indices = this.Domain.sumDisplayIndices(display_indices);
        int[] local_value_indices = this.Domain.sumValueIndices(value_indices);
        if (this.Domain.testTransform()) {
            this.Domain.markTransform(isTransform);
        }
        if (this instanceof ShadowFunctionType) {
            this.Range.markTransform(isTransform);
        }
        this.inherited_values = ShadowFunctionOrSetType.copyIndices(value_indices);
        if (levelOfDifficulty == 6 && this.checkAny(local_display_indices)) {
            levelOfDifficulty = 2;
        }
        int avCount = this.checkAnimationOrValue(this.Domain.getDisplayIndices());
        if (this.Domain.getDimension() != 1) {
            if (avCount > 0) {
                throw new BadMappingException("Animation and SelectValue may only occur in 1-D Function domain: ShadowFunctionOrSetType.checkIndices");
            }
            if (avCount > 1) {
                throw new BadMappingException("only one Animation and SelectValue may occur Set domain: ShadowFunctionOrSetType.checkIndices");
            }
        }
        if (this.Flat || this instanceof ShadowSetType) {
            if (this instanceof ShadowFunctionType) {
                if (this.Range instanceof ShadowTupleType) {
                    local_indices = ((ShadowTupleType)this.Range).sumIndices(local_indices);
                    local_display_indices = ((ShadowTupleType)this.Range).sumDisplayIndices(local_display_indices);
                    local_value_indices = ((ShadowTupleType)this.Range).sumValueIndices(local_value_indices);
                } else if (this.Range instanceof ShadowScalarType) {
                    ((ShadowScalarType)this.Range).incrementIndices(local_indices);
                    local_display_indices = ShadowFunctionOrSetType.addIndices(local_display_indices, ((ShadowScalarType)this.Range).getDisplayIndices());
                    local_value_indices = ShadowFunctionOrSetType.addIndices(local_value_indices, ((ShadowScalarType)this.Range).getValueIndices());
                }
                if (this.checkAnimationOrValue(this.Range.getDisplayIndices()) > 0) {
                    throw new BadMappingException("Animation and SelectValue may not occur in Function range: ShadowFunctionOrSetType.checkIndices");
                }
            }
            this.anyContour = this.checkContour(local_display_indices);
            this.anyFlow = this.checkFlow(local_display_indices);
            this.anyShape = this.checkShape(local_display_indices);
            this.anyText = this.checkText(local_display_indices);
            this.LevelOfDifficulty = this.testIndices(local_indices, local_display_indices, levelOfDifficulty);
            this.Dtype = !this.Domain.getMappedDisplayScalar() ? 0 : (this.Domain.getAllSpatial() && this.checkR4(this.Domain.getDisplayIndices()) ? 1 : (this.checkR1D3(this.Domain.getDisplayIndices()) ? 3 : (this.checkR2D2(this.Domain.getDisplayIndices()) ? 2 : (this.checkAnimationOrValue(this.Domain.getDisplayIndices()) > 0 ? 4 : 5))));
            this.Rtype = this instanceof ShadowFunctionType ? (!this.Range.getMappedDisplayScalar() ? 0 : (this.checkR1D3(this.Range.getDisplayIndices()) ? 1 : (this.checkR2D2(this.Range.getDisplayIndices()) ? 2 : (this.checkR3(this.Range.getDisplayIndices()) ? 3 : (this.checkR4(this.Range.getDisplayIndices()) ? 4 : 5))))) : 0;
            if (this.LevelOfDifficulty == 2) {
                this.LevelOfDifficulty = this.Dtype != 5 && this.Rtype != 5 ? (this.Dtype == 4 ? 4 : 3) : 1;
            }
            this.adjustProjectionSeam = this.checkAdjustProjectionSeam();
            if (this instanceof ShadowFunctionType) {
                float[] default_values = this.getLink().getDefaultValues();
                boolean textureEnabled = default_values[this.display.getDisplayScalarIndex(Display.TextureEnable)] > 0.5f;
                boolean pointMode = default_values[this.display.getDisplayScalarIndex(Display.PointMode)] > 0.5f;
                this.isTextureMap = !this.getMultipleDisplayScalar() && this.getLevelOfDifficulty() == 3 && ((FunctionType)this.getType()).getReal() && this.Domain.getDimension() == 2 && this.Domain.getAllSpatial() && !this.Domain.getSpatialReference() && Display.DisplaySpatialCartesianTuple.equals(this.Domain.getDisplaySpatialTuple()) && this.checkColorAlphaRange(this.Range.getDisplayIndices()) && this.checkAny(this.Range.getDisplayIndices()) && textureEnabled && !pointMode;
                this.curvedTexture = this.getLevelOfDifficulty() == 3 && this.Domain.getAllSpatial() && this.checkSpatialOffsetColorAlphaRange(this.Domain.getDisplayIndices()) && this.checkSpatialOffsetColorAlphaRange(this.Range.getDisplayIndices()) && this.checkAny(this.Range.getDisplayIndices()) && !pointMode;
                this.isTexture3D = this.getLevelOfDifficulty() == 3 && ((FunctionType)this.getType()).getReal() && this.Domain.getDimension() == 3 && this.Domain.getAllSpatial() && this.checkSpatialRange(this.Domain.getDisplayIndices()) && !this.Domain.getSpatialReference() && Display.DisplaySpatialCartesianTuple.equals(this.Domain.getDisplaySpatialTuple()) && this.checkColorAlphaRange(this.Range.getDisplayIndices()) && this.checkAny(this.Range.getDisplayIndices()) && textureEnabled && !pointMode;
                this.isLinearContour3D = this.getLevelOfDifficulty() == 3 && ((FunctionType)this.getType()).getReal() && this.Domain.getDimension() == 3 && this.Domain.getAllSpatial() && !this.Domain.getMultipleDisplayScalar() && !this.Domain.getSpatialReference() && Display.DisplaySpatialCartesianTuple.equals(this.Domain.getDisplaySpatialTuple()) && this.checkContourColorAlphaRange(this.Range.getDisplayIndices()) && this.checkContour(this.Range.getDisplayIndices());
            }
        } else {
            if (levelOfDifficulty == 2 && !this.checkNested(this.Domain.getDisplayIndices())) {
                levelOfDifficulty = 1;
            }
            this.LevelOfDifficulty = this.Range.checkIndices(local_indices, local_display_indices, local_value_indices, isTransform, levelOfDifficulty);
        }
        return this.LevelOfDifficulty;
    }

    public ShadowRealTupleType getDomain() {
        return this.Domain;
    }

    public ShadowType getRange() {
        return this.Range;
    }

    @Override
    void markTransform(boolean[] isTransform) {
        if (this.Range != null) {
            this.Range.markTransform(isTransform);
        }
    }

    public boolean doTransform(Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer, ShadowType shadow_api) throws VisADException, RemoteException {
        int domain_dimension;
        int domain_length;
        Trace.msg("ShadowFunctionOrSetType:" + data.getType());
        if (data.isMissing()) {
            return false;
        }
        if (this.LevelOfDifficulty == 6) {
            return false;
        }
        DataDisplayLink link = renderer.getLink();
        if (link != null) {
            boolean time_flag = false;
            if (link.time_flag) {
                time_flag = true;
            } else if (500L < System.currentTimeMillis() - link.start_time) {
                link.time_flag = true;
                time_flag = true;
            }
            if (time_flag) {
                if (link.peekTicks()) {
                    throw new DisplayInterruptException("please wait . . .");
                }
                Enumeration maps = link.getSelectedMapVector().elements();
                while (maps.hasMoreElements()) {
                    ScalarMap map = (ScalarMap)maps.nextElement();
                    if (!map.peekTicks(renderer, link)) continue;
                    throw new DisplayInterruptException("please wait . . .");
                }
            }
        }
        boolean anyContour = this.getAnyContour();
        boolean anyFlow = this.getAnyFlow();
        boolean anyShape = this.getAnyShape();
        boolean anyText = this.getAnyText();
        boolean indexed = shadow_api.wantIndexed();
        int valueArrayLength = this.display.getValueArrayLength();
        int[] valueToScalar = this.display.getValueToScalar();
        int[] valueToMap = this.display.getValueToMap();
        Vector MapVector = this.display.getMapVector();
        float[][] display_values = new float[valueArrayLength][];
        for (int i = 0; i < valueArrayLength; ++i) {
            if (this.inherited_values[i] <= 0) continue;
            display_values[i] = new float[1];
            display_values[i][0] = value_array[i];
        }
        if (this.getIsTerminal() && anyContour && !anyFlow && !anyShape && !anyText) {
            boolean any_enabled = false;
            for (int i = 0; i < valueArrayLength; ++i) {
                int displayScalarIndex = valueToScalar[i];
                DisplayRealType real = this.display.getDisplayScalar(displayScalarIndex);
                if (!real.equals(Display.IsoContour) || this.inherited_values[i] != 0) continue;
                ContourControl control = (ContourControl)((ScalarMap)MapVector.elementAt(valueToMap[i])).getControl();
                boolean[] bvalues = new boolean[2];
                float[] fvalues = new float[5];
                control.getMainContours(bvalues, fvalues);
                if (!bvalues[0]) continue;
                any_enabled = true;
            }
            if (!any_enabled) {
                return false;
            }
        }
        Set domain_set = null;
        Unit[] dataUnits = null;
        CoordinateSystem dataCoordinateSystem = null;
        if (this instanceof ShadowFunctionType) {
            if (!(data instanceof Field)) {
                throw new UnimplementedException("data must be Field: ShadowFunctionOrSetType.doTransform: ");
            }
            domain_set = ((Field)data).getDomainSet();
            dataUnits = ((Function)data).getDomainUnits();
            dataCoordinateSystem = ((Function)data).getDomainCoordinateSystem();
        } else if (this instanceof ShadowSetType) {
            domain_set = (Set)data;
            dataUnits = ((Set)data).getSetUnits();
            dataCoordinateSystem = ((Set)data).getCoordinateSystem();
        } else {
            throw new DisplayException("must be ShadowFunctionType or ShadowSetType: ShadowFunctionOrSetType.doTransform");
        }
        float[][] domain_values = null;
        double[][] domain_doubles = null;
        Unit[] domain_units = ((RealTupleType)this.Domain.getType()).getDefaultUnits();
        try {
            domain_length = domain_set.getLength();
            domain_dimension = domain_set.getDimension();
        }
        catch (SetException e) {
            return false;
        }
        ShadowRealType[] DomainComponents = this.getDomainComponents();
        int alpha_index = this.display.getDisplayScalarIndex(Display.Alpha);
        String[] text_values = null;
        TextControl text_control = shadow_api.getParentTextControl();
        String inherited_text = shadow_api.getParentText();
        if (inherited_text != null) {
            text_values = new String[domain_length];
            for (int i = 0; i < domain_length; ++i) {
                text_values[i] = inherited_text;
            }
        }
        boolean isTextureMap = this.getIsTextureMap() && renderer.isLegalTextureMap() && (domain_set instanceof Linear2DSet || domain_set instanceof LinearNDSet && domain_set.getDimension() == 2);
        int curved_size = (int)default_values[this.display.getDisplayScalarIndex(Display.CurvedSize)];
        float textureEnable = default_values[this.display.getDisplayScalarIndex(Display.TextureEnable)];
        boolean texture = textureEnable > 0.5f;
        boolean curvedTexture = this.getCurvedTexture() && !isTextureMap && texture && curved_size > 0 && this.getIsTerminal() && shadow_api.allowCurvedTexture() && renderer.isLegalTextureMap() && domain_set.getManifoldDimension() == 2 && domain_set instanceof GriddedSet;
        boolean domainOnlySpatial = this.Domain.getAllSpatial() && !this.Domain.getMultipleDisplayScalar();
        boolean isTexture3D = this.getIsTexture3D() && renderer.isLegalTextureMap() && (domain_set instanceof Linear3DSet || domain_set instanceof LinearNDSet && domain_set.getDimension() == 3);
        int t3dm = (int)default_values[this.display.getDisplayScalarIndex(Display.Texture3DMode)];
        boolean range3D = isTexture3D && this.anyRange(this.Domain.getDisplayIndices());
        boolean isLinearContour3D = this.getIsLinearContour3D() && domain_set instanceof Linear3DSet && shadow_api.allowLinearContour();
        float[] coordinates = null;
        Object texCoords = null;
        Object normals = null;
        byte[] colors = null;
        int data_width = 0;
        int data_height = 0;
        int data_depth = 0;
        int texture_width = 1;
        int texture_height = 1;
        int texture_depth = 1;
        float[] coordinatesX = null;
        float[] texCoordsX = null;
        float[] normalsX = null;
        byte[] colorsX = null;
        float[] coordinatesY = null;
        float[] texCoordsY = null;
        float[] normalsY = null;
        byte[] colorsY = null;
        float[] coordinatesZ = null;
        float[] texCoordsZ = null;
        float[] normalsZ = null;
        byte[] colorsZ = null;
        int[] volume_tuple_index = null;
        if (!isTextureMap && isTexture3D) {
            int i;
            int i2;
            Trace.call1("ShadowFunctionOrSetType:isTexture3D");
            Linear1DSet X = null;
            Linear1DSet Y = null;
            Linear1DSet Z = null;
            if (domain_set instanceof Linear3DSet) {
                X = ((Linear3DSet)domain_set).getX();
                Y = ((Linear3DSet)domain_set).getY();
                Z = ((Linear3DSet)domain_set).getZ();
            } else {
                X = ((LinearNDSet)domain_set).getLinear1DComponent(0);
                Y = ((LinearNDSet)domain_set).getLinear1DComponent(1);
                Z = ((LinearNDSet)domain_set).getLinear1DComponent(2);
            }
            float[][] limits = new float[3][2];
            limits[0][0] = (float)X.getFirst();
            limits[0][1] = (float)X.getLast();
            limits[1][0] = (float)Y.getFirst();
            limits[1][1] = (float)Y.getLast();
            limits[2][0] = (float)Z.getFirst();
            limits[2][1] = (float)Z.getLast();
            limits = Unit.convertTuple(limits, dataUnits, domain_units, false);
            data_width = X.getLength();
            data_height = Y.getLength();
            data_depth = Z.getLength();
            texture_width = shadow_api.textureWidth(data_width);
            texture_height = shadow_api.textureHeight(data_height);
            texture_depth = shadow_api.textureDepth(data_depth);
            int[] tuple_index = new int[3];
            if (DomainComponents.length != 3) {
                throw new DisplayException("texture3D domain dimension != 3:ShadowFunctionOrSetType.doTransform");
            }
            block6: for (i2 = 0; i2 < DomainComponents.length; ++i2) {
                Enumeration maps = DomainComponents[i2].getSelectedMapVector().elements();
                while (maps.hasMoreElements()) {
                    ScalarMap map = (ScalarMap)maps.nextElement();
                    DisplayRealType real = map.getDisplayScalar();
                    DisplayTupleType tuple = real.getTuple();
                    if (!Display.DisplaySpatialCartesianTuple.equals(tuple)) continue;
                    limits[i2] = map.scaleValues(limits[i2]);
                    tuple_index[i2] = real.getTupleIndex();
                    continue block6;
                }
            }
            volume_tuple_index = tuple_index;
            coordinatesX = new float[12 * data_width];
            coordinatesY = new float[12 * data_height];
            coordinatesZ = new float[12 * data_depth];
            for (i2 = 0; i2 < data_depth; ++i2) {
                int i12 = i2 * 12;
                float depth = limits[2][0] + (limits[2][1] - limits[2][0]) * (float)i2 / ((float)data_depth - 1.0f);
                coordinatesZ[i12 + tuple_index[0]] = limits[0][0];
                coordinatesZ[i12 + tuple_index[1]] = limits[1][0];
                coordinatesZ[i12 + tuple_index[2]] = depth;
                coordinatesZ[i12 + 3 + tuple_index[0]] = limits[0][1];
                coordinatesZ[i12 + 3 + tuple_index[1]] = limits[1][0];
                coordinatesZ[i12 + 3 + tuple_index[2]] = depth;
                coordinatesZ[i12 + 6 + tuple_index[0]] = limits[0][1];
                coordinatesZ[i12 + 6 + tuple_index[1]] = limits[1][1];
                coordinatesZ[i12 + 6 + tuple_index[2]] = depth;
                coordinatesZ[i12 + 9 + tuple_index[0]] = limits[0][0];
                coordinatesZ[i12 + 9 + tuple_index[1]] = limits[1][1];
                coordinatesZ[i12 + 9 + tuple_index[2]] = depth;
            }
            for (i2 = 0; i2 < data_height; ++i2) {
                int i12 = i2 * 12;
                float height = limits[1][0] + (limits[1][1] - limits[1][0]) * (float)i2 / ((float)data_height - 1.0f);
                coordinatesY[i12 + tuple_index[0]] = limits[0][0];
                coordinatesY[i12 + tuple_index[1]] = height;
                coordinatesY[i12 + tuple_index[2]] = limits[2][0];
                coordinatesY[i12 + 3 + tuple_index[0]] = limits[0][1];
                coordinatesY[i12 + 3 + tuple_index[1]] = height;
                coordinatesY[i12 + 3 + tuple_index[2]] = limits[2][0];
                coordinatesY[i12 + 6 + tuple_index[0]] = limits[0][1];
                coordinatesY[i12 + 6 + tuple_index[1]] = height;
                coordinatesY[i12 + 6 + tuple_index[2]] = limits[2][1];
                coordinatesY[i12 + 9 + tuple_index[0]] = limits[0][0];
                coordinatesY[i12 + 9 + tuple_index[1]] = height;
                coordinatesY[i12 + 9 + tuple_index[2]] = limits[2][1];
            }
            for (i2 = 0; i2 < data_width; ++i2) {
                float width;
                int i12 = i2 * 12;
                coordinatesX[i12 + tuple_index[0]] = width = limits[0][0] + (limits[0][1] - limits[0][0]) * (float)i2 / ((float)data_width - 1.0f);
                coordinatesX[i12 + tuple_index[1]] = limits[1][0];
                coordinatesX[i12 + tuple_index[2]] = limits[2][0];
                coordinatesX[i12 + 3 + tuple_index[0]] = width;
                coordinatesX[i12 + 3 + tuple_index[1]] = limits[1][1];
                coordinatesX[i12 + 3 + tuple_index[2]] = limits[2][0];
                coordinatesX[i12 + 6 + tuple_index[0]] = width;
                coordinatesX[i12 + 6 + tuple_index[1]] = limits[1][1];
                coordinatesX[i12 + 6 + tuple_index[2]] = limits[2][1];
                coordinatesX[i12 + 9 + tuple_index[0]] = width;
                coordinatesX[i12 + 9 + tuple_index[1]] = limits[1][0];
                coordinatesX[i12 + 9 + tuple_index[2]] = limits[2][1];
            }
            float ratiow = (float)data_width / (float)texture_width;
            float ratioh = (float)data_height / (float)texture_height;
            float ratiod = (float)data_depth / (float)texture_depth;
            if (t3dm == 0) {
                texCoordsX = shadow_api.setTexStackCoords(data_width, 0, ratiow, ratioh, ratiod);
                texCoordsY = shadow_api.setTexStackCoords(data_height, 1, ratiow, ratioh, ratiod);
                texCoordsZ = shadow_api.setTexStackCoords(data_depth, 2, ratiow, ratioh, ratiod);
            } else {
                texCoordsX = shadow_api.setTex3DCoords(data_width, 0, ratiow, ratioh, ratiod);
                texCoordsY = shadow_api.setTex3DCoords(data_height, 1, ratiow, ratioh, ratiod);
                texCoordsZ = shadow_api.setTex3DCoords(data_depth, 2, ratiow, ratioh, ratiod);
            }
            normalsX = new float[12 * data_width];
            normalsY = new float[12 * data_height];
            normalsZ = new float[12 * data_depth];
            float n0 = (coordinatesX[5] - coordinatesX[2]) * (coordinatesX[7] - coordinatesX[1]) - (coordinatesX[4] - coordinatesX[1]) * (coordinatesX[8] - coordinatesX[2]);
            float n1 = (coordinatesX[3] - coordinatesX[0]) * (coordinatesX[8] - coordinatesX[2]) - (coordinatesX[5] - coordinatesX[2]) * (coordinatesX[6] - coordinatesX[0]);
            float n2 = (coordinatesX[4] - coordinatesX[1]) * (coordinatesX[6] - coordinatesX[0]) - (coordinatesX[3] - coordinatesX[0]) * (coordinatesX[7] - coordinatesX[1]);
            float nlen = (float)Math.sqrt(n0 * n0 + n1 * n1 + n2 * n2);
            n0 /= nlen;
            n1 /= nlen;
            n2 /= nlen;
            for (i = 0; i < normalsX.length; i += 3) {
                normalsX[i] = n0;
                normalsX[i + 1] = n1;
                normalsX[i + 2] = n2;
            }
            n0 = (coordinatesY[5] - coordinatesY[2]) * (coordinatesY[7] - coordinatesY[1]) - (coordinatesY[4] - coordinatesY[1]) * (coordinatesY[8] - coordinatesY[2]);
            n1 = (coordinatesY[3] - coordinatesY[0]) * (coordinatesY[8] - coordinatesY[2]) - (coordinatesY[5] - coordinatesY[2]) * (coordinatesY[6] - coordinatesY[0]);
            n2 = (coordinatesY[4] - coordinatesY[1]) * (coordinatesY[6] - coordinatesY[0]) - (coordinatesY[3] - coordinatesY[0]) * (coordinatesY[7] - coordinatesY[1]);
            nlen = (float)Math.sqrt(n0 * n0 + n1 * n1 + n2 * n2);
            n0 /= nlen;
            n1 /= nlen;
            n2 /= nlen;
            for (i = 0; i < normalsY.length; i += 3) {
                normalsY[i] = n0;
                normalsY[i + 1] = n1;
                normalsY[i + 2] = n2;
            }
            n0 = (coordinatesZ[5] - coordinatesZ[2]) * (coordinatesZ[7] - coordinatesZ[1]) - (coordinatesZ[4] - coordinatesZ[1]) * (coordinatesZ[8] - coordinatesZ[2]);
            n1 = (coordinatesZ[3] - coordinatesZ[0]) * (coordinatesZ[8] - coordinatesZ[2]) - (coordinatesZ[5] - coordinatesZ[2]) * (coordinatesZ[6] - coordinatesZ[0]);
            n2 = (coordinatesZ[4] - coordinatesZ[1]) * (coordinatesZ[6] - coordinatesZ[0]) - (coordinatesZ[3] - coordinatesZ[0]) * (coordinatesZ[7] - coordinatesZ[1]);
            nlen = (float)Math.sqrt(n0 * n0 + n1 * n1 + n2 * n2);
            n0 /= nlen;
            n1 /= nlen;
            n2 /= nlen;
            for (i = 0; i < normalsZ.length; i += 3) {
                normalsZ[i] = n0;
                normalsZ[i + 1] = n1;
                normalsZ[i + 2] = n2;
            }
            colorsX = new byte[12 * data_width];
            colorsY = new byte[12 * data_height];
            colorsZ = new byte[12 * data_depth];
            for (i = 0; i < 12 * data_width; ++i) {
                colorsX[i] = 127;
            }
            for (i = 0; i < 12 * data_height; ++i) {
                colorsY[i] = 127;
            }
            for (i = 0; i < 12 * data_depth; ++i) {
                colorsZ[i] = 127;
            }
            Trace.call2("ShadowFunctionOrSetType:isTexture3D");
        }
        if (!(isTextureMap || isTexture3D && !range3D || isLinearContour3D)) {
            RealTupleType ref;
            Trace.call1("ShadowFunctionOrSetType:domain");
            if (domain_dimension == 1) {
                domain_doubles = domain_set.getDoubles(false);
                domain_doubles = Unit.convertTuple(domain_doubles, dataUnits, domain_units);
                ShadowFunctionOrSetType.mapValues((float[][])display_values, domain_doubles, DomainComponents);
            } else {
                domain_values = domain_set.getSamples(true);
                domain_values = Unit.convertTuple(domain_values, dataUnits, domain_units, false);
                ShadowFunctionOrSetType.mapValues(display_values, domain_values, DomainComponents, false);
            }
            ShadowRealTupleType domain_reference = this.Domain.getReference();
            Trace.call2("ShadowFunctionOrSetType:domain");
            if (domain_reference != null && domain_reference.getMappedDisplayScalar()) {
                Trace.call1("ShadowFunctionOrSetType:domain_ref_mapped");
                ref = (RealTupleType)domain_reference.getType();
                float[][] reference_values = null;
                double[][] reference_doubles = null;
                if (domain_dimension == 1) {
                    Trace.call1("ShadowFunctionOrSetType:domain_ref_mapped:1");
                    reference_doubles = CoordinateSystem.transformCoordinates(ref, null, ref.getDefaultUnits(), null, (RealTupleType)this.Domain.getType(), dataCoordinateSystem, domain_units, null, domain_doubles);
                    Trace.call2("ShadowFunctionOrSetType:domain_ref_mapped:1");
                } else {
                    Trace.call1("ShadowFunctionOrSetType:domain_ref_mapped:2");
                    reference_values = CoordinateSystem.transformCoordinates(ref, null, ref.getDefaultUnits(), null, (RealTupleType)this.Domain.getType(), dataCoordinateSystem, domain_units, null, domain_values, false);
                    Trace.call2("ShadowFunctionOrSetType:domain_ref_mapped:2");
                }
                renderer.setEarthSpatialData(this.Domain, domain_reference, ref, ref.getDefaultUnits(), (RealTupleType)this.Domain.getType(), new CoordinateSystem[]{dataCoordinateSystem}, domain_units);
                Trace.call1("ShadowFunctionOrSetType:map reference");
                ShadowRealType[] DomainReferenceComponents = this.getDomainReferenceComponents();
                if (domain_dimension == 1) {
                    ShadowFunctionOrSetType.mapValues((float[][])display_values, reference_doubles, DomainReferenceComponents);
                } else {
                    ShadowFunctionOrSetType.mapValues((float[][])display_values, reference_values, DomainReferenceComponents);
                }
                Trace.call2("ShadowFunctionOrSetType:map reference");
                reference_values = null;
                reference_doubles = null;
                Trace.call2("ShadowFunctionOrSetType:domain_ref_mapped");
            } else {
                Trace.call1("ShadowFunctionOrSetType:!domain_ref_mapped");
                ref = domain_reference == null ? null : (RealTupleType)domain_reference.getType();
                Unit[] ref_units = ref == null ? null : ref.getDefaultUnits();
                renderer.setEarthSpatialData(this.Domain, domain_reference, ref, ref_units, (RealTupleType)this.Domain.getType(), new CoordinateSystem[]{dataCoordinateSystem}, domain_units);
                Trace.call2("ShadowFunctionOrSetType:!domain_ref_mapped");
            }
            domain_values = null;
            domain_doubles = null;
        }
        if (this instanceof ShadowFunctionType) {
            float[][] range_values = ((Field)data).getFloats(false);
            if (range_values != null) {
                Trace.call1("ShadowFunctionOrSetType:range_values != null");
                ShadowRealType[] RangeComponents = this.getRangeComponents();
                ShadowFunctionOrSetType.mapValues(display_values, range_values, RangeComponents, true);
                int[] refToComponent = this.getRefToComponent();
                ShadowRealTupleType[] componentWithRef = this.getComponentWithRef();
                int[] componentIndex = this.getComponentIndex();
                if (refToComponent != null) {
                    for (int i = 0; i < refToComponent.length; ++i) {
                        CoordinateSystem[] range_coord_sys;
                        Unit[] range_units;
                        int n = componentWithRef[i].getDimension();
                        int start = refToComponent[i];
                        Object values = new float[n][];
                        for (int j = 0; j < n; ++j) {
                            values[j] = range_values[j + start];
                        }
                        ShadowRealTupleType component_reference = componentWithRef[i].getReference();
                        RealTupleType ref = (RealTupleType)component_reference.getType();
                        if (i == 0 && componentWithRef[i].equals(this.Range)) {
                            range_units = ((Field)data).getDefaultRangeUnits();
                            range_coord_sys = ((Field)data).getRangeCoordinateSystem();
                        } else {
                            Unit[] dummy_units = ((Field)data).getDefaultRangeUnits();
                            range_units = new Unit[n];
                            for (int j = 0; j < n; ++j) {
                                range_units[j] = dummy_units[j + start];
                            }
                            range_coord_sys = ((Field)data).getRangeCoordinateSystem(componentIndex[i]);
                        }
                        float[][] reference_values = null;
                        if (range_coord_sys.length == 1) {
                            reference_values = CoordinateSystem.transformCoordinates(ref, null, ref.getDefaultUnits(), null, (RealTupleType)componentWithRef[i].getType(), range_coord_sys[0], range_units, null, values);
                            renderer.setEarthSpatialData(componentWithRef[i], component_reference, ref, ref.getDefaultUnits(), (RealTupleType)componentWithRef[i].getType(), range_coord_sys, range_units);
                        } else {
                            reference_values = new float[n][domain_length];
                            float[][] temp = new float[n][1];
                            for (int j = 0; j < domain_length; ++j) {
                                int k;
                                for (k = 0; k < n; ++k) {
                                    temp[k][0] = values[k][j];
                                }
                                temp = CoordinateSystem.transformCoordinates(ref, null, ref.getDefaultUnits(), null, (RealTupleType)componentWithRef[i].getType(), range_coord_sys[j], range_units, null, temp);
                                for (k = 0; k < n; ++k) {
                                    reference_values[k][j] = temp[k][0];
                                }
                            }
                            renderer.setEarthSpatialData(componentWithRef[i], component_reference, ref, ref.getDefaultUnits(), (RealTupleType)componentWithRef[i].getType(), range_coord_sys, range_units);
                        }
                        ShadowFunctionOrSetType.mapValues((float[][])display_values, reference_values, this.getComponents(component_reference, false));
                        reference_values = null;
                        values = null;
                    }
                }
                if (this.Range instanceof ShadowTupleType) {
                    if (this.Range instanceof ShadowRealTupleType) {
                        Unit[] range_units = ((Field)data).getDefaultRangeUnits();
                        CoordinateSystem[] range_coord_sys = ((Field)data).getRangeCoordinateSystem();
                        ShadowRealTupleType component_reference = ((ShadowRealTupleType)this.Range).getReference();
                        RealTupleType ref = component_reference == null ? null : (RealTupleType)component_reference.getType();
                        Unit[] ref_units = ref == null ? null : ref.getDefaultUnits();
                        renderer.setEarthSpatialData((ShadowRealTupleType)this.Range, component_reference, ref, ref_units, (RealTupleType)this.Range.getType(), range_coord_sys, range_units);
                    } else {
                        Unit[] dummy_units = ((Field)data).getDefaultRangeUnits();
                        int start = 0;
                        int n = ((ShadowTupleType)this.Range).getDimension();
                        for (int i = 0; i < n; ++i) {
                            ShadowType range_component = ((ShadowTupleType)this.Range).getComponent(i);
                            if (range_component instanceof ShadowRealTupleType) {
                                int m = ((ShadowRealTupleType)range_component).getDimension();
                                Unit[] range_units = new Unit[m];
                                for (int j = 0; j < m; ++j) {
                                    range_units[j] = dummy_units[j + start];
                                }
                                CoordinateSystem[] range_coord_sys = ((Field)data).getRangeCoordinateSystem(i);
                                ShadowRealTupleType component_reference = ((ShadowRealTupleType)range_component).getReference();
                                RealTupleType ref = component_reference == null ? null : (RealTupleType)component_reference.getType();
                                Unit[] ref_units = ref == null ? null : ref.getDefaultUnits();
                                renderer.setEarthSpatialData((ShadowRealTupleType)range_component, component_reference, ref, ref_units, (RealTupleType)range_component.getType(), range_coord_sys, range_units);
                                start += ((ShadowRealTupleType)range_component).getDimension();
                                continue;
                            }
                            if (!(range_component instanceof ShadowRealType)) continue;
                            ++start;
                        }
                    }
                }
                range_values = null;
                Trace.call2("ShadowFunctionOrSetType:range_values != null");
            }
            if (anyText && text_values == null) {
                String[][] string_values;
                for (int i = 0; i < valueArrayLength; ++i) {
                    if (display_values[i] == null) continue;
                    int displayScalarIndex = valueToScalar[i];
                    ScalarMap map = (ScalarMap)MapVector.elementAt(valueToMap[i]);
                    ScalarType real = map.getScalar();
                    DisplayRealType dreal = this.display.getDisplayScalar(displayScalarIndex);
                    if (!dreal.equals(Display.Text) || !(real instanceof RealType)) continue;
                    text_control = (TextControl)map.getControl();
                    text_values = new String[domain_length];
                    NumberFormat format = text_control.getNumberFormat();
                    if (display_values[i].length == 1) {
                        String text = null;
                        text = display_values[i][0] != display_values[i][0] ? "" : (format == null ? PlotText.shortString(display_values[i][0]) : format.format(display_values[i][0]));
                        for (int j = 0; j < domain_length; ++j) {
                            text_values[j] = text;
                        }
                    } else if (format == null) {
                        for (int j = 0; j < domain_length; ++j) {
                            text_values[j] = display_values[i][j] != display_values[i][j] ? "" : PlotText.shortString(display_values[i][j]);
                        }
                    } else {
                        for (int j = 0; j < domain_length; ++j) {
                            text_values[j] = display_values[i][j] != display_values[i][j] ? "" : format.format(display_values[i][j]);
                        }
                    }
                    break;
                }
                if (text_values == null && (string_values = ((Field)data).getStringValues()) != null) {
                    int[] textIndices = ((FunctionType)this.getType()).getTextIndices();
                    int n = string_values.length;
                    if (this.Range instanceof ShadowTextType) {
                        Vector maps = shadow_api.getTextMaps(-1, textIndices);
                        if (!maps.isEmpty()) {
                            text_values = string_values[0];
                            ScalarMap map = (ScalarMap)maps.firstElement();
                            text_control = (TextControl)map.getControl();
                        }
                    } else if (this.Range instanceof ShadowTupleType) {
                        for (int i = 0; i < n; ++i) {
                            Vector maps = shadow_api.getTextMaps(i, textIndices);
                            if (maps.isEmpty()) continue;
                            text_values = string_values[i];
                            ScalarMap map = (ScalarMap)maps.firstElement();
                            text_control = (TextControl)map.getControl();
                        }
                    }
                }
            }
        }
        Trace.call1("ShadowFunctionOrSetType:assembleSelect");
        boolean[][] range_select = shadow_api.assembleSelect(display_values, domain_length, valueArrayLength, valueToScalar, this.display, shadow_api);
        if (range_select[0] != null && range_select[0].length == 1 && !range_select[0][0]) {
            Trace.call2("ShadowFunctionOrSetType:assembleSelect");
            return false;
        }
        Trace.call2("ShadowFunctionOrSetType:assembleSelect");
        if (this.getIsTerminal()) {
            int i;
            Object c;
            int mDim;
            boolean isMissingTransparent;
            if (!this.getFlat()) {
                throw new DisplayException("terminal but not Flat");
            }
            GraphicsModeControl mode = (GraphicsModeControl)this.display.getGraphicsModeControl().clone();
            float pointSize = default_values[this.display.getDisplayScalarIndex(Display.PointSize)];
            mode.setPointSize(pointSize, true);
            float lineWidth = default_values[this.display.getDisplayScalarIndex(Display.LineWidth)];
            mode.setLineWidth(lineWidth, true);
            int lineStyle = (int)default_values[this.display.getDisplayScalarIndex(Display.LineStyle)];
            mode.setLineStyle(lineStyle, true);
            int polygonMode = (int)default_values[this.display.getDisplayScalarIndex(Display.PolygonMode)];
            mode.setPolygonMode(polygonMode, true);
            float polygonOffset = default_values[this.display.getDisplayScalarIndex(Display.PolygonOffset)];
            mode.setPolygonOffset(polygonOffset, true);
            float polygonOffsetFactor = default_values[this.display.getDisplayScalarIndex(Display.PolygonOffsetFactor)];
            mode.setPolygonOffsetFactor(polygonOffsetFactor, true);
            float cacheAppearances = default_values[this.display.getDisplayScalarIndex(Display.CacheAppearances)];
            mode.setCacheAppearances(cacheAppearances > 0.5f);
            float mergeArrays = default_values[this.display.getDisplayScalarIndex(Display.MergeGeometries)];
            mode.setMergeGeometries(mergeArrays > 0.5f);
            boolean pointMode = default_values[this.display.getDisplayScalarIndex(Display.PointMode)] > 0.5f;
            float missingTransparent = default_values[this.display.getDisplayScalarIndex(Display.MissingTransparent)];
            boolean bl = isMissingTransparent = missingTransparent > 0.5f;
            if (data instanceof FlatField && (mDim = ((FlatField)data).getDomainSet().getManifoldDimension()) == 2) {
                this.display.setDepthBufferOffset(renderer, mode);
            }
            Trace.call1("ShadowFunctionOrSetType:assembleColor ");
            boolean[] single_missing = new boolean[]{false, false, false, false};
            Object color_values = shadow_api.assembleColor(display_values, valueArrayLength, valueToScalar, this.display, default_values, range_select, single_missing, shadow_api);
            if (range_select[0] != null && range_select[0].length == 1 && !range_select[0][0]) {
                return false;
            }
            Trace.call2("ShadowFunctionOrSetType:assembleColor ");
            float[][] flow1_values = new float[3][];
            float[][] flow2_values = new float[3][];
            float[] flowScale = new float[2];
            float[] arrowScale = new float[2];
            shadow_api.assembleFlow(flow1_values, flow2_values, flowScale, arrowScale, display_values, valueArrayLength, valueToScalar, this.display, default_values, range_select, renderer, shadow_api);
            if (range_select[0] != null && range_select[0].length == 1 && !range_select[0][0]) {
                return false;
            }
            float[][] spatial_values = new float[3][];
            int[] spatialDimensions = new int[2];
            boolean[] swap = new boolean[]{false, false, false};
            Trace.call1("ShadowFunctionOrSetType:assembleSpatial");
            Object spatial_range_select = new boolean[1][];
            Set spatial_set = shadow_api.assembleSpatial(spatial_values, display_values, valueArrayLength, valueToScalar, this.display, default_values, this.inherited_values, domain_set, this.Domain.getAllSpatial(), anyContour && !isLinearContour3D, spatialDimensions, (boolean[][])spatial_range_select, flow1_values, flow2_values, flowScale, swap, renderer, shadow_api);
            if (isLinearContour3D) {
                spatial_set = domain_set;
                spatialDimensions[0] = 3;
                spatialDimensions[1] = 3;
            }
            boolean spatial_all_select = true;
            if (spatial_range_select[0] != null) {
                int j;
                spatial_all_select = false;
                if (range_select[0] == null) {
                    range_select[0] = spatial_range_select[0];
                } else if (spatial_range_select[0].length == 1) {
                    for (j = 0; j < range_select[0].length; ++j) {
                        range_select[0][j] = range_select[0][j] && spatial_range_select[0][0];
                    }
                } else {
                    for (j = 0; j < range_select[0].length; ++j) {
                        range_select[0][j] = range_select[0][j] && spatial_range_select[0][j];
                    }
                }
            }
            spatial_range_select = null;
            if (range_select[0] != null && range_select[0].length == 1 && !range_select[0][0]) {
                return false;
            }
            Trace.call2("ShadowFunctionOrSetType:assembleSpatial");
            int spatialDomainDimension = spatialDimensions[0];
            int spatialManifoldDimension = spatialDimensions[1];
            int spatial_length = Math.min(domain_length, spatial_values[0].length);
            int color_length = Math.min(domain_length, color_values[0].length);
            int alpha_length = color_values[3].length;
            Trace.call1("ShadowFunctionOrSetType:missing color");
            float constant_alpha = Float.NaN;
            float[] constant_color = null;
            if (alpha_length == 1) {
                if (single_missing[3]) {
                    return false;
                }
                if (color_values[3][0] == -1) {
                    constant_alpha = 0.0f;
                    c = new byte[3][];
                    c[0] = color_values[0];
                    c[1] = color_values[1];
                    c[2] = color_values[2];
                    color_values = c;
                } else {
                    byte v = color_values[3][0];
                    color_values[3] = new byte[color_values[0].length];
                    for (i = 0; i < color_values[0].length; ++i) {
                        color_values[3][i] = v;
                    }
                }
            }
            if (color_length == 1) {
                if (shadow_api.allowConstantColorSurfaces()) {
                    if (single_missing[0] || single_missing[1] || single_missing[2]) {
                        return false;
                    }
                    constant_color = new float[]{ShadowFunctionOrSetType.byteToFloat(color_values[0][0]), ShadowFunctionOrSetType.byteToFloat(color_values[1][0]), ShadowFunctionOrSetType.byteToFloat(color_values[2][0])};
                    color_values = null;
                } else {
                    c = new byte[((byte[][])color_values).length][domain_length];
                    for (i = 0; i < ((byte[][])color_values).length; ++i) {
                        Arrays.fill(c[i], color_values[i][0]);
                    }
                    color_values = c;
                }
            }
            Trace.call2("ShadowFunctionOrSetType:missing color");
            if (range_select[0] != null && range_select[0].length == 1 && !range_select[0][0]) {
                return false;
            }
            if (this.LevelOfDifficulty == 3) {
                VisADGeometryArray array;
                Trace.call1("ShadowFunctionOrSetType:assembleShape");
                boolean anyShapeCreated = false;
                VisADGeometryArray[] arrays = shadow_api.assembleShape(display_values, valueArrayLength, valueToMap, MapVector, valueToScalar, this.display, default_values, this.inherited_values, spatial_values, (byte[][])color_values, range_select, -1, shadow_api);
                if (arrays != null) {
                    for (int i3 = 0; i3 < arrays.length; ++i3) {
                        array = arrays[i3];
                        shadow_api.addToGroup(group, array, mode, constant_alpha, constant_color);
                        array = null;
                    }
                    anyShapeCreated = true;
                    arrays = null;
                }
                Trace.call2("ShadowFunctionOrSetType:assembleShape");
                boolean anyTextCreated = false;
                if (anyText && text_values != null && text_control != null) {
                    Trace.call1("ShadowFunctionOrSetType:makeText");
                    array = shadow_api.makeText(text_values, text_control, spatial_values, (byte[][])color_values, range_select);
                    shadow_api.addTextToGroup(group, array, mode, constant_alpha, constant_color);
                    array = null;
                    anyTextCreated = true;
                    Trace.call2("ShadowFunctionOrSetType:makeText");
                }
                boolean anyFlowCreated = false;
                if (anyFlow) {
                    int i4;
                    Trace.call1("ShadowFunctionOrSetType:flow");
                    Trace.call1("ShadowFunctionOrSetType:makeStreamline flow1");
                    arrays = shadow_api.makeStreamline(0, flow1_values, flowScale[0], spatial_values, spatial_set, spatialManifoldDimension, (byte[][])color_values, range_select, valueArrayLength, valueToMap, MapVector);
                    Trace.call2("ShadowFunctionOrSetType:makeStreamline flow1");
                    if (arrays != null) {
                        for (i4 = 0; i4 < arrays.length; ++i4) {
                            if (arrays[i4] == null) continue;
                            shadow_api.addToGroup(group, arrays[i4], mode, constant_alpha, constant_color);
                            arrays[i4] = null;
                        }
                    } else if (this.trajectory1) {
                        shadow_api.makeTrajFlow(0, flow1_values, data, flowScale[0], spatial_values, spatial_set, spatialManifoldDimension, (byte[][])color_values, range_select, mode, constant_alpha, constant_color, valueArrayLength, valueToMap, MapVector, this.flowInfoList);
                    } else {
                        Trace.call1("ShadowFunctionOrSetType:makeFlow flow1");
                        arrays = shadow_api.makeFlow(0, flow1_values, flowScale[0], arrowScale[0], spatial_values, (byte[][])color_values, range_select);
                        if (arrays != null) {
                            for (i4 = 0; i4 < arrays.length; ++i4) {
                                if (arrays[i4] == null) continue;
                                shadow_api.addToGroup(group, arrays[i4], mode, constant_alpha, constant_color);
                                arrays[i4] = null;
                            }
                        }
                        Trace.call2("ShadowFunctionOrSetType:makeFlow flow1");
                    }
                    anyFlowCreated = true;
                    Trace.call1("ShadowFunctionOrSetType:makeStreamline flow2");
                    arrays = shadow_api.makeStreamline(1, flow2_values, flowScale[1], spatial_values, spatial_set, spatialManifoldDimension, (byte[][])color_values, range_select, valueArrayLength, valueToMap, MapVector);
                    Trace.call2("ShadowFunctionOrSetType:makeStreamline flow2");
                    if (arrays != null) {
                        for (i4 = 0; i4 < arrays.length; ++i4) {
                            if (arrays[i4] == null) continue;
                            shadow_api.addToGroup(group, arrays[i4], mode, constant_alpha, constant_color);
                            arrays[i4] = null;
                        }
                    } else if (this.trajectory2) {
                        shadow_api.makeTrajFlow(1, flow2_values, data, flowScale[1], spatial_values, spatial_set, spatialManifoldDimension, (byte[][])color_values, range_select, mode, constant_alpha, constant_color, valueArrayLength, valueToMap, MapVector, this.flowInfoList);
                    } else {
                        Trace.call1("ShadowFunctionOrSetType:makeFlow flow2");
                        arrays = shadow_api.makeFlow(1, flow2_values, flowScale[1], arrowScale[1], spatial_values, (byte[][])color_values, range_select);
                        if (arrays != null) {
                            for (i4 = 0; i4 < arrays.length; ++i4) {
                                if (arrays[i4] == null) continue;
                                shadow_api.addToGroup(group, arrays[i4], mode, constant_alpha, constant_color);
                                arrays[i4] = null;
                            }
                        }
                        Trace.call2("ShadowFunctionOrSetType:makeFlow flow2");
                    }
                    anyFlowCreated = true;
                    Trace.call2("ShadowFunctionOrSetType:flow");
                }
                boolean anyContourCreated = false;
                if (anyContour) {
                    Trace.call1("ShadowFunctionOrSetType:makeContour");
                    anyContourCreated = shadow_api.makeContour(valueArrayLength, valueToScalar, display_values, this.inherited_values, MapVector, valueToMap, domain_length, range_select, spatialManifoldDimension, spatial_set, (byte[][])color_values, indexed, group, mode, swap, constant_alpha, constant_color, shadow_api, this.Domain, this.DomainReferenceComponents, domain_set, domain_units, dataCoordinateSystem);
                    Trace.call2("ShadowFunctionOrSetType:makeContour");
                }
                this.spatial_offset_values = null;
                if (!(anyContourCreated || anyFlowCreated || anyTextCreated || anyShapeCreated)) {
                    if (isTextureMap) {
                        int k;
                        Trace.call1("ShadowFunctionOrSetType:linear texture");
                        if (color_values == null) {
                            color_values = new byte[3][domain_length];
                            for (int i5 = 0; i5 < domain_length; ++i5) {
                                color_values[0][i5] = ShadowFunctionOrSetType.floatToByte(constant_color[0]);
                                color_values[1][i5] = ShadowFunctionOrSetType.floatToByte(constant_color[1]);
                                color_values[2][i5] = ShadowFunctionOrSetType.floatToByte(constant_color[2]);
                            }
                        }
                        if (range_select[0] != null && range_select[0].length > 1) {
                            int i6;
                            int len = range_select[0].length;
                            float alpha = default_values[this.display.getDisplayScalarIndex(Display.Alpha)];
                            if (constant_alpha == constant_alpha) {
                                alpha = 1.0f - constant_alpha;
                            }
                            if (((byte[][])color_values).length < 4) {
                                byte[][] c2 = new byte[][]{color_values[0], color_values[1], color_values[2], new byte[len]};
                                for (int i7 = 0; i7 < len; ++i7) {
                                    c2[3][i7] = ShadowFunctionOrSetType.floatToByte(alpha);
                                }
                                constant_alpha = Float.NaN;
                                color_values = c2;
                            }
                            if (isMissingTransparent) {
                                for (i6 = 0; i6 < len; ++i6) {
                                    if (range_select[0][i6]) continue;
                                    color_values[3][i6] = 0;
                                }
                            } else {
                                for (i6 = 0; i6 < len; ++i6) {
                                    if (range_select[0][i6]) continue;
                                    color_values[0][i6] = 0;
                                    color_values[1][i6] = 0;
                                    color_values[2][i6] = 0;
                                }
                            }
                        }
                        int[] lens = ((GriddedSet)domain_set).getLengths();
                        int limit = link.getDisplay().getDisplayRenderer().getTextureWidthMax();
                        int y_sub_len = lens[1];
                        int n_y_sub = 1;
                        while (y_sub_len >= limit) {
                            y_sub_len /= 2;
                            n_y_sub *= 2;
                        }
                        int[][] y_start_stop = new int[n_y_sub][2];
                        for (k = 0; k < n_y_sub - 1; ++k) {
                            y_start_stop[k][0] = k * y_sub_len;
                            y_start_stop[k][1] = (k + 1) * y_sub_len - 1;
                        }
                        k = n_y_sub - 1;
                        y_start_stop[k][0] = k * y_sub_len;
                        y_start_stop[k][1] = lens[1] - 1;
                        int x_sub_len = lens[0];
                        int n_x_sub = 1;
                        while (x_sub_len >= limit) {
                            x_sub_len /= 2;
                            n_x_sub *= 2;
                        }
                        int[][] x_start_stop = new int[n_x_sub][2];
                        for (k = 0; k < n_x_sub - 1; ++k) {
                            x_start_stop[k][0] = k * x_sub_len;
                            x_start_stop[k][1] = (k + 1) * x_sub_len - 1;
                        }
                        k = n_x_sub - 1;
                        x_start_stop[k][0] = k * x_sub_len;
                        x_start_stop[k][1] = lens[0] - 1;
                        if (n_y_sub == 1 && n_x_sub == 1) {
                            this.buildLinearTexture(group, domain_set, dataUnits, domain_units, default_values, shadow_api, valueArrayLength, valueToScalar, value_array, (byte[][])color_values, mode, constant_color, constant_alpha);
                        } else {
                            Object branch = shadow_api.makeBranch();
                            int start = 0;
                            int i_total = 0;
                            for (int i8 = 0; i8 < n_y_sub; ++i8) {
                                int leny = y_start_stop[i8][1] - y_start_stop[i8][0] + 1;
                                for (int j = 0; j < n_x_sub; ++j) {
                                    int lenx = x_start_stop[j][1] - x_start_stop[j][0] + 1;
                                    float[][] g00 = ((GriddedSet)domain_set).gridToValue(new float[][]{{x_start_stop[j][0]}, {y_start_stop[i8][0]}});
                                    float[][] g11 = ((GriddedSet)domain_set).gridToValue(new float[][]{{x_start_stop[j][1]}, {y_start_stop[i8][1]}});
                                    double x0 = g00[0][0];
                                    double x1 = g11[0][0];
                                    double y0 = g00[1][0];
                                    double y1 = g11[1][0];
                                    Linear2DSet dset = new Linear2DSet(x0, x1, lenx, y0, y1, leny);
                                    byte[][] color_valuesW = null;
                                    if (((byte[][])color_values).length == 3) {
                                        color_valuesW = new byte[3][lenx * leny];
                                    }
                                    if (((byte[][])color_values).length == 4) {
                                        color_valuesW = new byte[4][lenx * leny];
                                    }
                                    int cnt = 0;
                                    for (k = 0; k < leny; ++k) {
                                        start = x_start_stop[j][0] + i_total * lens[0] + k * lens[0];
                                        System.arraycopy(color_values[0], start, color_valuesW[0], cnt, lenx);
                                        System.arraycopy(color_values[1], start, color_valuesW[1], cnt, lenx);
                                        System.arraycopy(color_values[2], start, color_valuesW[2], cnt, lenx);
                                        if (((byte[][])color_values).length == 4) {
                                            System.arraycopy(color_values[3], start, color_valuesW[3], cnt, lenx);
                                        }
                                        cnt += lenx;
                                    }
                                    Object branch1 = shadow_api.makeBranch();
                                    this.buildLinearTexture(branch1, dset, dataUnits, domain_units, default_values, shadow_api, valueArrayLength, valueToScalar, value_array, color_valuesW, mode, constant_color, constant_alpha);
                                    shadow_api.addToGroup(branch, branch1);
                                }
                                i_total += leny;
                            }
                            shadow_api.addToGroup(group, branch);
                        }
                        Trace.call2("ShadowFunctionOrSetType:linear texture");
                        return false;
                    }
                    if (curvedTexture) {
                        int k;
                        Trace.call1("ShadowFunctionOrSetType:curved texture");
                        if (color_values == null) {
                            color_values = new byte[3][domain_length];
                            for (int i9 = 0; i9 < domain_length; ++i9) {
                                color_values[0][i9] = ShadowFunctionOrSetType.floatToByte(constant_color[0]);
                                color_values[1][i9] = ShadowFunctionOrSetType.floatToByte(constant_color[1]);
                                color_values[2][i9] = ShadowFunctionOrSetType.floatToByte(constant_color[2]);
                            }
                        }
                        if (range_select[0] != null && range_select[0].length > 1) {
                            int i10;
                            int len = range_select[0].length;
                            float alpha = default_values[this.display.getDisplayScalarIndex(Display.Alpha)];
                            if (constant_alpha == constant_alpha) {
                                alpha = 1.0f - constant_alpha;
                            }
                            if (((byte[][])color_values).length < 4) {
                                byte[][] c3 = new byte[][]{color_values[0], color_values[1], color_values[2], new byte[len]};
                                for (int i11 = 0; i11 < len; ++i11) {
                                    c3[3][i11] = ShadowFunctionOrSetType.floatToByte(alpha);
                                }
                                constant_alpha = Float.NaN;
                                color_values = c3;
                            }
                            if (isMissingTransparent) {
                                for (i10 = 0; i10 < domain_length; ++i10) {
                                    if (range_select[0][i10]) continue;
                                    color_values[3][i10] = 0;
                                }
                            } else {
                                for (i10 = 0; i10 < domain_length; ++i10) {
                                    if (range_select[0][i10]) continue;
                                    color_values[0][i10] = 0;
                                    color_values[1][i10] = 0;
                                    color_values[2][i10] = 0;
                                }
                            }
                        }
                        int[] lens = ((GriddedSet)domain_set).getLengths();
                        int limit = link.getDisplay().getDisplayRenderer().getTextureWidthMax();
                        int y_sub_len = lens[1];
                        int n_y_sub = 1;
                        while (y_sub_len >= limit) {
                            y_sub_len /= 2;
                            n_y_sub *= 2;
                        }
                        int[][] y_start_stop = new int[n_y_sub][2];
                        for (k = 0; k < n_y_sub - 1; ++k) {
                            y_start_stop[k][0] = k * y_sub_len;
                            y_start_stop[k][1] = (k + 1) * y_sub_len - 1;
                        }
                        k = n_y_sub - 1;
                        y_start_stop[k][0] = k * y_sub_len;
                        y_start_stop[k][1] = lens[1] - 1;
                        int x_sub_len = lens[0];
                        int n_x_sub = 1;
                        while (x_sub_len >= limit) {
                            x_sub_len /= 2;
                            n_x_sub *= 2;
                        }
                        int[][] x_start_stop = new int[n_x_sub][2];
                        for (k = 0; k < n_x_sub - 1; ++k) {
                            x_start_stop[k][0] = k * x_sub_len;
                            x_start_stop[k][1] = (k + 1) * x_sub_len - 1;
                        }
                        k = n_x_sub - 1;
                        x_start_stop[k][0] = k * x_sub_len;
                        x_start_stop[k][1] = lens[0] - 1;
                        if (n_y_sub == 1 && n_x_sub == 1) {
                            this.buildCurvedTexture(group, domain_set, dataUnits, domain_units, default_values, shadow_api, valueArrayLength, valueToScalar, value_array, (byte[][])color_values, mode, constant_color, constant_alpha, curved_size, spatial_values, spatial_all_select, renderer, range_select, domainOnlySpatial, null, lens[0], lens[1], lens[0], lens[1]);
                        } else {
                            Object branch = shadow_api.makeBranch();
                            float[][] samples = spatial_values;
                            int start = 0;
                            int i_total = 0;
                            for (int i12 = 0; i12 < n_y_sub; ++i12) {
                                int leny = y_start_stop[i12][1] - y_start_stop[i12][0] + 1;
                                for (int j = 0; j < n_x_sub; ++j) {
                                    float[][] samplesC;
                                    int lenx = x_start_stop[j][1] - x_start_stop[j][0] + 1;
                                    if (j > 0) {
                                        samplesC = new float[3][4 * leny];
                                        byte[][] color_valuesC = new byte[((byte[][])color_values).length][4 * leny];
                                        int cntv = 0;
                                        int startv = x_start_stop[j][0] + i_total * lens[0];
                                        for (int iv = 0; iv < leny; ++iv) {
                                            samplesC[0][cntv] = samples[0][startv - 2];
                                            samplesC[0][cntv + 1] = samples[0][startv - 1];
                                            samplesC[0][cntv + 2] = samples[0][startv];
                                            samplesC[0][cntv + 3] = samples[0][startv + 1];
                                            samplesC[1][cntv] = samples[1][startv - 2];
                                            samplesC[1][cntv + 1] = samples[1][startv - 1];
                                            samplesC[1][cntv + 2] = samples[1][startv];
                                            samplesC[1][cntv + 3] = samples[1][startv + 1];
                                            samplesC[2][cntv] = samples[2][startv - 2];
                                            samplesC[2][cntv + 1] = samples[2][startv - 1];
                                            samplesC[2][cntv + 2] = samples[2][startv];
                                            samplesC[2][cntv + 3] = samples[2][startv + 1];
                                            color_valuesC[0][cntv] = color_values[0][startv - 2];
                                            color_valuesC[0][cntv + 1] = color_values[0][startv - 1];
                                            color_valuesC[0][cntv + 2] = color_values[0][startv];
                                            color_valuesC[0][cntv + 3] = color_values[0][startv + 1];
                                            color_valuesC[1][cntv] = color_values[1][startv - 2];
                                            color_valuesC[1][cntv + 1] = color_values[1][startv - 1];
                                            color_valuesC[1][cntv + 2] = color_values[1][startv];
                                            color_valuesC[1][cntv + 3] = color_values[1][startv + 1];
                                            color_valuesC[2][cntv] = color_values[2][startv - 2];
                                            color_valuesC[2][cntv + 1] = color_values[2][startv - 1];
                                            color_valuesC[2][cntv + 2] = color_values[2][startv];
                                            color_valuesC[2][cntv + 3] = color_values[2][startv + 1];
                                            if (color_valuesC.length == 4) {
                                                color_valuesC[3][cntv] = color_values[3][startv - 2];
                                                color_valuesC[3][cntv + 1] = color_values[3][startv - 1];
                                                color_valuesC[3][cntv + 2] = color_values[3][startv];
                                                color_valuesC[3][cntv + 3] = color_values[3][startv + 1];
                                            }
                                            cntv += 4;
                                            startv += lens[0];
                                        }
                                        Object branchv = shadow_api.makeBranch();
                                        this.buildCurvedTexture(branchv, null, dataUnits, domain_units, default_values, shadow_api, valueArrayLength, valueToScalar, value_array, color_valuesC, mode, constant_color, constant_alpha, curved_size, samplesC, spatial_all_select, renderer, range_select, domainOnlySpatial, null, 4, leny, lens[0], lens[1]);
                                        shadow_api.addToGroup(branch, branchv);
                                    }
                                    if (i12 > 0) {
                                        samplesC = new float[3][4 * lenx];
                                        byte[][] color_valuesC = new byte[((byte[][])color_values).length][4 * lenx];
                                        int starth = x_start_stop[j][0] + i_total * lens[0];
                                        int cnth = 0;
                                        System.arraycopy(samples[0], starth - 2 * lens[0], samplesC[0], cnth, lenx);
                                        System.arraycopy(samples[1], starth - 2 * lens[0], samplesC[1], cnth, lenx);
                                        System.arraycopy(samples[2], starth - 2 * lens[0], samplesC[2], cnth, lenx);
                                        System.arraycopy(samples[0], starth - 1 * lens[0], samplesC[0], cnth += lenx, lenx);
                                        System.arraycopy(samples[1], starth - 1 * lens[0], samplesC[1], cnth, lenx);
                                        System.arraycopy(samples[2], starth - 1 * lens[0], samplesC[2], cnth, lenx);
                                        System.arraycopy(samples[0], starth, samplesC[0], cnth += lenx, lenx);
                                        System.arraycopy(samples[1], starth, samplesC[1], cnth, lenx);
                                        System.arraycopy(samples[2], starth, samplesC[2], cnth, lenx);
                                        System.arraycopy(samples[0], starth + 1 * lens[0], samplesC[0], cnth += lenx, lenx);
                                        System.arraycopy(samples[1], starth + 1 * lens[0], samplesC[1], cnth, lenx);
                                        System.arraycopy(samples[2], starth + 1 * lens[0], samplesC[2], cnth, lenx);
                                        cnth = 0;
                                        System.arraycopy(color_values[0], starth - 2 * lens[0], color_valuesC[0], cnth, lenx);
                                        System.arraycopy(color_values[1], starth - 2 * lens[0], color_valuesC[1], cnth, lenx);
                                        System.arraycopy(color_values[2], starth - 2 * lens[0], color_valuesC[2], cnth, lenx);
                                        if (((byte[][])color_values).length == 4) {
                                            System.arraycopy(color_values[3], starth - 2 * lens[0], color_valuesC[3], cnth, lenx);
                                        }
                                        System.arraycopy(color_values[0], starth - 1 * lens[0], color_valuesC[0], cnth += lenx, lenx);
                                        System.arraycopy(color_values[1], starth - 1 * lens[0], color_valuesC[1], cnth, lenx);
                                        System.arraycopy(color_values[2], starth - 1 * lens[0], color_valuesC[2], cnth, lenx);
                                        if (((byte[][])color_values).length == 4) {
                                            System.arraycopy(color_values[3], starth - 1 * lens[0], color_valuesC[3], cnth, lenx);
                                        }
                                        System.arraycopy(color_values[0], starth, color_valuesC[0], cnth += lenx, lenx);
                                        System.arraycopy(color_values[1], starth, color_valuesC[1], cnth, lenx);
                                        System.arraycopy(color_values[2], starth, color_valuesC[2], cnth, lenx);
                                        if (((byte[][])color_values).length == 4) {
                                            System.arraycopy(color_values[3], starth, color_valuesC[3], cnth, lenx);
                                        }
                                        System.arraycopy(color_values[0], starth + 1 * lens[0], color_valuesC[0], cnth += lenx, lenx);
                                        System.arraycopy(color_values[1], starth + 1 * lens[0], color_valuesC[1], cnth, lenx);
                                        System.arraycopy(color_values[2], starth + 1 * lens[0], color_valuesC[2], cnth, lenx);
                                        if (((byte[][])color_values).length == 4) {
                                            System.arraycopy(color_values[3], starth + 1 * lens[0], color_valuesC[3], cnth, lenx);
                                        }
                                        Object branchh = shadow_api.makeBranch();
                                        this.buildCurvedTexture(branchh, null, dataUnits, domain_units, default_values, shadow_api, valueArrayLength, valueToScalar, value_array, color_valuesC, mode, constant_color, constant_alpha, curved_size, samplesC, spatial_all_select, renderer, range_select, domainOnlySpatial, null, lenx, 4, lens[0], lens[1]);
                                        shadow_api.addToGroup(branch, branchh);
                                    }
                                    byte[][] color_valuesW = null;
                                    if (((byte[][])color_values).length == 3) {
                                        color_valuesW = new byte[3][lenx * leny];
                                    }
                                    if (((byte[][])color_values).length == 4) {
                                        color_valuesW = new byte[4][lenx * leny];
                                    }
                                    int cnt = 0;
                                    for (k = 0; k < leny; ++k) {
                                        start = x_start_stop[j][0] + i_total * lens[0] + k * lens[0];
                                        System.arraycopy(color_values[0], start, color_valuesW[0], cnt, lenx);
                                        System.arraycopy(color_values[1], start, color_valuesW[1], cnt, lenx);
                                        System.arraycopy(color_values[2], start, color_valuesW[2], cnt, lenx);
                                        if (((byte[][])color_values).length == 4) {
                                            System.arraycopy(color_values[3], start, color_valuesW[3], cnt, lenx);
                                        }
                                        cnt += lenx;
                                    }
                                    Object branch1 = shadow_api.makeBranch();
                                    this.buildCurvedTexture(branch1, null, dataUnits, domain_units, default_values, shadow_api, valueArrayLength, valueToScalar, value_array, color_valuesW, mode, constant_color, constant_alpha, curved_size, samples, spatial_all_select, renderer, range_select, domainOnlySpatial, new int[]{x_start_stop[j][0], y_start_stop[i12][0]}, lenx, leny, lens[0], lens[1]);
                                    shadow_api.addToGroup(branch, branch1);
                                }
                                i_total += leny;
                            }
                            shadow_api.addToGroup(group, branch);
                        }
                        Trace.call2("ShadowFunctionOrSetType:curved texture");
                        return false;
                    }
                    if (isTexture3D) {
                        Trace.call1("ShadowFunctionOrSetType:3D texture");
                        if (color_values == null) {
                            color_values = new byte[3][domain_length];
                            for (int i13 = 0; i13 < domain_length; ++i13) {
                                color_values[0][i13] = ShadowFunctionOrSetType.floatToByte(constant_color[0]);
                                color_values[1][i13] = ShadowFunctionOrSetType.floatToByte(constant_color[1]);
                                color_values[2][i13] = ShadowFunctionOrSetType.floatToByte(constant_color[2]);
                            }
                        }
                        if (range_select[0] != null && range_select[0].length > 1) {
                            int len = range_select[0].length;
                            float alpha = default_values[this.display.getDisplayScalarIndex(Display.Alpha)];
                            if (constant_alpha == constant_alpha) {
                                alpha = 1.0f - constant_alpha;
                            }
                            if (((byte[][])color_values).length < 4) {
                                byte[][] c4 = new byte[][]{color_values[0], color_values[1], color_values[2], new byte[len]};
                                for (int i14 = 0; i14 < len; ++i14) {
                                    c4[3][i14] = ShadowFunctionOrSetType.floatToByte(alpha);
                                }
                                constant_alpha = Float.NaN;
                                color_values = c4;
                            }
                            for (int i15 = 0; i15 < len; ++i15) {
                                if (range_select[0][i15]) continue;
                                color_values[3][i15] = 0;
                                color_values[0][i15] = 0;
                                color_values[1][i15] = 0;
                                color_values[2][i15] = 0;
                            }
                        }
                        VisADQuadArray[] qarray = new VisADQuadArray[]{new VisADQuadArray(), new VisADQuadArray(), new VisADQuadArray()};
                        qarray[0].vertexCount = coordinatesX.length / 3;
                        qarray[0].coordinates = coordinatesX;
                        qarray[0].texCoords = texCoordsX;
                        qarray[0].colors = colorsX;
                        qarray[0].normals = normalsX;
                        qarray[1].vertexCount = coordinatesY.length / 3;
                        qarray[1].coordinates = coordinatesY;
                        qarray[1].texCoords = texCoordsY;
                        qarray[1].colors = colorsY;
                        qarray[1].normals = normalsY;
                        qarray[2].vertexCount = coordinatesZ.length / 3;
                        qarray[2].coordinates = coordinatesZ;
                        qarray[2].texCoords = texCoordsZ;
                        qarray[2].colors = colorsZ;
                        qarray[2].normals = normalsZ;
                        VisADQuadArray qarrayX = null;
                        VisADQuadArray qarrayY = null;
                        VisADQuadArray qarrayZ = null;
                        for (int i16 = 0; i16 < 3; ++i16) {
                            if (volume_tuple_index[i16] == 0) {
                                qarrayX = qarray[i16];
                                continue;
                            }
                            if (volume_tuple_index[i16] == 1) {
                                qarrayY = qarray[i16];
                                continue;
                            }
                            if (volume_tuple_index[i16] != 2) continue;
                            qarrayZ = qarray[i16];
                        }
                        VisADQuadArray qarrayXrev = this.reverse(qarrayX);
                        VisADQuadArray qarrayYrev = this.reverse(qarrayY);
                        VisADQuadArray qarrayZrev = this.reverse(qarrayZ);
                        if (t3dm == 0) {
                            BufferedImage[][] images = new BufferedImage[3][];
                            for (int i17 = 0; i17 < 3; ++i17) {
                                images[i17] = this.createImages(i17, data_width, data_height, data_depth, texture_width, texture_height, texture_depth, (byte[][])color_values);
                            }
                            BufferedImage[] imagesX = null;
                            BufferedImage[] imagesY = null;
                            BufferedImage[] imagesZ = null;
                            for (int i18 = 0; i18 < 3; ++i18) {
                                if (volume_tuple_index[i18] == 0) {
                                    imagesX = images[i18];
                                    continue;
                                }
                                if (volume_tuple_index[i18] == 1) {
                                    imagesY = images[i18];
                                    continue;
                                }
                                if (volume_tuple_index[i18] != 2) continue;
                                imagesZ = images[i18];
                            }
                            shadow_api.textureStackToGroup(group, qarrayX, qarrayY, qarrayZ, qarrayXrev, qarrayYrev, qarrayZrev, imagesX, imagesY, imagesZ, mode, constant_alpha, constant_color, texture_width, texture_height, texture_depth, renderer);
                        } else {
                            BufferedImage[] images = this.createImages(2, data_width, data_height, data_depth, texture_width, texture_height, texture_depth, (byte[][])color_values);
                            shadow_api.texture3DToGroup(group, qarrayX, qarrayY, qarrayZ, qarrayXrev, qarrayYrev, qarrayZrev, images, mode, constant_alpha, constant_color, texture_width, texture_height, texture_depth, renderer);
                        }
                        Trace.call1("ShadowFunctionOrSetType:3D texture");
                        return false;
                    }
                    if (pointMode || spatial_set == null || spatialManifoldDimension == 0 || spatialManifoldDimension == 3) {
                        Trace.call1("ShadowFunctionOrSetType:point mode");
                        if (range_select[0] != null) {
                            int len = range_select[0].length;
                            if (len == 1 || spatial_values[0].length == 1) {
                                return false;
                            }
                            for (int j = 0; j < len; ++j) {
                                if (range_select[0][j]) continue;
                                spatial_values[0][j] = Float.NaN;
                            }
                            array = ShadowFunctionOrSetType.makePointGeometry(spatial_values, color_values, true);
                        } else {
                            array = ShadowFunctionOrSetType.makePointGeometry(spatial_values, color_values);
                        }
                        Trace.call2("ShadowFunctionOrSetType:point mode");
                    } else if (spatialManifoldDimension == 1) {
                        Trace.call1("ShadowFunctionOrSetType:manifold dimension == 1");
                        if (range_select[0] != null) {
                            if (isMissingTransparent) {
                                spatial_set.cram_missing(range_select[0]);
                                spatial_all_select = false;
                            } else {
                                int i19;
                                if (color_values == null) {
                                    color_values = new byte[4][domain_length];
                                    for (i19 = 0; i19 < domain_length; ++i19) {
                                        color_values[0][i19] = ShadowFunctionOrSetType.floatToByte(constant_color[0]);
                                        color_values[1][i19] = ShadowFunctionOrSetType.floatToByte(constant_color[1]);
                                        color_values[2][i19] = ShadowFunctionOrSetType.floatToByte(constant_color[2]);
                                    }
                                }
                                for (i19 = 0; i19 < domain_length; ++i19) {
                                    if (range_select[0][i19]) continue;
                                    color_values[0][i19] = 0;
                                    color_values[1][i19] = 0;
                                    color_values[2][i19] = 0;
                                }
                            }
                        }
                        if ((array = spatial_set.make1DGeometry((byte[][])color_values)) != null) {
                            if (!spatial_all_select) {
                                array = array.removeMissing();
                            }
                            if (this.getAdjustProjectionSeam()) {
                                array = array.adjustLongitude(renderer);
                                array = array.adjustSeam(renderer);
                            }
                        }
                        Trace.call2("ShadowFunctionOrSetType:manifold dimension == 1");
                    } else if (spatialManifoldDimension == 2) {
                        Trace.call1("ShadowFunctionOrSetType:manifold dimension == 2");
                        if (range_select[0] != null) {
                            if (isMissingTransparent) {
                                spatial_set.cram_missing(range_select[0]);
                                spatial_all_select = false;
                            } else {
                                int i20;
                                if (color_values == null) {
                                    color_values = new byte[4][domain_length];
                                    for (i20 = 0; i20 < domain_length; ++i20) {
                                        color_values[0][i20] = ShadowFunctionOrSetType.floatToByte(constant_color[0]);
                                        color_values[1][i20] = ShadowFunctionOrSetType.floatToByte(constant_color[1]);
                                        color_values[2][i20] = ShadowFunctionOrSetType.floatToByte(constant_color[2]);
                                    }
                                }
                                for (i20 = 0; i20 < domain_length; ++i20) {
                                    if (range_select[0][i20]) continue;
                                    color_values[0][i20] = 0;
                                    color_values[1][i20] = 0;
                                    color_values[2][i20] = 0;
                                }
                            }
                        }
                        if ((array = spatial_set.make2DGeometry((byte[][])color_values, indexed)) != null) {
                            if (!spatial_all_select) {
                                array = array.removeMissing();
                            }
                            if (this.getAdjustProjectionSeam()) {
                                array = array.adjustLongitude(renderer);
                                array = array.adjustSeam(renderer);
                            }
                        }
                        Trace.call2("ShadowFunctionOrSetType:manifold dimension == 2");
                    } else {
                        throw new DisplayException("bad spatialManifoldDimension: ShadowFunctionOrSetType.doTransform");
                    }
                    if (array != null && array.vertexCount > 0) {
                        shadow_api.addToGroup(group, array, mode, constant_alpha, constant_color);
                        array = null;
                    }
                }
                if (renderer.getIsDirectManipulation()) {
                    renderer.setSpatialValues(spatial_values);
                }
                return false;
            }
            if (this.LevelOfDifficulty == 4) {
                Control control = null;
                Object swit = null;
                int index = -1;
                if (DomainComponents.length == 1) {
                    RealType real = (RealType)DomainComponents[0].getType();
                    for (int i21 = 0; i21 < valueArrayLength; ++i21) {
                        int displayScalarIndex;
                        DisplayRealType dreal;
                        ScalarMap map = (ScalarMap)MapVector.elementAt(valueToMap[i21]);
                        float[] values = display_values[i21];
                        if (values == null || !real.equals(map.getScalar()) || !(dreal = this.display.getDisplayScalar(displayScalarIndex = valueToScalar[i21])).equals(Display.Animation) && !dreal.equals(Display.SelectValue)) continue;
                        swit = shadow_api.makeSwitch();
                        index = i21;
                        control = map.getControl();
                        break;
                    }
                }
                if (control == null) {
                    throw new DisplayException("bad SIMPLE_ANIMATE_FIELD: ShadowFunctionOrSetType.doTransform");
                }
                for (int i22 = 0; i22 < domain_length; ++i22) {
                    Object branch = shadow_api.makeBranch();
                    if (range_select[0] == null || range_select[0].length == 1 || range_select[0][i22]) {
                        String[] te;
                        VisADGeometryArray array = null;
                        float[][] sp = new float[3][1];
                        if (spatial_values[0].length > 1) {
                            sp[0][0] = spatial_values[0][i22];
                            sp[1][0] = spatial_values[1][i22];
                            sp[2][0] = spatial_values[2][i22];
                        } else {
                            sp[0][0] = spatial_values[0][0];
                            sp[1][0] = spatial_values[1][0];
                            sp[2][0] = spatial_values[2][0];
                        }
                        byte[][] co = new byte[3][1];
                        if (color_values == null) {
                            co[0][0] = ShadowFunctionOrSetType.floatToByte(constant_color[0]);
                            co[1][0] = ShadowFunctionOrSetType.floatToByte(constant_color[1]);
                            co[2][0] = ShadowFunctionOrSetType.floatToByte(constant_color[2]);
                        } else if (color_values[0].length > 1) {
                            co[0][0] = color_values[0][i22];
                            co[1][0] = color_values[1][i22];
                            co[2][0] = color_values[2][i22];
                        } else {
                            co[0][0] = color_values[0][0];
                            co[1][0] = color_values[1][0];
                            co[2][0] = color_values[2][0];
                        }
                        boolean[][] ra = new boolean[][]{{true}};
                        boolean anyShapeCreated = false;
                        VisADGeometryArray[] arrays = shadow_api.assembleShape(display_values, valueArrayLength, valueToMap, MapVector, valueToScalar, this.display, default_values, this.inherited_values, sp, co, ra, i22, shadow_api);
                        if (arrays != null) {
                            for (int j = 0; j < arrays.length; ++j) {
                                array = arrays[j];
                                shadow_api.addToGroup(branch, array, mode, constant_alpha, constant_color);
                                array = null;
                            }
                            anyShapeCreated = true;
                            arrays = null;
                        }
                        boolean anyTextCreated = false;
                        if (anyText && text_values != null && text_control != null && (array = shadow_api.makeText(te = new String[]{text_values.length > 1 ? text_values[i22] : text_values[0]}, text_control, sp, co, ra)) != null) {
                            shadow_api.addTextToGroup(branch, array, mode, constant_alpha, constant_color);
                            array = null;
                            anyTextCreated = true;
                        }
                        boolean anyFlowCreated = false;
                        if (anyFlow) {
                            int j;
                            if (flow1_values != null && flow1_values[0] != null) {
                                float[][] f1 = new float[3][1];
                                if (flow1_values[0].length > 1) {
                                    f1[0][0] = flow1_values[0][i22];
                                    f1[1][0] = flow1_values[1][i22];
                                    f1[2][0] = flow1_values[2][i22];
                                } else {
                                    f1[0][0] = flow1_values[0][0];
                                    f1[1][0] = flow1_values[1][0];
                                    f1[2][0] = flow1_values[2][0];
                                }
                                arrays = shadow_api.makeFlow(0, f1, flowScale[0], arrowScale[0], sp, co, ra);
                                if (arrays != null) {
                                    for (j = 0; j < arrays.length; ++j) {
                                        if (arrays[j] == null) continue;
                                        shadow_api.addToGroup(branch, arrays[j], mode, constant_alpha, constant_color);
                                        arrays[j] = null;
                                    }
                                }
                                anyFlowCreated = true;
                            }
                            if (flow2_values != null && flow2_values[0] != null) {
                                float[][] f2 = new float[3][1];
                                if (flow2_values[0].length > 1) {
                                    f2[0][0] = flow2_values[0][i22];
                                    f2[1][0] = flow2_values[1][i22];
                                    f2[2][0] = flow2_values[2][i22];
                                } else {
                                    f2[0][0] = flow2_values[0][0];
                                    f2[1][0] = flow2_values[1][0];
                                    f2[2][0] = flow2_values[2][0];
                                }
                                arrays = shadow_api.makeFlow(1, f2, flowScale[1], arrowScale[1], sp, co, ra);
                                if (arrays != null) {
                                    for (j = 0; j < arrays.length; ++j) {
                                        if (arrays[j] == null) continue;
                                        shadow_api.addToGroup(branch, arrays[j], mode, constant_alpha, constant_color);
                                        arrays[j] = null;
                                    }
                                }
                                anyFlowCreated = true;
                            }
                        }
                        if (!(anyShapeCreated || anyTextCreated || anyFlowCreated)) {
                            array = new VisADPointArray();
                            array.vertexCount = 1;
                            coordinates = new float[]{sp[0][0], sp[1][0], sp[2][0]};
                            array.coordinates = coordinates;
                            if (color_values != null) {
                                colors = new byte[]{co[0][0], co[1][0], co[2][0]};
                                array.colors = colors;
                            }
                            shadow_api.addToGroup(branch, array, mode, constant_alpha, constant_color);
                            array = null;
                        }
                    }
                    shadow_api.addToSwitch(swit, branch);
                }
                shadow_api.addSwitch(group, swit, control, domain_set, renderer);
                return false;
            }
            throw new UnimplementedException("terminal LEGAL unimplemented: ShadowFunctionOrSetType.doTransform");
        }
        boolean post = false;
        Control control = null;
        Object swit = null;
        int index = -1;
        if (DomainComponents.length == 1) {
            RealType real = (RealType)DomainComponents[0].getType();
            for (int i = 0; i < valueArrayLength; ++i) {
                int displayScalarIndex;
                DisplayRealType dreal;
                ScalarMap map = (ScalarMap)MapVector.elementAt(valueToMap[i]);
                float[] values = display_values[i];
                if (values == null || !real.equals(map.getScalar()) || !(dreal = this.display.getDisplayScalar(displayScalarIndex = valueToScalar[i])).equals(Display.Animation) && !dreal.equals(Display.SelectValue)) continue;
                swit = shadow_api.makeSwitch();
                index = i;
                control = map.getControl();
                break;
            }
        }
        if (control != null) {
            shadow_api.addSwitch(group, swit, control, domain_set, renderer);
        }
        float[] range_value_array = new float[valueArrayLength];
        for (int j = 0; j < this.display.getValueArrayLength(); ++j) {
            range_value_array[j] = Float.NaN;
        }
        for (int i = 0; i < domain_length; ++i) {
            if (range_select[0] == null || range_select[0].length == 1 || range_select[0][i]) {
                Object branch;
                if (text_values != null && text_control != null) {
                    shadow_api.setText(text_values[i], text_control);
                } else {
                    shadow_api.setText(null, null);
                }
                for (int j = 0; j < valueArrayLength; ++j) {
                    if (display_values[j] == null) continue;
                    range_value_array[j] = display_values[j].length == 1 ? display_values[j][0] : display_values[j][i];
                }
                int[] lat_lon_indices = renderer.getLatLonIndices();
                if (control != null) {
                    branch = shadow_api.makeBranch();
                    post |= shadow_api.recurseRange(branch, ((Field)data).getSample(i), range_value_array, default_values, renderer);
                    shadow_api.addToSwitch(swit, branch);
                } else {
                    branch = shadow_api.makeBranch();
                    post |= shadow_api.recurseRange(branch, ((Field)data).getSample(i), range_value_array, default_values, renderer);
                    shadow_api.addToGroup(group, branch);
                }
                renderer.setLatLonIndices(lat_lon_indices);
                continue;
            }
            if (control == null) continue;
            Object branch = shadow_api.makeBranch();
            shadow_api.addToSwitch(swit, branch);
        }
        return post;
    }

    public BufferedImage createImage(int data_width, int data_height, int texture_width, int texture_height, byte[][] color_values) throws VisADException {
        return this.createImage(data_width, data_height, texture_width, texture_height, color_values, false);
    }

    public BufferedImage createImage(int data_width, int data_height, int texture_width, int texture_height, byte[][] color_values, boolean byRef) throws VisADException {
        BufferedImage image = null;
        if (color_values.length > 3) {
            if (!byReference) {
                int i;
                int j;
                ColorModel colorModel = ColorModel.getRGBdefault();
                WritableRaster raster = colorModel.createCompatibleWritableRaster(texture_width, texture_height);
                DataBuffer db = raster.getDataBuffer();
                if (!(db instanceof DataBufferInt)) {
                    throw new UnimplementedException("getRGBdefault isn't DataBufferInt");
                }
                image = new BufferedImage(colorModel, raster, false, null);
                int[] intData = ((DataBufferInt)db).getData();
                int k = 0;
                int m = 0;
                for (j = 0; j < data_height; ++j) {
                    for (i = 0; i < data_width; ++i) {
                        int r = color_values[0][k] < 0 ? color_values[0][k] + 256 : color_values[0][k];
                        int g = color_values[1][k] < 0 ? color_values[1][k] + 256 : color_values[1][k];
                        int b = color_values[2][k] < 0 ? color_values[2][k] + 256 : color_values[2][k];
                        int a = color_values[3][k] < 0 ? color_values[3][k] + 256 : color_values[3][k];
                        intData[m++] = a << 24 | r << 16 | g << 8 | b;
                        ++k;
                    }
                    for (i = data_width; i < texture_width; ++i) {
                        intData[m++] = 0;
                    }
                }
                for (j = data_height; j < texture_height; ++j) {
                    for (i = 0; i < texture_width; ++i) {
                        intData[m++] = 0;
                    }
                }
            } else {
                int i;
                int j;
                image = new BufferedImage(texture_width, texture_height, 6);
                WritableRaster raster = image.getRaster();
                DataBuffer db = raster.getDataBuffer();
                byte[] byteData = ((DataBufferByte)db).getData();
                int k = 0;
                int m = 0;
                for (j = 0; j < data_height; ++j) {
                    for (i = 0; i < data_width; ++i) {
                        byte r = color_values[0][k];
                        byte g = color_values[1][k];
                        byte b = color_values[2][k];
                        byte a = color_values[3][k];
                        byteData[m++] = a;
                        byteData[m++] = b;
                        byteData[m++] = g;
                        byteData[m++] = r;
                        ++k;
                    }
                    for (i = data_width; i < texture_width; ++i) {
                        byteData[m++] = 0;
                        byteData[m++] = 0;
                        byteData[m++] = 0;
                        byteData[m++] = 0;
                    }
                }
                for (j = data_height; j < texture_height; ++j) {
                    for (i = 0; i < texture_width; ++i) {
                        byteData[m++] = 0;
                        byteData[m++] = 0;
                        byteData[m++] = 0;
                        byteData[m++] = 0;
                    }
                }
            }
        } else {
            int i;
            int j;
            ColorModel colorModel = ColorModel.getRGBdefault();
            WritableRaster raster = colorModel.createCompatibleWritableRaster(texture_width, texture_height);
            DataBuffer db = raster.getDataBuffer();
            int[] intData = null;
            if (db instanceof DataBufferInt) {
                intData = ((DataBufferInt)db).getData();
                image = new BufferedImage(colorModel, raster, false, null);
            } else {
                image = new BufferedImage(texture_width, texture_height, 1);
                intData = new int[texture_width * texture_height];
            }
            int k = 0;
            int m = 0;
            for (j = 0; j < data_height; ++j) {
                for (i = 0; i < data_width; ++i) {
                    int r = color_values[0][k] < 0 ? color_values[0][k] + 256 : color_values[0][k];
                    int g = color_values[1][k] < 0 ? color_values[1][k] + 256 : color_values[1][k];
                    int b = color_values[2][k] < 0 ? color_values[2][k] + 256 : color_values[2][k];
                    int a = 255;
                    intData[m++] = a << 24 | r << 16 | g << 8 | b;
                    ++k;
                }
                for (i = data_width; i < texture_width; ++i) {
                    intData[m++] = 0;
                }
            }
            for (j = data_height; j < texture_height; ++j) {
                for (i = 0; i < texture_width; ++i) {
                    intData[m++] = 0;
                }
            }
            if (!(db instanceof DataBufferInt)) {
                System.out.println("byteData 3 2");
                image.setRGB(0, 0, texture_width, texture_height, intData, 0, texture_width);
            }
        }
        return image;
    }

    public BufferedImage[] createImages(int axis, int data_width_in, int data_height_in, int data_depth_in, int texture_width_in, int texture_height_in, int texture_depth_in, byte[][] color_values) throws VisADException {
        int[] intData;
        DataBuffer db;
        WritableRaster raster;
        ColorModel colorModel;
        int d;
        int texture_depth;
        int texture_height;
        int texture_width;
        int data_depth;
        int data_height;
        int data_width;
        int kdepth;
        int kheight;
        int kwidth;
        if (axis == 2) {
            kwidth = 1;
            kheight = data_width_in;
            kdepth = data_width_in * data_height_in;
            data_width = data_width_in;
            data_height = data_height_in;
            data_depth = data_depth_in;
            texture_width = texture_width_in;
            texture_height = texture_height_in;
            texture_depth = texture_depth_in;
        } else if (axis == 1) {
            kwidth = 1;
            kdepth = data_width_in;
            kheight = data_width_in * data_height_in;
            data_width = data_width_in;
            data_depth = data_height_in;
            data_height = data_depth_in;
            texture_width = texture_width_in;
            texture_depth = texture_height_in;
            texture_height = texture_depth_in;
        } else if (axis == 0) {
            kdepth = 1;
            kwidth = data_width_in;
            kheight = data_width_in * data_height_in;
            data_depth = data_width_in;
            data_width = data_height_in;
            data_height = data_depth_in;
            texture_depth = texture_width_in;
            texture_width = texture_height_in;
            texture_height = texture_depth_in;
        } else {
            return null;
        }
        BufferedImage[] images = new BufferedImage[texture_depth];
        for (d = 0; d < data_depth; ++d) {
            int i;
            int a;
            int b;
            int g;
            int r;
            int i2;
            int k;
            int j;
            int m;
            int kk;
            if (color_values.length > 3) {
                colorModel = ColorModel.getRGBdefault();
                raster = colorModel.createCompatibleWritableRaster(texture_width, texture_height);
                images[d] = new BufferedImage(colorModel, raster, false, null);
                db = raster.getDataBuffer();
                if (!(db instanceof DataBufferInt)) {
                    throw new UnimplementedException("getRGBdefault isn't DataBufferInt");
                }
                intData = ((DataBufferInt)db).getData();
                kk = d * kdepth;
                m = 0;
                for (j = 0; j < data_height; ++j) {
                    k = kk + j * kheight;
                    for (i2 = 0; i2 < data_width; ++i2) {
                        r = color_values[0][k] < 0 ? color_values[0][k] + 256 : color_values[0][k];
                        g = color_values[1][k] < 0 ? color_values[1][k] + 256 : color_values[1][k];
                        b = color_values[2][k] < 0 ? color_values[2][k] + 256 : color_values[2][k];
                        a = color_values[3][k] < 0 ? color_values[3][k] + 256 : color_values[3][k];
                        intData[m++] = a << 24 | r << 16 | g << 8 | b;
                        k += kwidth;
                    }
                    for (i2 = data_width; i2 < texture_width; ++i2) {
                        intData[m++] = 0;
                    }
                }
                for (j = data_height; j < texture_height; ++j) {
                    for (i = 0; i < texture_width; ++i) {
                        intData[m++] = 0;
                    }
                }
                continue;
            }
            colorModel = ColorModel.getRGBdefault();
            raster = colorModel.createCompatibleWritableRaster(texture_width, texture_height);
            images[d] = new BufferedImage(colorModel, raster, false, null);
            db = raster.getDataBuffer();
            if (!(db instanceof DataBufferInt)) {
                throw new UnimplementedException("getRGBdefault isn't DataBufferInt");
            }
            intData = ((DataBufferInt)db).getData();
            kk = d * kdepth;
            m = 0;
            for (j = 0; j < data_height; ++j) {
                k = kk + j * kheight;
                for (i2 = 0; i2 < data_width; ++i2) {
                    r = color_values[0][k] < 0 ? color_values[0][k] + 256 : color_values[0][k];
                    g = color_values[1][k] < 0 ? color_values[1][k] + 256 : color_values[1][k];
                    b = color_values[2][k] < 0 ? color_values[2][k] + 256 : color_values[2][k];
                    a = 255;
                    intData[m++] = a << 24 | r << 16 | g << 8 | b;
                    k += kwidth;
                }
                for (i2 = data_width; i2 < texture_width; ++i2) {
                    intData[m++] = 0;
                }
            }
            for (j = data_height; j < texture_height; ++j) {
                for (i = 0; i < texture_width; ++i) {
                    intData[m++] = 0;
                }
            }
        }
        for (d = data_depth; d < texture_depth; ++d) {
            colorModel = ColorModel.getRGBdefault();
            raster = colorModel.createCompatibleWritableRaster(texture_width, texture_height);
            images[d] = new BufferedImage(colorModel, raster, false, null);
            db = raster.getDataBuffer();
            if (!(db instanceof DataBufferInt)) {
                throw new UnimplementedException("getRGBdefault isn't DataBufferInt");
            }
            intData = ((DataBufferInt)db).getData();
            for (int i = 0; i < texture_width * texture_height; ++i) {
                intData[i] = 0;
            }
        }
        return images;
    }

    public VisADQuadArray reverse(VisADQuadArray array) {
        int count;
        VisADQuadArray qarray = new VisADQuadArray();
        qarray.coordinates = new float[array.coordinates.length];
        qarray.texCoords = new float[array.texCoords.length];
        qarray.colors = new byte[array.colors.length];
        qarray.normals = new float[array.normals.length];
        qarray.vertexCount = count = array.vertexCount;
        int color_length = array.colors.length / count;
        int tex_length = array.texCoords.length / count;
        int i3 = 0;
        int k3 = 3 * (count - 1);
        int ic = 0;
        int kc = color_length * (count - 1);
        int it = 0;
        int kt = tex_length * (count - 1);
        for (int i = 0; i < count; ++i) {
            qarray.coordinates[i3] = array.coordinates[k3];
            qarray.coordinates[i3 + 1] = array.coordinates[k3 + 1];
            qarray.coordinates[i3 + 2] = array.coordinates[k3 + 2];
            qarray.texCoords[it] = array.texCoords[kt];
            qarray.texCoords[it + 1] = array.texCoords[kt + 1];
            if (tex_length == 3) {
                qarray.texCoords[it + 2] = array.texCoords[kt + 2];
            }
            qarray.normals[i3] = array.normals[k3];
            qarray.normals[i3 + 1] = array.normals[k3 + 1];
            qarray.normals[i3 + 2] = array.normals[k3 + 2];
            qarray.colors[ic] = array.colors[kc];
            qarray.colors[ic + 1] = array.colors[kc + 1];
            qarray.colors[ic + 2] = array.colors[kc + 2];
            if (color_length == 4) {
                qarray.colors[ic + 3] = array.colors[kc + 3];
            }
            i3 += 3;
            k3 -= 3;
            ic += color_length;
            kc -= color_length;
            it += tex_length;
            kt -= tex_length;
        }
        return qarray;
    }

    private void buildLinearTexture(Object group, Set domain_set, Unit[] dataUnits, Unit[] domain_units, float[] default_values, ShadowType shadow_api, int valueArrayLength, int[] valueToScalar, float[] value_array, byte[][] color_values, GraphicsModeControl mode, float[] constant_color, float constant_alpha) throws VisADException {
        float[] coordinates = null;
        float[] texCoords = null;
        float[] normals = null;
        byte[] colors = null;
        int data_width = 0;
        int data_height = 0;
        boolean data_depth = false;
        int texture_width = 1;
        int texture_height = 1;
        boolean texture_depth = true;
        Linear1DSet X = null;
        Linear1DSet Y = null;
        if (domain_set instanceof Linear2DSet) {
            X = ((Linear2DSet)domain_set).getX();
            Y = ((Linear2DSet)domain_set).getY();
        } else {
            X = ((LinearNDSet)domain_set).getLinear1DComponent(0);
            Y = ((LinearNDSet)domain_set).getLinear1DComponent(1);
        }
        float[][] limits = new float[2][2];
        limits[0][0] = (float)X.getFirst();
        limits[0][1] = (float)X.getLast();
        limits[1][0] = (float)Y.getFirst();
        limits[1][1] = (float)Y.getLast();
        data_width = X.getLength();
        data_height = Y.getLength();
        texture_width = shadow_api.textureWidth(data_width);
        texture_height = shadow_api.textureHeight(data_height);
        float half_width = 0.5f / (float)(data_width - 1);
        float half_height = 0.5f / (float)(data_height - 1);
        half_width = (limits[0][1] - limits[0][0]) * half_width;
        half_height = (limits[1][1] - limits[1][0]) * half_height;
        float[] fArray = limits[0];
        fArray[0] = fArray[0] - half_width;
        float[] fArray2 = limits[0];
        fArray2[1] = fArray2[1] + half_width;
        float[] fArray3 = limits[1];
        fArray3[0] = fArray3[0] - half_height;
        float[] fArray4 = limits[1];
        fArray4[1] = fArray4[1] + half_height;
        limits = Unit.convertTuple(limits, dataUnits, domain_units);
        int[] tuple_index = new int[3];
        if (this.DomainComponents.length != 2) {
            throw new DisplayException("texture domain dimension != 2:ShadowFunctionOrSetType.doTransform");
        }
        block0: for (int i = 0; i < this.DomainComponents.length; ++i) {
            Enumeration maps = this.DomainComponents[i].getSelectedMapVector().elements();
            while (maps.hasMoreElements()) {
                ScalarMap map = (ScalarMap)maps.nextElement();
                DisplayRealType real = map.getDisplayScalar();
                DisplayTupleType tuple = real.getTuple();
                if (!Display.DisplaySpatialCartesianTuple.equals(tuple)) continue;
                limits[i] = map.scaleValues(limits[i]);
                tuple_index[i] = real.getTupleIndex();
                continue block0;
            }
        }
        tuple_index[2] = 3 - (tuple_index[0] + tuple_index[1]);
        DisplayRealType real = (DisplayRealType)Display.DisplaySpatialCartesianTuple.getComponent(tuple_index[2]);
        int value2_index = this.display.getDisplayScalarIndex(real);
        float value2 = default_values[value2_index];
        for (int i = 0; i < valueArrayLength; ++i) {
            if (this.inherited_values[i] <= 0 || !real.equals(this.display.getDisplayScalar(valueToScalar[i]))) continue;
            value2 = value_array[i];
            break;
        }
        coordinates = new float[12];
        coordinates[tuple_index[0]] = limits[0][0];
        coordinates[tuple_index[1]] = limits[1][0];
        coordinates[tuple_index[2]] = value2;
        coordinates[3 + tuple_index[0]] = limits[0][1];
        coordinates[3 + tuple_index[1]] = limits[1][0];
        coordinates[3 + tuple_index[2]] = value2;
        coordinates[6 + tuple_index[0]] = limits[0][1];
        coordinates[6 + tuple_index[1]] = limits[1][1];
        coordinates[6 + tuple_index[2]] = value2;
        coordinates[9 + tuple_index[0]] = limits[0][0];
        coordinates[9 + tuple_index[1]] = limits[1][1];
        coordinates[9 + tuple_index[2]] = value2;
        shadow_api.adjustZ(coordinates);
        texCoords = new float[8];
        float ratiow = (float)data_width / (float)texture_width;
        float ratioh = (float)data_height / (float)texture_height;
        shadow_api.setTexCoords(texCoords, ratiow, ratioh);
        normals = new float[12];
        float n0 = (coordinates[5] - coordinates[2]) * (coordinates[7] - coordinates[1]) - (coordinates[4] - coordinates[1]) * (coordinates[8] - coordinates[2]);
        float n1 = (coordinates[3] - coordinates[0]) * (coordinates[8] - coordinates[2]) - (coordinates[5] - coordinates[2]) * (coordinates[6] - coordinates[0]);
        float n2 = (coordinates[4] - coordinates[1]) * (coordinates[6] - coordinates[0]) - (coordinates[3] - coordinates[0]) * (coordinates[7] - coordinates[1]);
        float nlen = (float)Math.sqrt(n0 * n0 + n1 * n1 + n2 * n2);
        normals[0] = n0 /= nlen;
        normals[1] = n1 /= nlen;
        normals[2] = n2 /= nlen;
        normals[3] = n0;
        normals[4] = n1;
        normals[5] = n2;
        normals[6] = n0;
        normals[7] = n1;
        normals[8] = n2;
        normals[9] = n0;
        normals[10] = n1;
        normals[11] = n2;
        colors = new byte[12];
        for (int i = 0; i < 12; ++i) {
            colors[i] = 127;
        }
        VisADQuadArray qarray = new VisADQuadArray();
        qarray.vertexCount = 4;
        qarray.coordinates = coordinates;
        qarray.texCoords = texCoords;
        qarray.colors = colors;
        qarray.normals = normals;
        BufferedImage image = this.createImage(data_width, data_height, texture_width, texture_height, color_values);
        shadow_api.textureToGroup(group, qarray, image, mode, constant_alpha, constant_color, texture_width, texture_height);
    }

    private void buildCurvedTexture(Object group, Set domain_set, Unit[] dataUnits, Unit[] domain_units, float[] default_values, ShadowType shadow_api, int valueArrayLength, int[] valueToScalar, float[] value_array, byte[][] color_values, GraphicsModeControl mode, float[] constant_color, float constant_alpha, int curved_size, float[][] spatial_values, boolean spatial_all_select, DataRenderer renderer, boolean[][] range_select, boolean domainOnlySpatial, int[] start, int lenX, int lenY, int bigX, int bigY) throws VisADException {
        int len;
        int i;
        int ij;
        int i2;
        int j;
        int i3;
        float[] coordinates = null;
        float[] texCoords = null;
        float[] normals = null;
        byte[] colors = null;
        int data_width = 0;
        int data_height = 0;
        int texture_width = 1;
        int texture_height = 1;
        int[] lengths = null;
        lengths = domain_set != null ? ((GriddedSet)domain_set).getLengths() : new int[]{lenX, lenY};
        data_width = lengths[0];
        data_height = lengths[1];
        texture_width = shadow_api.textureWidth(data_width);
        texture_height = shadow_api.textureHeight(data_height);
        int size = (data_width + data_height) / 2;
        curved_size = Math.max(2, Math.min(curved_size, size / 32));
        int nwidth = 2 + (data_width - 1) / curved_size;
        int nheight = 2 + (data_height - 1) / curved_size;
        if (range_select[0] != null && !domainOnlySpatial) {
            curved_size = 1;
            nwidth = data_width;
            nheight = data_height;
        }
        int nn = nwidth * nheight;
        coordinates = new float[3 * nn];
        int k = 0;
        int[] is = new int[nwidth];
        int[] js = new int[nheight];
        for (i3 = 0; i3 < nwidth; ++i3) {
            is[i3] = Math.min(i3 * curved_size, data_width - 1);
        }
        for (j = 0; j < nheight; ++j) {
            js[j] = Math.min(j * curved_size, data_height - 1);
        }
        if (start == null) {
            for (j = 0; j < nheight; ++j) {
                for (i2 = 0; i2 < nwidth; ++i2) {
                    ij = is[i2] + data_width * js[j];
                    coordinates[k++] = spatial_values[0][ij];
                    coordinates[k++] = spatial_values[1][ij];
                    coordinates[k++] = spatial_values[2][ij];
                }
            }
        } else {
            for (j = 0; j < nheight; ++j) {
                for (i2 = 0; i2 < nwidth; ++i2) {
                    ij = is[i2] + data_width * js[j];
                    int x = ij % lenX;
                    int y = ij / lenX;
                    ij = start[0] + x + (start[1] + y) * bigX;
                    coordinates[k++] = spatial_values[0][ij];
                    coordinates[k++] = spatial_values[1][ij];
                    coordinates[k++] = spatial_values[2][ij];
                }
            }
        }
        normals = Gridded3DSet.makeNormals(coordinates, nwidth, nheight);
        colors = new byte[3 * nn];
        for (i3 = 0; i3 < 3 * nn; ++i3) {
            colors[i3] = 127;
        }
        float ratiow = (float)data_width / (float)texture_width;
        float ratioh = (float)data_height / (float)texture_height;
        float half_width = 0.5f / (float)texture_width;
        float half_height = 0.5f / (float)texture_height;
        float width = 1.0f / (float)texture_width;
        float height = 1.0f / (float)texture_height;
        int mt = 0;
        texCoords = new float[2 * nn];
        for (int j2 = 0; j2 < nheight; ++j2) {
            for (i = 0; i < nwidth; ++i) {
                float isfactor = (float)is[i] / ((float)data_width - 1.0f);
                float jsfactor = (float)js[j2] / ((float)data_height - 1.0f);
                texCoords[mt++] = (ratiow - width) * isfactor + half_width;
                texCoords[mt++] = 1.0f - (ratioh - height) * jsfactor - half_height;
            }
        }
        VisADTriangleStripArray tarray = new VisADTriangleStripArray();
        tarray.stripVertexCounts = new int[nheight - 1];
        for (i = 0; i < nheight - 1; ++i) {
            tarray.stripVertexCounts[i] = 2 * nwidth;
        }
        tarray.vertexCount = len = (nheight - 1) * (2 * nwidth);
        tarray.normals = new float[3 * len];
        tarray.coordinates = new float[3 * len];
        tarray.colors = new byte[3 * len];
        tarray.texCoords = new float[2 * len];
        k = 0;
        int kt = 0;
        int nwidth3 = 3 * nwidth;
        int nwidth2 = 2 * nwidth;
        for (int i4 = 0; i4 < nheight - 1; ++i4) {
            int m = i4 * nwidth3;
            mt = i4 * nwidth2;
            for (int j3 = 0; j3 < nwidth; ++j3) {
                tarray.coordinates[k] = coordinates[m];
                tarray.coordinates[k + 1] = coordinates[m + 1];
                tarray.coordinates[k + 2] = coordinates[m + 2];
                tarray.coordinates[k + 3] = coordinates[m + nwidth3];
                tarray.coordinates[k + 4] = coordinates[m + nwidth3 + 1];
                tarray.coordinates[k + 5] = coordinates[m + nwidth3 + 2];
                tarray.normals[k] = normals[m];
                tarray.normals[k + 1] = normals[m + 1];
                tarray.normals[k + 2] = normals[m + 2];
                tarray.normals[k + 3] = normals[m + nwidth3];
                tarray.normals[k + 4] = normals[m + nwidth3 + 1];
                tarray.normals[k + 5] = normals[m + nwidth3 + 2];
                tarray.colors[k] = colors[m];
                tarray.colors[k + 1] = colors[m + 1];
                tarray.colors[k + 2] = colors[m + 2];
                tarray.colors[k + 3] = colors[m + nwidth3];
                tarray.colors[k + 4] = colors[m + nwidth3 + 1];
                tarray.colors[k + 5] = colors[m + nwidth3 + 2];
                tarray.texCoords[kt] = texCoords[mt];
                tarray.texCoords[kt + 1] = texCoords[mt + 1];
                tarray.texCoords[kt + 2] = texCoords[mt + nwidth2];
                tarray.texCoords[kt + 3] = texCoords[mt + nwidth2 + 1];
                k += 6;
                m += 3;
                kt += 4;
                mt += 2;
            }
        }
        if (!spatial_all_select) {
            tarray = (VisADTriangleStripArray)tarray.removeMissing();
        }
        if (this.getAdjustProjectionSeam()) {
            tarray = (VisADTriangleStripArray)tarray.adjustLongitude(renderer);
            tarray = (VisADTriangleStripArray)tarray.adjustSeam(renderer);
        }
        BufferedImage image = this.createImage(data_width, data_height, texture_width, texture_height, color_values);
        shadow_api.textureToGroup(group, tarray, image, mode, constant_alpha, constant_color, texture_width, texture_height);
    }
}

