/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;

public class FlowSphericalCoordinateSystem
extends CoordinateSystem {
    private static Unit[] coordinate_system_units = new Unit[]{CommonUnit.degree, CommonUnit.degree, CommonUnit.meterPerSecond};

    public FlowSphericalCoordinateSystem(RealTupleType reference) throws VisADException {
        super(reference, coordinate_system_units);
    }

    FlowSphericalCoordinateSystem(RealTupleType reference, boolean b) {
        super(reference, coordinate_system_units, b);
    }

    @Override
    public double[][] toReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("FlowSphericalCoordinateSystem.toReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        double[][] value = new double[3][len];
        for (int i = 0; i < len; ++i) {
            if (tuples[2][i] < 0.0) {
                value[0][i] = Double.NaN;
                value[1][i] = Double.NaN;
                value[2][i] = Double.NaN;
                continue;
            }
            double coslat = Math.cos(Math.PI / 180 * tuples[0][i]);
            double sinlat = Math.sin(Math.PI / 180 * tuples[0][i]);
            double coslon = Math.cos(Math.PI / 180 * tuples[1][i]);
            double sinlon = Math.sin(Math.PI / 180 * tuples[1][i]);
            value[0][i] = -tuples[2][i] * sinlon * coslat;
            value[1][i] = -tuples[2][i] * coslon * coslat;
            value[2][i] = -tuples[2][i] * sinlat;
        }
        return value;
    }

    @Override
    public double[][] fromReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("FlowSphericalCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        double[][] value = new double[3][len];
        for (int i = 0; i < len; ++i) {
            value[2][i] = Math.sqrt(tuples[0][i] * tuples[0][i] + tuples[1][i] * tuples[1][i] + tuples[2][i] * tuples[2][i]);
            value[0][i] = 57.29577951308232 * Math.asin(-tuples[2][i] / value[2][i]);
            value[1][i] = 57.29577951308232 * Math.atan2(-tuples[0][i], -tuples[1][i]);
            if (!(value[1][i] < 0.0)) continue;
            double[] dArray = value[1];
            int n = i;
            dArray[n] = dArray[n] + 360.0;
        }
        return value;
    }

    @Override
    public float[][] toReference(float[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("FlowSphericalCoordinateSystem.toReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        float[][] value = new float[3][len];
        for (int i = 0; i < len; ++i) {
            if ((double)tuples[2][i] < 0.0) {
                value[0][i] = Float.NaN;
                value[1][i] = Float.NaN;
                value[2][i] = Float.NaN;
                continue;
            }
            float coslat = (float)Math.cos(Math.PI / 180 * (double)tuples[0][i]);
            float sinlat = (float)Math.sin(Math.PI / 180 * (double)tuples[0][i]);
            float coslon = (float)Math.cos(Math.PI / 180 * (double)tuples[1][i]);
            float sinlon = (float)Math.sin(Math.PI / 180 * (double)tuples[1][i]);
            value[0][i] = -tuples[2][i] * sinlon * coslat;
            value[1][i] = -tuples[2][i] * coslon * coslat;
            value[2][i] = -tuples[2][i] * sinlat;
        }
        return value;
    }

    @Override
    public float[][] fromReference(float[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("FlowSphericalCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        float[][] value = new float[3][len];
        for (int i = 0; i < len; ++i) {
            value[2][i] = (float)Math.sqrt(tuples[0][i] * tuples[0][i] + tuples[1][i] * tuples[1][i] + tuples[2][i] * tuples[2][i]);
            value[0][i] = (float)(57.29577951308232 * Math.asin(-tuples[2][i] / value[2][i]));
            value[1][i] = (float)(57.29577951308232 * Math.atan2(-tuples[0][i], -tuples[1][i]));
            if (!(value[1][i] < 0.0f)) continue;
            float[] fArray = value[1];
            int n = i;
            fArray[n] = fArray[n] + 360.0f;
        }
        return value;
    }

    @Override
    public boolean equals(Object cs) {
        return cs instanceof FlowSphericalCoordinateSystem;
    }
}

