/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.McIDASUtil;

public final class MSATnav
extends AREAnav {
    private boolean isEastPositive = true;
    final double NOMORB = 42164.0;
    final double EARTH_RADIUS = 6378.155;
    int itype;
    double h;
    double a;
    double rp;
    double lpsi2;
    double deltax;
    double deltay;
    double rflon;
    double sublon;
    int[] ioff = new int[3];

    public MSATnav(int[] iparms) throws IllegalArgumentException {
        if (iparms[0] != 1297301844) {
            throw new IllegalArgumentException("Invalid navigation type" + iparms[0]);
        }
        this.itype = 2;
        System.arraycopy(iparms, 3, this.ioff, 0, 3);
        this.h = 35785.845;
        this.a = 0.003367003367003367;
        this.rp = 6378.155 / (1.0 + this.a);
        this.lpsi2 = 1.0;
        this.deltax = 0.0072;
        this.deltay = 0.0072;
        this.rflon = 0.0;
        this.sublon = McIDASUtil.integerLatLonToDouble(iparms[6]);
    }

    @Override
    public double[][] toLatLon(double[][] linele) {
        int number = linele[0].length;
        double[][] latlon = new double[2][number];
        double[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double yk;
            double tany;
            double val2;
            double xlin = imglinele[1][point];
            double xele = imglinele[0][point];
            double xele2 = xele / 2.0;
            double xlin2 = xlin / 2.0;
            double x = 1250.5 - xele2;
            double y = (double)this.ioff[2] - (xlin2 + (double)this.ioff[1] - (double)this.ioff[0]);
            double xr = x;
            double yr = y;
            x = xr * this.lpsi2 * this.deltax * (Math.PI / 180);
            y = yr * this.lpsi2 * this.deltay * (Math.PI / 180);
            double rs = 6378.155 + this.h;
            double tanx = Math.tan(x);
            double val1 = 1.0 + tanx * tanx;
            if (val1 * (val2 = 1.0 + (tany = Math.tan(y)) * tany * ((1.0 + this.a) * (1.0 + this.a))) > (yk = rs / 6378.155) * yk / (yk * yk - 1.0)) {
                latlon[0][point] = Double.NaN;
                latlon[1][point] = Double.NaN;
                continue;
            }
            double vmu = (rs - 6378.155 * Math.sqrt(yk * yk - (yk * yk - 1.0) * val1 * val2)) / (val1 * val2);
            double cosrf = Math.cos(this.rflon * (Math.PI / 180));
            double sinrf = Math.sin(this.rflon * (Math.PI / 180));
            double xt = rs * cosrf + vmu * (tanx * sinrf - cosrf);
            double yt = rs * sinrf - vmu * (tanx * cosrf + sinrf);
            double zt = vmu * tany / Math.cos(x);
            double teta = Math.asin(zt / this.rp);
            double xfi = Math.atan(Math.tan(teta) * 6378.155 / this.rp) * 57.29577951308232;
            double xla = -Math.atan(yt / xt) * 57.29577951308232;
            xla += this.sublon;
            if (this.isEastPositive) {
                xla = -xla;
            }
            latlon[0][point] = xfi;
            latlon[1][point] = xla;
        }
        return latlon;
    }

    @Override
    public double[][] toLinEle(double[][] latlon) {
        int number = latlon[0].length;
        double[][] linele = new double[2][number];
        for (int point = 0; point < number; ++point) {
            double r2;
            double y;
            double y1;
            double x1 = latlon[0][point];
            double d = y1 = this.isEastPositive ? latlon[1][point] : -latlon[1][point];
            if (this.itype == 1) {
                y = latlon[1][point];
                y1 = -y1;
            }
            double xfi = x1 * (Math.PI / 180);
            double xla = (y1 += this.sublon) * (Math.PI / 180);
            double rom = 6378.155 * this.rp / Math.sqrt(this.rp * this.rp * Math.cos(xfi) * Math.cos(xfi) + 4.0680861204025E7 * Math.sin(xfi) * Math.sin(xfi));
            y = Math.sqrt(this.h * this.h + rom * rom - 2.0 * this.h * rom * Math.cos(xfi) * Math.cos(xla));
            double r1 = y * y + rom * rom;
            if (r1 > (r2 = this.h * this.h)) {
                linele[1][point] = Double.NaN;
                linele[0][point] = Double.NaN;
                continue;
            }
            double rs = 6378.155 + this.h;
            double reph = 6378.155;
            double rpph = this.rp;
            double coslo = Math.cos(this.rflon * (Math.PI / 180));
            double sinlo = Math.sin(this.rflon * (Math.PI / 180));
            double teta = Math.atan(rpph / reph * Math.tan(xfi));
            double xt = reph * Math.cos(teta) * Math.cos(xla);
            double yt = reph * Math.cos(teta) * Math.sin(xla);
            double zt = rpph * Math.sin(teta);
            double px = Math.atan((coslo * (yt - rs * sinlo) - (xt - rs * coslo) * sinlo) / (sinlo * (yt - rs * sinlo) + (xt - rs * coslo) * coslo));
            double py = Math.atan(zt * ((Math.tan(px) * sinlo - coslo) / (xt - rs * coslo)) * Math.cos(px));
            double xr = (px *= 57.29577951308232) / (this.deltax * this.lpsi2);
            double yr = (py *= 57.29577951308232) / (this.deltay * this.lpsi2);
            xr = 1250.5 - xr;
            yr = yr + (double)this.ioff[2] + (double)this.ioff[1] - (double)this.ioff[0];
            linele[1][point] = yr = 5000.0 - yr * 2.0;
            linele[0][point] = xr *= 2.0;
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }

    @Override
    public float[][] toLatLon(float[][] linele) {
        int number = linele[0].length;
        float[][] latlon = new float[2][number];
        float[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double yk;
            double tany;
            double val2;
            double xlin = imglinele[1][point];
            double xele = imglinele[0][point];
            double xele2 = xele / 2.0;
            double xlin2 = xlin / 2.0;
            double x = 1250.5 - xele2;
            double y = (double)this.ioff[2] - (xlin2 + (double)this.ioff[1] - (double)this.ioff[0]);
            double xr = x;
            double yr = y;
            x = xr * this.lpsi2 * this.deltax * (Math.PI / 180);
            y = yr * this.lpsi2 * this.deltay * (Math.PI / 180);
            double rs = 6378.155 + this.h;
            double tanx = Math.tan(x);
            double val1 = 1.0 + tanx * tanx;
            if (val1 * (val2 = 1.0 + (tany = Math.tan(y)) * tany * ((1.0 + this.a) * (1.0 + this.a))) > (yk = rs / 6378.155) * yk / (yk * yk - 1.0)) {
                latlon[0][point] = Float.NaN;
                latlon[1][point] = Float.NaN;
                continue;
            }
            double vmu = (rs - 6378.155 * Math.sqrt(yk * yk - (yk * yk - 1.0) * val1 * val2)) / (val1 * val2);
            double cosrf = Math.cos(this.rflon * (Math.PI / 180));
            double sinrf = Math.sin(this.rflon * (Math.PI / 180));
            double xt = rs * cosrf + vmu * (tanx * sinrf - cosrf);
            double yt = rs * sinrf - vmu * (tanx * cosrf + sinrf);
            double zt = vmu * tany / Math.cos(x);
            double teta = Math.asin(zt / this.rp);
            double xfi = Math.atan(Math.tan(teta) * 6378.155 / this.rp) * 57.29577951308232;
            double xla = -Math.atan(yt / xt) * 57.29577951308232;
            xla += this.sublon;
            if (this.isEastPositive) {
                xla = -xla;
            }
            latlon[0][point] = (float)xfi;
            latlon[1][point] = (float)xla;
        }
        return latlon;
    }

    @Override
    public float[][] toLinEle(float[][] latlon) {
        int number = latlon[0].length;
        float[][] linele = new float[2][number];
        for (int point = 0; point < number; ++point) {
            double r2;
            double y;
            double y1;
            double x1 = latlon[0][point];
            double d = y1 = this.isEastPositive ? (double)latlon[1][point] : (double)(-latlon[1][point]);
            if (this.itype == 1) {
                y = latlon[1][point];
                y1 = -y1;
            }
            double xfi = x1 * (Math.PI / 180);
            double xla = (y1 += this.sublon) * (Math.PI / 180);
            double rom = 6378.155 * this.rp / Math.sqrt(this.rp * this.rp * Math.cos(xfi) * Math.cos(xfi) + 4.0680861204025E7 * Math.sin(xfi) * Math.sin(xfi));
            y = Math.sqrt(this.h * this.h + rom * rom - 2.0 * this.h * rom * Math.cos(xfi) * Math.cos(xla));
            double r1 = y * y + rom * rom;
            if (r1 > (r2 = this.h * this.h)) {
                linele[1][point] = Float.NaN;
                linele[0][point] = Float.NaN;
                continue;
            }
            double rs = 6378.155 + this.h;
            double reph = 6378.155;
            double rpph = this.rp;
            double coslo = Math.cos(this.rflon * (Math.PI / 180));
            double sinlo = Math.sin(this.rflon * (Math.PI / 180));
            double teta = Math.atan(rpph / reph * Math.tan(xfi));
            double xt = reph * Math.cos(teta) * Math.cos(xla);
            double yt = reph * Math.cos(teta) * Math.sin(xla);
            double zt = rpph * Math.sin(teta);
            double px = Math.atan((coslo * (yt - rs * sinlo) - (xt - rs * coslo) * sinlo) / (sinlo * (yt - rs * sinlo) + (xt - rs * coslo) * coslo));
            double py = Math.atan(zt * ((Math.tan(px) * sinlo - coslo) / (xt - rs * coslo)) * Math.cos(px));
            double xr = (px *= 57.29577951308232) / (this.deltax * this.lpsi2);
            double yr = (py *= 57.29577951308232) / (this.deltay * this.lpsi2);
            xr = 1250.5 - xr;
            yr = yr + (double)this.ioff[2] + (double)this.ioff[1] - (double)this.ioff[0];
            yr = 5000.0 - yr * 2.0;
            linele[1][point] = (float)yr;
            linele[0][point] = (float)(xr *= 2.0);
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }
}

