/*
 * Decompiled with CFR 0.152.
 */
package sharptools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Label;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import sharptools.NumberField;
import sharptools.SharpDialog;

public class SharpOptionPane {
    public static Object showInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) {
        return SharpOptionPane.showInputDialog(parentComponent, message, title, messageType, icon, selectionValues, initialSelectionValue, false);
    }

    public static Integer showIntegerInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object initialSelectionValue) {
        Object input = SharpOptionPane.showInputDialog(parentComponent, message, title, messageType, icon, null, initialSelectionValue, true);
        try {
            if (input != null) {
                return Integer.getInteger(input.toString());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    private static Object showInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue, boolean isInteger) {
        JComponent com;
        JPanel panel = new JPanel(new BorderLayout());
        if (selectionValues == null) {
            if (isInteger) {
                com = new NumberField(true, true);
                ((JTextField)com).setText(initialSelectionValue.toString());
            } else {
                com = new JTextField(initialSelectionValue.toString());
            }
            ((JTextField)com).selectAll();
        } else {
            JComboBox<Object> box = new JComboBox<Object>(selectionValues);
            if (initialSelectionValue != null) {
                box.setSelectedItem(initialSelectionValue);
            } else {
                box.setSelectedIndex(0);
            }
            com = box;
        }
        if (message instanceof Component) {
            panel.add((Component)message, "North");
        } else {
            panel.add((Component)new Label(message.toString()), "North");
        }
        panel.add((Component)com, "Center");
        int choice = SharpOptionPane.showOptionDialog(parentComponent, panel, title, 2, messageType, icon);
        if (choice == 0) {
            if (com instanceof JTextField) {
                return ((JTextField)com).getText();
            }
            return ((JComboBox)com).getSelectedItem();
        }
        return null;
    }

    public static void showMessageDialog(Component parentComponent, Object message) {
        SharpOptionPane.showMessageDialog(parentComponent, message, null, 0, null);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType) {
        SharpOptionPane.showMessageDialog(parentComponent, message, title, messageType, null);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType, Icon icon) {
        SharpOptionPane.showOptionDialog(parentComponent, message, title, -1, messageType, icon, 0);
    }

    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon) {
        return SharpOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, 0);
    }

    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, int defaultIndex) {
        SharpDialog dialog = parentComponent instanceof Frame ? new SharpDialog((Frame)parentComponent, title, true) : new SharpDialog((Dialog)parentComponent, title, true);
        dialog.setOptionPane(message, messageType, optionType, icon, defaultIndex);
        dialog.show();
        return dialog.getChoice();
    }
}

