/*
 * Decompiled with CFR 0.152.
 */
package sharptools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import sharptools.CellRange;
import sharptools.SharpTableModel;
import sharptools.SharpTools;
import sharptools.TabPanel;

public class Histogram
extends JFrame
implements ActionListener {
    private SharpTools sharp;
    private JTable table;
    private SharpTableModel model;
    private JTabbedPane tab;
    private int width;
    private int height;
    private String title;
    private Point location;
    private Dimension dim;
    private final ImageIcon histogramIcon = SharpTools.getImageIcon("chart.gif");

    Histogram(SharpTools sharp, String title, int width, int height) {
        super(title);
        this.setSize(width, height);
        this.sharp = sharp;
        this.table = sharp.getTable();
        this.model = sharp.getTableModel();
        this.title = title;
        this.width = width;
        this.height = height;
        this.tab = new JTabbedPane();
        this.table.registerKeyboardAction(this, "Show", KeyStroke.getKeyStroke(119, 0, false), 0);
        this.table.registerKeyboardAction(this, "Add", KeyStroke.getKeyStroke(72, 2, false), 0);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.tab, "Center");
        this.setDefaultCloseOperation(2);
    }

    private void bringToFront() {
        if (this.getState() == 1) {
            this.setState(0);
        }
        this.toFront();
    }

    @Override
    public void show() {
        super.show();
        this.sharp.checkShowHistogramState();
    }

    @Override
    public void hide() {
        super.hide();
        this.sharp.checkShowHistogramState();
    }

    public void add(String title, CellRange range) {
        this.bringToFront();
        if (!this.isVisible()) {
            this.show();
        }
        TabPanel newTab = new TabPanel(this.model, range, this, this.tab);
        this.tab.addTab(title, null, newTab, range.toString());
        this.tab.setSelectedIndex(this.tab.getTabCount() - 1);
        newTab.getOptions(true);
    }

    public void toggle() {
        if (this.isVisible()) {
            this.hide();
        } else if (this.hasChart()) {
            this.bringToFront();
            this.show();
        }
    }

    public void addHistogram() {
        if (this.table.getSelectedRowCount() != 0) {
            CellRange range = new CellRange(this.table.getSelectedRows(), this.table.getSelectedColumns());
            String title = "Chart " + (this.tab.getTabCount() + 1);
            this.add(title, range);
            this.sharp.checkShowHistogramState();
        } else {
            this.sharp.noCellsSelected("Histogram");
        }
    }

    public boolean hasChart() {
        return this.tab.getTabCount() > 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().compareTo("Show") == 0) {
            this.toggle();
        } else if (e.getActionCommand().compareTo("Add") == 0) {
            this.addHistogram();
        }
    }
}

