/*
 * Decompiled with CFR 0.152.
 */
package sharptools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.JTextField;
import sharptools.Formula;
import sharptools.Function;
import sharptools.SharpCellEditor;
import sharptools.SharpOptionPane;
import sharptools.SharpTools;

class FunctionListListener
implements ActionListener {
    JFrame frame;
    JTable table;
    private final ImageIcon helpIcon = SharpTools.getImageIcon("help32.gif");

    FunctionListListener(JFrame frame, JTable table) {
        this.frame = frame;
        this.table = table;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBox cb = (JComboBox)e.getSource();
        String funcName = (String)cb.getSelectedItem();
        try {
            if (this.table.isEditing()) {
                int row = this.table.getEditingRow();
                int col = this.table.getEditingRow();
                JTextField text = ((SharpCellEditor)this.table.getCellEditor(row, col)).getTextField();
                if (!funcName.equals("Functions")) {
                    text.replaceSelection(funcName + "()");
                    Function fh = Formula.getFuncHandler(funcName);
                    if (fh != null && fh.requireParams()) {
                        text.setCaretPosition(text.getCaretPosition() - 1);
                    }
                } else {
                    this.showGeneralFunctionHelp();
                }
                text.requestFocus();
            } else {
                Function fh = Formula.getFuncHandler(funcName);
                if (fh != null) {
                    String message = "<html><font size=2 color=black><b>" + fh.getUsage() + "</b><p><p>" + fh.getDescription() + "<p></font>";
                    SharpOptionPane.showMessageDialog(this.frame, message, "Function", 1, this.helpIcon);
                } else {
                    this.showGeneralFunctionHelp();
                }
                this.table.requestFocus();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        cb.setSelectedIndex(0);
    }

    private void showGeneralFunctionHelp() {
        String message = "<html><font size=2 color=black><b><font size=3>Functions</font></b><p><p>Functions are predefined formulas that perform calculations by<p>using specific values, called arguments, in a particular order,<p>or structure.<p><p><b>Arguments</b> Arguments can be numbers or cell references. A cell<p>reference can be a single cell or a range of cells.  A single cell can<p>use relative addressing (A1) or absolute addressing ($B$5).  A range<p>of cell is specified by a pair of diagonal cells (A1:C5, $A$1:$C$5).<p>Different functions may have different requirements on the number<p>or type of parameters.<p><p><b>Structure</b> The structure of a function begins with the function<p>name, followed by an opening parenthesis, the arguments for<p>the function separated by commas, and a closing parenthesis.<p>If the function starts a formula, type an equal sign (=) before<p>the function name.  As you are editing a formula that contains<p>a function, you can click on a function in this list to insert the<p>function name into the cell.<p><p><b>Examples:</b><p><p>=SUM(A10,B5:B10,50,37)<p>=AVERAGE($B$5:$B$10)/10</font>";
        SharpOptionPane.showMessageDialog(this.frame, message, "Function", 1, this.helpIcon);
    }
}

