/*
 * Decompiled with CFR 0.152.
 */
package sharptools;

import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import sharptools.Cell;
import sharptools.CellPoint;
import sharptools.CellRange;
import sharptools.Debug;
import sharptools.FindDialog;
import sharptools.History;
import sharptools.SharpOptionPane;
import sharptools.SharpTableModel;
import sharptools.SharpTools;

public class EditOp
implements ActionListener {
    private SharpTools sharp;
    private JTable table;
    private SharpTableModel tableModel;
    private History history;
    private JToolBar toolBar;
    private CellPoint copyPoint = new CellPoint(SharpTools.baseRow, SharpTools.baseCol);
    private Clipboard system;
    private String findValue;
    private boolean matchCase = false;
    private boolean matchCell = false;
    private static final ImageIcon fillIcon = SharpTools.getImageIcon("fill32.gif");
    private static final ImageIcon findIcon = SharpTools.getImageIcon("find32.gif");

    EditOp(SharpTools sharp) {
        this.sharp = sharp;
        this.table = sharp.getTable();
        KeyStroke undo = KeyStroke.getKeyStroke(90, 2, false);
        KeyStroke redo = KeyStroke.getKeyStroke(89, 2, false);
        KeyStroke cut = KeyStroke.getKeyStroke(88, 2, false);
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        KeyStroke paste = KeyStroke.getKeyStroke(86, 2, false);
        KeyStroke fill = KeyStroke.getKeyStroke(76, 2, false);
        KeyStroke clear = KeyStroke.getKeyStroke(127, 0, false);
        KeyStroke find = KeyStroke.getKeyStroke(70, 2, false);
        KeyStroke findnext = KeyStroke.getKeyStroke(114, 0, false);
        this.table.registerKeyboardAction(this, "Undo", undo, 0);
        this.table.registerKeyboardAction(this, "Redo", redo, 0);
        this.table.registerKeyboardAction(this, "Cut", cut, 0);
        this.table.registerKeyboardAction(this, "Copy", copy, 0);
        this.table.registerKeyboardAction(this, "Paste", paste, 0);
        this.table.registerKeyboardAction(this, "Fill", fill, 0);
        this.table.registerKeyboardAction(this, "Clear", clear, 0);
        this.table.registerKeyboardAction(this, "Find", find, 0);
        this.table.registerKeyboardAction(this, "Find Next", findnext, 0);
        this.init(sharp);
    }

    public void init(SharpTools sharp) {
        this.tableModel = sharp.getTableModel();
        this.history = sharp.getHistory();
    }

    public void cut() {
        this.doCopy(true);
    }

    public void copy() {
        this.doCopy(false);
    }

    private void doCopy(boolean isCut) {
        if (this.table.getSelectedRowCount() != 0) {
            CellRange range = new CellRange(this.table.getSelectedRows(), this.table.getSelectedColumns());
            if (isCut) {
                this.history.add(this.tableModel, range);
            }
            StringBuffer sbf = new StringBuffer();
            int startRow = this.table.getSelectedRow();
            int startCol = this.table.getSelectedColumn();
            int numrows = this.table.getSelectedRowCount();
            int numcols = this.table.getSelectedColumnCount();
            this.copyPoint = new CellPoint(this.table.getSelectedRow(), this.table.getSelectedColumn());
            String str = this.tableModel.toString(range, false);
            StringSelection stsel = new StringSelection(str);
            this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
            this.system.setContents(stsel, stsel);
            if (isCut) {
                this.tableModel.clearRange(range);
            }
        } else if (isCut) {
            this.sharp.noCellsSelected("Cut");
        } else {
            this.sharp.noCellsSelected("Copy");
        }
    }

    public void paste() {
        if (this.table.getSelectedRowCount() != 0) {
            int startRow = this.table.getSelectedRow();
            int startCol = this.table.getSelectedColumn();
            int rowOff = startRow - this.copyPoint.getRow();
            int colOff = startCol - this.copyPoint.getCol();
            try {
                String trstring = (String)this.system.getContents(this).getTransferData(DataFlavor.stringFlavor);
                CellPoint size = SharpTableModel.getSize(trstring);
                int endRow = Math.min(this.table.getRowCount() - 1, startRow + size.getRow() - 1);
                int endCol = Math.min(this.table.getColumnCount() - 1, startCol + size.getCol() - 1);
                CellRange affectedRange = new CellRange(startRow, endRow, startCol, endCol);
                this.history.add(this.tableModel, affectedRange);
                this.tableModel.fromString(trstring, rowOff, colOff, affectedRange);
            }
            catch (Exception e) {}
        } else {
            this.sharp.noCellsSelected("Paste");
        }
    }

    public void clear() {
        if (this.table.getSelectedRowCount() != 0) {
            CellRange range = new CellRange(this.table.getSelectedRows(), this.table.getSelectedColumns());
            this.history.add(this.tableModel, range);
            Debug.println("Clear");
            this.tableModel.clearRange(range);
        } else {
            this.sharp.noCellsSelected("Clear");
        }
    }

    public void fill() {
        if (this.table.getSelectedRowCount() != 0) {
            CellRange range = new CellRange(this.table.getSelectedRows(), this.table.getSelectedColumns());
            Cell first = this.tableModel.getCellAt(range.getStartRow(), range.getStartCol());
            String fillValue = null;
            fillValue = first.isFormula() ? "=" + first.getFormula().toString() : first.getValue().toString();
            Object inputValue = SharpOptionPane.showInputDialog(this.sharp, "Please enter a value to fill the range", "Fill", 1, fillIcon, null, fillValue);
            if (inputValue != null && ((String)inputValue).length() != 0) {
                this.history.add(this.tableModel, range);
                this.tableModel.fillRange(range, (String)inputValue);
            }
        } else {
            this.sharp.noCellsSelected("Fill");
        }
    }

    public void find(boolean newValue) {
        CellPoint start;
        if (this.table.getSelectedRowCount() != 0) {
            int x = this.table.getSelectedRow();
            int y = this.table.getSelectedColumn();
            if (!newValue) {
                if (y < this.table.getColumnCount() - 1) {
                    ++y;
                } else {
                    y = 1;
                    ++x;
                }
            }
            start = new CellPoint(x, y);
        } else {
            start = new CellPoint(SharpTools.baseRow, SharpTools.baseCol);
        }
        if (newValue) {
            FindDialog findDialog = new FindDialog(this.sharp, this.findValue, this.matchCase, this.matchCell);
            findDialog.pack();
            findDialog.setLocationRelativeTo(this.sharp);
            findDialog.setVisible(true);
            String inputValue = findDialog.getString();
            if (inputValue == null || inputValue.length() == 0) {
                return;
            }
            this.setFindValue(inputValue);
            this.matchCase = findDialog.isCaseSensitive();
            this.matchCell = findDialog.isCellMatching();
            Debug.println("case sens : " + findDialog.isCaseSensitive());
            Debug.println("match cell : " + findDialog.isCellMatching());
        } else if (!this.hasFindValue()) {
            return;
        }
        CellPoint found = this.tableModel.look(start, SharpTableModel.fieldParser(this.findValue), this.matchCase, this.matchCell);
        if (found != null) {
            this.table.setColumnSelectionInterval(found.getCol(), found.getCol());
            this.table.setRowSelectionInterval(found.getRow(), found.getRow());
            this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(found.getRow(), found.getCol(), true)));
        } else {
            SharpOptionPane.showMessageDialog(this.sharp, "SharpTools has finished the search and no more \"" + this.findValue + "\" is found.", "Find Completed", 1, findIcon);
        }
    }

    public boolean hasFindValue() {
        return this.findValue != null && this.findValue.length() != 0;
    }

    private void setFindValue(String s) {
        this.findValue = s;
        this.sharp.checkFindNextState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().compareTo("Undo") == 0) {
            this.history.undo(this.tableModel);
        } else if (e.getActionCommand().compareTo("Redo") == 0) {
            this.history.redo(this.tableModel);
        } else if (e.getActionCommand().compareTo("Cut") == 0) {
            this.cut();
        } else if (e.getActionCommand().compareTo("Copy") == 0) {
            this.copy();
        } else if (e.getActionCommand().compareTo("Paste") == 0) {
            this.paste();
        } else if (e.getActionCommand().compareTo("Fill") == 0) {
            this.fill();
        } else if (e.getActionCommand().compareTo("Find") == 0) {
            this.find(true);
        } else if (e.getActionCommand().compareTo("Find Next") == 0) {
            this.find(false);
        }
    }
}

