/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.math.density;

import java.util.Arrays;
import jdistlib.math.MathFunctions;
import jdistlib.math.VectorMath;
import jdistlib.math.approx.ApproximationFunction;
import jdistlib.math.approx.ApproximationType;
import jdistlib.math.density.Bandwidth;
import jdistlib.math.density.Kernel;
import jdistlib.util.Utilities;
import org.jtransforms.fft.DoubleFFT_1D;

public class Density {
    public double[] x;
    public double[] y;

    private Density() {
    }

    public static final Density density(double[] x, Bandwidth bandwidth, double adjust, Kernel kernel, double[] weights, double width, int n, double from, double to, double cut) {
        int i;
        double bw;
        int N = x.length;
        int nx = 0;
        if (weights != null && weights.length != N) {
            throw new RuntimeException();
        }
        double[] newx = new double[N];
        double[] new_wt = new double[N];
        double totMass = 0.0;
        double wsum = 0.0;
        for (int i2 = 0; i2 < N; ++i2) {
            if (weights != null && weights[i2] < 0.0) {
                throw new RuntimeException();
            }
            double wt = weights == null ? 1.0 : weights[i2];
            wsum += wt;
            if (!MathFunctions.isFinite(x[i2])) continue;
            newx[nx] = x[i2];
            new_wt[nx] = wt;
            totMass += wt;
            ++nx;
        }
        totMass /= wsum;
        if (nx != N) {
            x = new double[nx];
            System.arraycopy(newx, 0, x, 0, nx);
            weights = new double[nx];
            System.arraycopy(new_wt, 0, weights, 0, nx);
            newx = null;
            new_wt = null;
        } else if (weights == null) {
            weights = new double[N];
            Arrays.fill(weights, 1.0 / (double)N);
        }
        int n_user = n;
        n = Math.max(n, 512);
        if (n > 512) {
            n = 1 << (int)Math.ceil(Math.log(n) / 0.6931471805599453);
        }
        double d = bw = bandwidth != null ? bandwidth.calculate(x) : width / kernel.getFactor();
        if (Double.isInfinite(bw)) {
            throw new RuntimeException("non-finite bandwidth");
        }
        if ((bw *= adjust) <= 0.0) {
            throw new RuntimeException("Bandwidth is not positive");
        }
        if (Double.isNaN(from)) {
            from = VectorMath.min(x) - cut * bw;
        }
        if (Double.isNaN(to)) {
            to = VectorMath.max(x) + cut * bw;
        }
        if (Double.isInfinite(from)) {
            throw new RuntimeException("non-finite 'from'");
        }
        if (Double.isInfinite(to)) {
            throw new RuntimeException("non-finite 'to'");
        }
        double lo = from - 4.0 * bw;
        double up = to + 4.0 * bw;
        double[] y = Density.bindist(x, weights, lo, up, n, totMass);
        double[] kords = Utilities.seq_int(0.0, 2.0 * (up - lo), 2 * n);
        int two_n = 2 * n;
        for (int i3 = n + 1; i3 < two_n; ++i3) {
            kords[i3] = -kords[two_n - i3];
        }
        kords = kernel.process(bw, kords);
        double[] new_kords = new double[kords.length * 2];
        System.arraycopy(kords, 0, new_kords, 0, kords.length);
        DoubleFFT_1D fft = new DoubleFFT_1D(kords.length);
        fft.realForwardFull(new_kords);
        for (int i4 = 1; i4 < new_kords.length; i4 += 2) {
            new_kords[i4] = -new_kords[i4];
        }
        kords = new_kords;
        new_kords = null;
        double[] new_y = new double[y.length * 2];
        System.arraycopy(y, 0, new_y, 0, y.length);
        fft = new DoubleFFT_1D(y.length);
        fft.realForwardFull(new_y);
        y = new_y;
        for (i = 0; i < kords.length; i += 2) {
            double a = kords[i];
            double b = kords[i + 1];
            double c = y[i];
            double d2 = y[i + 1];
            kords[i] = a * c - b * d2;
            kords[i + 1] = a * d2 + b * c;
        }
        fft = new DoubleFFT_1D(kords.length / 2);
        fft.complexInverse(kords, false);
        new_kords = new double[n];
        for (i = 0; i < n; ++i) {
            new_kords[i] = Math.max(0.0, kords[2 * i] / (double)two_n);
        }
        kords = new_kords;
        new_kords = null;
        double[] xords = Utilities.seq_int(lo, up, n);
        x = Utilities.seq_int(from, to, n_user);
        ApproximationFunction fun = new ApproximationFunction(ApproximationType.LINEAR, xords, kords, Double.NaN, Double.NaN, 0.0);
        y = new double[n_user];
        for (int i5 = 0; i5 < n_user; ++i5) {
            y[i5] = fun.eval(x[i5]);
        }
        Density dd = new Density();
        dd.x = x;
        dd.y = y;
        return dd;
    }

    public static final Density density(double[] x) {
        return Density.density(x, Bandwidth.NRD0, 1.0, Kernel.GAUSSIAN, null, 0.0, 512, Double.NaN, Double.NaN, 3.0);
    }

    public static final Density density(double[] x, double adjust) {
        return Density.density(x, Bandwidth.NRD0, adjust, Kernel.GAUSSIAN, null, 0.0, 512, Double.NaN, Double.NaN, 3.0);
    }

    private static final double[] bindist(double[] x, double[] w, double xlo, double xhi, int n, double totMass) {
        int i;
        int ylen = 2 * n;
        double[] y = new double[ylen];
        int ixmin = 0;
        int ixmax = n - 2;
        int xlen = x.length;
        double xdelta = (xhi - xlo) / (double)(n - 1);
        for (i = 0; i < ylen; ++i) {
            y[i] = 0.0;
        }
        for (i = 0; i < xlen; ++i) {
            if (!MathFunctions.isFinite(x[i])) continue;
            double xpos = (x[i] - xlo) / xdelta;
            int ix = (int)Math.floor(xpos);
            double fx = xpos - (double)ix;
            double wi = w[i];
            if (ixmin <= ix && ix <= ixmax) {
                int n2 = ix;
                y[n2] = y[n2] + (1.0 - fx) * wi;
                int n3 = ix + 1;
                y[n3] = y[n3] + fx * wi;
                continue;
            }
            if (ix == -1) {
                y[0] = y[0] + fx * wi;
                continue;
            }
            if (ix != ixmax + 1) continue;
            int n4 = ix;
            y[n4] = y[n4] + (1.0 - fx) * wi;
        }
        i = 0;
        while (i < ylen) {
            int n5 = i++;
            y[n5] = y[n5] * totMass;
        }
        return y;
    }

    public static final void main(String[] args) {
        double[] v = new double[]{67.0, 54.7, 7.0, 48.5, 14.0, 17.2, 20.7, 13.0, 43.4, 40.2, 38.9, 54.5, 59.8, 48.3, 22.9, 11.5, 34.4, 35.1, 38.7, 30.8, 30.6, 43.1, 56.8, 40.8, 41.8, 42.5, 31.0, 31.7, 30.2, 25.9, 49.2, 37.0, 35.9, 15.0, 30.2, 7.2, 36.2, 45.5, 7.8, 33.4, 36.1, 40.2, 42.7, 42.5, 16.2, 39.0, 35.0, 37.0, 31.4, 37.6, 39.9, 36.2, 42.8, 46.4, 24.7, 49.1, 46.0, 35.9, 7.8, 48.2, 15.2, 32.5, 44.7, 42.6, 38.8, 17.4, 40.8, 29.1, 14.6, 59.2};
        Density.density(v, Bandwidth.NRD0, 1.0, Kernel.GAUSSIAN, null, 0.0, 512, Double.NaN, Double.NaN, 3.0);
    }
}

