/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.evd;

import jdistlib.Exponential;
import jdistlib.generic.GenericDistribution;
import jdistlib.rng.RandomEngine;

public class Fretchet
extends GenericDistribution {
    protected double loc;
    protected double scale;
    protected double shape;

    public static final double density(double x, double loc, double scale, double shape, boolean log) {
        if (scale <= 0.0 || shape <= 0.0) {
            return Double.NaN;
        }
        if ((x = (x - loc) / scale) >= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        x = Math.log(shape / scale) - (1.0 + shape) * Math.log(-x) - Math.pow(x, -shape);
        return !log ? Math.exp(x) : x;
    }

    public static final double cumulative(double q, double loc, double scale, double shape, boolean lower_tail) {
        if (scale <= 0.0 || shape <= 0.0) {
            return Double.NaN;
        }
        q = Math.exp(Math.pow(-Math.max((q - loc) / scale, 0.0), -shape));
        return !lower_tail ? 1.0 - q : q;
    }

    public static final double quantile(double p, double loc, double scale, double shape, boolean lower_tail) {
        if (p <= 0.0 || p >= 1.0 || scale < 0.0 || shape <= 0.0) {
            return Double.NaN;
        }
        if (!lower_tail) {
            p = 1.0 - p;
        }
        return loc + scale * Math.pow(-Math.log(p), -1.0 / shape);
    }

    public static final double random(double loc, double scale, double shape, RandomEngine random) {
        if (scale < 0.0 || shape <= 0.0) {
            return Double.NaN;
        }
        return loc + scale * Math.pow(Exponential.random_standard(random), -1.0 / shape);
    }

    public static final double[] random(int n, double loc, double scale, double shape, RandomEngine random) {
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = Fretchet.random(loc, scale, shape, random);
        }
        return rand;
    }

    public Fretchet(double loc, double scale, double shape) {
        this.loc = loc;
        this.scale = scale;
        this.shape = shape;
    }

    @Override
    public double density(double x, boolean log) {
        return Fretchet.density(x, this.loc, this.scale, this.shape, log);
    }

    @Override
    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        p = Fretchet.cumulative(p, this.loc, this.scale, this.shape, lower_tail);
        return log_p ? Math.log(p) : p;
    }

    @Override
    public double quantile(double q, boolean lower_tail, boolean log_p) {
        if (log_p) {
            q = Math.exp(q);
        }
        return Fretchet.quantile(q, this.loc, this.scale, this.shape, lower_tail);
    }

    @Override
    public double random() {
        return Fretchet.random(this.loc, this.scale, this.shape, this.random);
    }
}

