/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Gamma;
import jdistlib.generic.GenericDistribution;
import jdistlib.rng.RandomEngine;

public class Nakagami
extends GenericDistribution {
    protected double m;
    protected double omega;

    public static final double density(double x, double m, double omega, boolean give_log) {
        return Gamma.density(Math.sqrt(x), m, omega / m, give_log);
    }

    public static final double cumulative(double x, double m, double omega, boolean lower_tail, boolean log_p) {
        return Gamma.cumulative(Math.sqrt(x), m, omega / m, lower_tail, log_p);
    }

    public static final double quantile(double x, double m, double omega, boolean lower_tail, boolean log_p) {
        return Math.sqrt(Gamma.quantile(x, m, omega / m, lower_tail, log_p));
    }

    public static final double random(double m, double omega, RandomEngine random) {
        return Math.sqrt(Gamma.random(m, omega / m, random));
    }

    public static final double[] random(int n, double m, double omega, RandomEngine random) {
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = Nakagami.random(m, omega, random);
        }
        return rand;
    }

    public Nakagami(double m, double omega) {
        this.m = m;
        this.omega = omega;
    }

    @Override
    public double density(double x, boolean log) {
        return Nakagami.density(x, this.m, this.omega, log);
    }

    @Override
    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return Nakagami.cumulative(p, this.m, this.omega, lower_tail, log_p);
    }

    @Override
    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return Nakagami.quantile(q, this.m, this.omega, lower_tail, log_p);
    }

    @Override
    public double random() {
        return Nakagami.random(this.m, this.omega, this.random);
    }
}

