/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Beta;
import jdistlib.generic.GenericDistribution;
import jdistlib.rng.RandomEngine;

public class BetaPrime
extends GenericDistribution {
    protected double a;
    protected double b;

    public static final double density(double x, double a, double b, boolean give_log) {
        return Beta.density(x / (1.0 - x), a, b, give_log);
    }

    public static final double cumulative(double x, double a, double b, boolean lower_tail, boolean log_p) {
        return Beta.cumulative(x / (1.0 - x), a, b, lower_tail, log_p);
    }

    public static final double quantile(double p, double a, double b, boolean lower_tail, boolean log_p) {
        p = Beta.quantile(p, a, b, lower_tail, log_p);
        return p / (p + 1.0);
    }

    public static final double random(double a, double b, RandomEngine random) {
        if (a <= 0.0 || b <= 0.0) {
            return Double.NaN;
        }
        double u1 = random.nextDouble();
        u1 = (double)((int)(1.34217728E8 * u1)) + random.nextDouble();
        u1 = Beta.quantile(u1 / 1.34217728E8, a, b, true, false);
        return u1 / (u1 + 1.0);
    }

    public static final double[] random(int n, double a, double b, RandomEngine random) {
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = BetaPrime.random(a, b, random);
        }
        return rand;
    }

    public BetaPrime(double a, double b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public double density(double x, boolean log) {
        return BetaPrime.density((int)x, this.a, this.b, log);
    }

    @Override
    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return BetaPrime.cumulative((int)p, this.a, this.b, lower_tail, log_p);
    }

    @Override
    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return BetaPrime.quantile(q, this.a, this.b, lower_tail, log_p);
    }

    @Override
    public double random() {
        return BetaPrime.random(this.a, this.b, this.random);
    }
}

