/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.maths.demo;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import org.uncommons.maths.random.AESCounterRNG;
import org.uncommons.maths.random.CMWC4096RNG;
import org.uncommons.maths.random.CellularAutomatonRNG;
import org.uncommons.maths.random.JavaRNG;
import org.uncommons.maths.random.MersenneTwisterRNG;
import org.uncommons.maths.random.XORShiftRNG;
import org.uncommons.swing.SpringUtilities;

class RNGPanel
extends JPanel {
    private final JComboBox rngCombo = new JComboBox();
    private final SpinnerNumberModel iterationsNumberModel = new SpinnerNumberModel(10000, 10, 1000000, 100);
    private final SortedMap<String, Random> rngs = new TreeMap<String, Random>();

    public RNGPanel() {
        super(new SpringLayout());
        try {
            this.rngs.put("AES", new AESCounterRNG());
            this.rngs.put("Cellular Automaton", new CellularAutomatonRNG());
            this.rngs.put("CMWC 4096", new CMWC4096RNG());
            this.rngs.put("JDK RNG", new JavaRNG());
            this.rngs.put("Mersenne Twister", new MersenneTwisterRNG());
            this.rngs.put("SecureRandom", new SecureRandom());
            this.rngs.put("XOR Shift", new XORShiftRNG());
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalStateException("Failed to initialise RNGs.", ex);
        }
        for (String name : this.rngs.keySet()) {
            this.rngCombo.addItem(name);
        }
        this.rngCombo.setSelectedIndex(3);
        this.add(this.rngCombo);
        this.add(new JLabel("No. Values: "));
        this.add(new JSpinner(this.iterationsNumberModel));
        this.setBorder(BorderFactory.createTitledBorder("RNG"));
        SpringUtilities.makeCompactGrid(this, 3, 1, 6, 6, 6, 6);
    }

    public Random getRNG() {
        return (Random)this.rngs.get((String)this.rngCombo.getSelectedItem());
    }

    public int getIterations() {
        return this.iterationsNumberModel.getNumber().intValue();
    }
}

