/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.maths.demo;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.uncommons.maths.number.NumberGenerator;

abstract class ProbabilityDistribution {
    ProbabilityDistribution() {
    }

    protected abstract NumberGenerator<?> createValueGenerator(Random var1);

    public Map<Double, Double> generateValues(int count, Random rng) {
        Map<Double, Double> values = this.isDiscrete() ? this.generateDiscreteValues(count, rng) : this.generateContinuousValues(count, rng);
        double sum = 0.0;
        for (Double key : values.keySet()) {
            Double value = values.get(key);
            values.put(key, value / (double)count);
            sum += value.doubleValue();
        }
        assert (Math.round(sum) == (long)count) : "Wrong total: " + sum;
        return values;
    }

    private Map<Double, Double> generateDiscreteValues(int count, Random rng) {
        NumberGenerator<?> generator = this.createValueGenerator(rng);
        HashMap<Double, Double> values = new HashMap<Double, Double>();
        for (int i = 0; i < count; ++i) {
            double value = ((Number)generator.nextValue()).doubleValue();
            Double aggregate = (Double)values.get(value);
            aggregate = aggregate == null ? 0.0 : aggregate;
            aggregate = aggregate + 1.0;
            values.put(value, aggregate);
        }
        return values;
    }

    private Map<Double, Double> generateContinuousValues(int count, Random rng) {
        NumberGenerator<?> generator = this.createValueGenerator(rng);
        double[] values = new double[count];
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (int i = 0; i < count; ++i) {
            double value = ((Number)generator.nextValue()).doubleValue();
            min = Math.min(value, min);
            max = Math.max(value, max);
            values[i] = value;
        }
        return ProbabilityDistribution.doQuantization(max, min, values);
    }

    protected static Map<Double, Double> doQuantization(double max, double min, double[] values) {
        double range = max - min;
        int noIntervals = 20;
        double intervalSize = range / (double)noIntervals;
        int[] intervals = new int[noIntervals];
        for (double value : values) {
            int interval = Math.min(noIntervals - 1, (int)Math.floor((value - min) / intervalSize));
            assert (interval >= 0 && interval < noIntervals) : "Invalid interval: " + interval;
            int n = interval;
            intervals[n] = intervals[n] + 1;
        }
        HashMap<Double, Double> discretisedValues = new HashMap<Double, Double>();
        for (int i = 0; i < intervals.length; ++i) {
            double value = 1.0 / intervalSize * (double)intervals[i];
            discretisedValues.put(min + ((double)i + 0.5) * intervalSize, value);
        }
        return discretisedValues;
    }

    public abstract Map<Double, Double> getExpectedValues();

    public abstract double getExpectedMean();

    public abstract double getExpectedStandardDeviation();

    public abstract String getDescription();

    public abstract boolean isDiscrete();
}

