/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.maths.demo;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.uncommons.maths.demo.ProbabilityDistribution;
import org.uncommons.maths.random.ExponentialGenerator;

class ExponentialDistribution
extends ProbabilityDistribution {
    private final double rate;

    public ExponentialDistribution(double rate) {
        this.rate = rate;
    }

    protected ExponentialGenerator createValueGenerator(Random rng) {
        return new ExponentialGenerator(this.rate, rng);
    }

    @Override
    public Map<Double, Double> getExpectedValues() {
        double p;
        HashMap<Double, Double> values = new HashMap<Double, Double>();
        double x = 0.0;
        do {
            p = this.getExpectedProbability(x);
            values.put(x, p);
            x += 1.0 / (2.0 * this.rate);
        } while (p > 0.001);
        return values;
    }

    private double getExpectedProbability(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return this.rate * Math.exp(-this.rate * x);
    }

    @Override
    public double getExpectedMean() {
        return Math.pow(this.rate, -1.0);
    }

    @Override
    public double getExpectedStandardDeviation() {
        return Math.sqrt(Math.pow(this.rate, -2.0));
    }

    @Override
    public String getDescription() {
        return "Exponential Distribution (\u03bb = " + this.rate + ")";
    }

    @Override
    public boolean isDiscrete() {
        return false;
    }
}

