/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.maths.demo;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.uncommons.maths.demo.BinomialParametersPanel;
import org.uncommons.maths.demo.ExponentialParametersPanel;
import org.uncommons.maths.demo.GaussianParametersPanel;
import org.uncommons.maths.demo.ParametersPanel;
import org.uncommons.maths.demo.PoissonParametersPanel;
import org.uncommons.maths.demo.ProbabilityDistribution;
import org.uncommons.maths.demo.UniformParametersPanel;

class DistributionPanel
extends JPanel {
    private final SortedMap<String, ParametersPanel> parameterPanels = new TreeMap<String, ParametersPanel>();
    private final JComboBox distributionCombo = new JComboBox();

    public DistributionPanel() {
        super(new BorderLayout());
        this.parameterPanels.put("Binomial", new BinomialParametersPanel());
        this.parameterPanels.put("Exponential", new ExponentialParametersPanel());
        this.parameterPanels.put("Gaussian", new GaussianParametersPanel());
        this.parameterPanels.put("Poisson", new PoissonParametersPanel());
        this.parameterPanels.put("Uniform", new UniformParametersPanel());
        final CardLayout parametersLayout = new CardLayout();
        final JPanel parametersPanel = new JPanel(parametersLayout);
        for (Map.Entry<String, ParametersPanel> entry : this.parameterPanels.entrySet()) {
            this.distributionCombo.addItem(entry.getKey());
            parametersPanel.add((Component)entry.getValue(), entry.getKey());
        }
        parametersLayout.first(parametersPanel);
        this.distributionCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                parametersLayout.show(parametersPanel, (String)DistributionPanel.this.distributionCombo.getSelectedItem());
            }
        });
        this.add((Component)this.distributionCombo, "North");
        this.add((Component)parametersPanel, "Center");
        this.setBorder(BorderFactory.createTitledBorder("Probability Distribution"));
    }

    public ProbabilityDistribution createProbabilityDistribution() {
        ParametersPanel panel = (ParametersPanel)this.parameterPanels.get(this.distributionCombo.getSelectedItem().toString());
        return panel.createProbabilityDistribution();
    }
}

